<?php
/**
 * The template for displaying page title
 *
 * @package WordPress
 * @subpackage Theme_Name
 * @since Theme_Version 1.0
 */

$page_title = '';
$page_sub_title = '';
$page_title_padding = g5plus_get_option('page_title_padding', array('padding-top' => '65px', 'padding-bottom' => '65px'));
$page_title_parallax = g5plus_get_option('page_title_parallax', 1);
$custome_page_title_enable = g5plus_get_option('custome_page_title_enable', 0);
$style_bg_overlay = array();

if (is_home()) {
	if (empty($page_title)) {
		$page_title = esc_html__("Blog", 'g5-organiz');
	}
} elseif (!is_singular() && !is_front_page()) {
	if (!have_posts()) {
		$page_title = esc_html__('Nothing Found', 'g5-organiz');
	} elseif (is_tag() || is_tax('product_tag')) {
		$page_title = single_tag_title(esc_html__("Tags: ", 'g5-organiz'), false);
	} elseif (is_category() || is_tax()) {
		$page_title = single_cat_title('', false);
	} elseif (is_author()) {
		$page_title = sprintf(esc_html__('Author: %s', 'g5-organiz'), get_the_author());
	} elseif (is_day()) {
		$page_title = sprintf(esc_html__('Daily Archives: %s', 'g5-organiz'), get_the_date());
	} elseif (is_month()) {
		$page_title = sprintf(esc_html__('Monthly Archives: %s', 'g5-organiz'), get_the_date(_x('F Y', 'monthly archives date format', 'g5-organiz')));
	} elseif (is_year()) {
		$page_title = sprintf(esc_html__('Yearly Archives: %s', 'g5-organiz'), get_the_date(_x('Y', 'yearly archives date format', 'g5-organiz')));
	} elseif (is_search()) {
		$page_title = esc_html__('Search Results', 'g5-organiz');
	} elseif (is_tax('post_format', 'post-format-aside')) {
		$page_title = esc_html__('Asides', 'g5-organiz');
	} elseif (is_tax('post_format', 'post-format-gallery')) {
		$page_title = esc_html__('Galleries', 'g5-organiz');
	} elseif (is_tax('post_format', 'post-format-image')) {
		$page_title = esc_html__('Images', 'g5-organiz');
	} elseif (is_tax('post_format', 'post-format-video')) {
		$page_title = esc_html__('Videos', 'g5-organiz');
	} elseif (is_tax('post_format', 'post-format-quote')) {
		$page_title = esc_html__('Quotes', 'g5-organiz');
	} elseif (is_tax('post_format', 'post-format-link')) {
		$page_title = esc_html__('Links', 'g5-organiz');
	} elseif (is_tax('post_format', 'post-format-status')) {
		$page_title = esc_html__('Statuses', 'g5-organiz');
	} elseif (is_tax('post_format', 'post-format-audio')) {
		$page_title = esc_html__('Audios', 'g5-organiz');
	} elseif (is_tax('post_format', 'post-format-chat')) {
		$page_title = esc_html__('Chats', 'g5-organiz');
	}
}
if (is_404()) {
	$page_title = esc_html__('404 Error', 'g5-organiz');
}
$page_title_enable = g5plus_get_option('page_title_enable', 1);
if ($custome_page_title_enable) {
	$page_title = g5plus_get_option('page_title', $page_title);
}
$page_title_bg_image = g5plus_get_option('page_title_bg_image', array('url' => G5PLUS_THEME_URL . 'assets/images/page-title.jpg'));
$page_title_bg_image = isset($page_title_bg_image['url']) ? $page_title_bg_image['url'] : '';
$page_title_bg_color_enable = g5plus_get_option('page_title_bg_color_enable', 1);
$page_title_bg_image_position = g5plus_get_option('page_title_bg_image_position', 'top-center');
$page_breadcrumbs_enable = g5plus_get_option('breadcrumbs_enable', 1);
if (is_singular()) {
	if (!$page_title) {
		$page_title = get_the_title(get_the_ID());
	}

	$custom_page_title_visible = g5plus_get_rwmb_meta('custom_page_title_visible');
	if (($custom_page_title_visible !== '-1') && ($custom_page_title_visible !== '')) {
		$page_title_enable = $custom_page_title_visible;
	}

	$custom_breadcrumbs_visible = g5plus_get_rwmb_meta('custom_breadcrumbs_visible');
	if (($custom_breadcrumbs_visible !== '-1') && ($custom_breadcrumbs_visible !== '')) {
		$page_breadcrumbs_enable = $custom_breadcrumbs_visible;
	}

	$is_custom_page_title_bg_overlay = g5plus_get_rwmb_meta('is_custom_page_title_bg_overlay');
	if (($is_custom_page_title_bg_overlay !== '-1') && ($is_custom_page_title_bg_overlay !== '')) {
		$page_title_bg_color_overlay = $is_custom_page_title_bg_overlay;
	}

	$is_custom_page_title = g5plus_get_rwmb_meta('is_custom_page_title');
	if ($is_custom_page_title) {
		$page_title = g5plus_get_rwmb_meta('custom_page_title');
		$page_sub_title = g5plus_get_rwmb_meta('custom_page_sub_title');
	}

	if ($page_title_bg_color_enable == 1) {
		$page_title_bg_color = g5plus_get_option('page_title_bg_color', '#000');
		$page_title_bg_color_overlay = g5plus_get_option('page_title_bg_color_overlay', '60') / 100;
		if (!empty($page_title_bg_color)) {
			$style_bg_overlay[] = 'background-color: ' . $page_title_bg_color . ';';
		}
		if (($page_title_bg_color_overlay < 100) && ($page_title_bg_color_overlay >= 0)) {
			$style_bg_overlay[] = 'opacity:' . $page_title_bg_color_overlay . ';';
		}
	}

	$is_custom_page_title_bg = g5plus_get_rwmb_meta('is_custom_page_title_bg');
	if ($is_custom_page_title_bg) {
		$page_title_bg_image = g5plus_get_rwmb_meta_image('custom_page_title_bg_image');
		$page_title_bg_image_position = g5plus_get_rwmb_meta('custom_page_title_bg_image_position');
		$is_custom_page_title_bg_overlay = g5plus_get_rwmb_meta('is_custom_page_title_bg');
		if ($is_custom_page_title_bg_overlay) {
			$page_title_bg_color = g5plus_get_rwmb_meta('custom_page_title_bg_color');
			$page_title_bg_color_overlay = g5plus_get_rwmb_meta('custom_page_title_bg_color_overlay') / 100;
			if (!empty($page_title_bg_color)) {
				$style_bg_overlay[] = 'background-color: ' . $page_title_bg_color . ';';
			}
			if (($page_title_bg_color_overlay < 100) && ($page_title_bg_color_overlay >= 0)) {
				$style_bg_overlay[] = 'opacity:' . $page_title_bg_color_overlay . ';';
			}
		}
	}
} elseif (is_category() || is_tax()) {
	$cat = get_queried_object();
	if ($cat && property_exists($cat, 'term_id')) {
		$custom_page_title_enable = g5plus_get_tax_meta($cat->term_id, 'page_title_enable');
		if ($custom_page_title_enable != '' && $custom_page_title_enable != -1) {
			$page_title_enable = $custom_page_title_enable;
		}

		$bg_image = g5plus_get_tax_meta($cat->term_id, 'page_title_bg_image');
		if (isset($bg_image['url'])) {
			$page_title_bg_image = $bg_image['url'];
		}

		$term_description = strip_tags(term_description());
		if ($term_description) {
			$page_sub_title = $term_description;
		}
	}
}

if (!$page_title_enable) return;

$page_title = apply_filters('g5plus_page_title', $page_title);
$page_sub_title = apply_filters('g5plus_sub_page_title', $page_sub_title);

$page_title_class = array('page-title');

// region Custom Styles

$custom_styles = array();
if (isset($page_title_padding['padding-top']) && !empty($page_title_padding['padding-top']) && ($page_title_padding['padding-top'] != 'px')) {
	$custom_styles[] = "padding-top:" . $page_title_padding['padding-top'] . (strpos($page_title_padding['padding-top'], 'px') ? '' : 'px');;
} else {

}
if (isset($page_title_padding['padding-bottom']) && !empty($page_title_padding['padding-bottom']) && ($page_title_padding['padding-bottom'] != 'px')) {
	$custom_styles[] = "padding-bottom:" . $page_title_padding['padding-bottom'] . (strpos($page_title_padding['padding-bottom'], 'px') ? '' : 'px');;
}

if (!empty($page_title_bg_image)) {
	$custom_styles[] = 'background-image: url(' . $page_title_bg_image . ')';
	$page_title_class[] = 'page-title-background';

	if ($page_title_parallax) {
		$page_title_class[] = 'page-title-parallax';
	}
	if (empty($page_title_bg_image_position)) {
		$page_title_bg_image_position = g5plus_get_option('page_title_bg_image_position', 'top-center');
	}
	$page_title_class[] = $page_title_bg_image_position;
}

$custom_style = '';
if ($custom_styles) {
	$custom_style = 'style="' . join(';', $custom_styles) . '"';
}
if (!empty($page_title_bg_image) && $page_title_parallax) {
	$custom_style .= ' data-stellar-background-ratio="0.5"';
}

if (!empty($style_bg_overlay)) {
	$style_bg_overlay = 'style="' . join(' ', $style_bg_overlay) . '"';
} else {
	$style_bg_overlay = '';
}

// endregion
?>
<section class="<?php echo join(' ', $page_title_class); ?>" <?php echo wp_kses_post($custom_style); ?>>
	<?php if ($page_title_bg_color_enable == 1): ?>
		<div class="page-title-bg_overlay" <?php echo wp_kses_post($style_bg_overlay); ?>></div>
	<?php endif; ?>
	<div class="container">
		<div class="page-title-inner">
			<h1><?php echo esc_html($page_title) ?></h1>
			<?php if (!empty($page_sub_title)): ?>
				<p><?php echo esc_html($page_sub_title) ?></p>
			<?php endif; ?>
			<?php if ($page_breadcrumbs_enable) {
				get_template_part('templates/breadcrumb');
			} ?>
		</div>
	</div>
</section>