@extends('layouts.master')

@section('css')
<style type="text/css">
	.item-large{
		width:100%;
	}
</style>

@if(!Auth::guest() && (Auth::user()->admin == 1 || Auth::user()->id == $media->user_id))
	<link rel="stylesheet" href="{{ URL::asset('assets/js/tagsinput/jquery.tagsinput.css') }}" />
@endif

@stop

@section('content')

<?php $settings = Setting::first(); ?>

<?php $item = $media; ?>

<div class="container main_home_container single">

	<div class="single-left col-md-8 col-lg-8 col-sm-12">
		
		<div class="col-sm-12 item animated single-left" data-href="{{ URL::to('media') . '/' . $media->id }}">

			@include('includes.media_item')

			<div style="clear:both"></div>

			<?php $media_url = URL::to('media') . '/' . $item->slug; ?>
		
			<div id="below_media">
				<div class="social-icons">
				    <ul class="socialcount socialcount-large" data-url="{{ $media_url }}" style="width:100%; position:relative; right:0px">
						<li class="facebook"><a href="https://www.facebook.com/sharer/sharer.php?u={{ $media_url }}" target="_blank" title="Share on Facebook"><span class="fa fa-facebook"></span><span class="count">Like</span></a></li>
						<li class="twitter" data-share-text="{{ $media->title }}"><a href="https://twitter.com/intent/tweet?url={{ $media_url }}&text={{ $media->title }}" data-url="{{ $media_url }}" title="Share on Twitter"><span class="fa fa-twitter" data-url="{{ $media_url }}"></span><span class="count">Tweet</span></a></li>
						<li class="googleplus"><a href="https://plus.google.com/share?url={{ $media_url }}" target="_blank" title="Share on Google Plus"><span class="fa fa-google-plus"></span><span class="count">+1</span></a></li>
						<li class="pinterest"><a href="//www.pinterest.com/pin/create/button/?url={{ $media_url }}&media={{ URL::to('/') . '/uploads/images/' . $media->pic_url }}&description={{ $media->title }}" title="Pin It" target="_blank"><span class="fa fa-pinterest"></span><span class="count">Pin It</span></a></li>
					</ul>
				</div>


				@if(!Auth::guest())
					<?php $flagged = MediaFlag::where('user_id', '=', Auth::user()->id)->where('media_id', '=', $media->id)->first(); ?>
					<div class="media-flag pull-right border-radius @if(isset($flagged->id)) active @endif" data-id="{{ $media->id }}" style="margin-top:5px;"><i class="fa fa-flag"></i> <span class="media-flag-desc">@if(isset($flagged->id)){{ 'Question Flagged' }}@else{{ 'flag this?' }}@endif</span></div>
				@endif

				@if(!Auth::guest() && (Auth::user()->admin == 1 || Auth::user()->id == $item->user_id))
				
				<div class="edit-delete">
					<a href="#_" data-href="{{ URL::to('media/delete') . '/' . $item->id }}" onclick="confirm_delete(this)" class="label label-danger"><i class="icon-trash"></i> Delete</a>
					<a href="#_" data-toggle="modal" data-target="#edit-modal" class="label label-warning"><i class="icon-edit"></i> Edit</a>
				</div>
				@endif
			</div>
		

			<div style="clear:both"></div>

			<div class="comment-submit">
				@if(Auth::guest())
					<h2 style="padding-left:0px; text-align:center;">Please <a href="{{ URL::to('signin') }}">Signin</a> or <a href="{{ URL::to('signup') }}">Signup</a> to add a comment</h2>
				@else
					<img src="{{ URL::to('/') }}/uploads/avatars/{{ Auth::user()->avatar }}" class="user-avatar-small img-circle" /><h2>Add a comment</h2>
					<textarea placeholder="Write your comment here" class="form-control" style="border-width:2px;" id="comment"></textarea>
					<div class="btn pull-right btn-color" style="margin-top:15px;" id="comment-submit">Post Comment</div><div style="clear:both"></div>
					<input type="hidden" name="media_id" id="media_id" value="{{ $media->id }}" />
				@endif
			</div>

			<h3 style="font-size:14px;">(<span class="current_comment_count">{{ $media->comments()->get()->count() }}</span>) comments</h3>

			<div id="current_comments">

				

				@foreach($media->comments()->orderBy('created_at', 'desc')->get() as $comment)

					<div class="comment comment-{{ $comment->id }}">
						
						@if(!Auth::guest())
							<?php $user_vote = CommentVote::where('user_id', '=', Auth::user()->id)->where('comment_id', '=', $comment->id)->first(); ?>
						@endif

						<div class="comment_vote pull-left">
							<i class="fa fa-chevron-up vote-up @if(isset($user_vote->up) && $user_vote->up) active @endif" data-commentid="{{ $comment->id }}"></i>
							<p>{{ $comment->totalVotes() }}</p>
							<i class="fa fa-chevron-down vote-down @if(isset($user_vote->down) && $user_vote->down == 1) active @endif" data-commentid="{{ $comment->id }}"></i>
						</div>

						@if(!Auth::guest())
							
							<div class="flag_edit_delete_comment">
								<a class="flag_comment" data-id="{{ $comment->id }}"><i class="fa fa-flag"></i> + <span class="num_flags">{{ $comment->totalFlags() }}</span></a>@if(Auth::user()->id == $comment->user_id  || Auth::user()->admin == 1)<a class="edit_comment" data-id="{{ $comment->id }}"><i class="fa fa-edit"></i></a><a class="delete_comment" data-id="{{ $comment->id }}"><i class="fa fa-trash-o"></i></a>@endif
							</div>

						@endif

						<div class="comment_container border-radius" data-id="{{ $comment->id }}">
							
							<img src="{{ URL::to('/') }}/uploads/avatars/{{ $comment->user()->avatar }}" class="user-avatar-small img-circle" /><h4>wrote:</h4>
							<p>{{ $comment->comment }}</p>
							@if(isset($comment->pic_url))
								<img src="{{ URL::to('/') }}/uploads/images/{{ $comment->pic_url }}" style="width:100%;" />
							@endif

							@if(isset($comment->vid_url))
								<?php $video = explode('/watch?v=', $comment->vid_url); ?>
								<iframe title="YouTube video player" class="youtube-player" type="text/html" width="620"
					height="330" src="http://www.youtube.com/embed/{{ $video[1] }}" frameborder="0"
					allowFullScreen></iframe>
							@endif

						</div>
					</div>

				@endforeach

			</div><!-- #current_comments -->

		</div>

	</div>


	<input type="hidden" id="user_media" name="user_media" value="@if(!Auth::guest() && Auth::user()->id == $media->user_id){{ 'true' }}@else{{ 'false' }}@endif" />

	<input type="hidden" id="user_id" name="user_id" value="@if(!Auth::guest()){{ Auth::user()->id }}@else0@endif" />

	<!-- Right Side Bar -->
	<div class="single-right col-lg-4 col-md-4">


		<ul class="nav nav-pills pull-left" style="margin-bottom:15px;">
		  @if(isset($previous->id)) <li class=""><a href="{{ URL::to('media') . '/' . $previous->slug }}" class="btn btn-info btn-prev" style="padding:10px;">Previous</a></li>@endif
		   @if(isset($next->id)) <li class=""><a href="{{ URL::to('media') . '/' . $next->slug }}" style="padding:10px;" class="btn btn-info btn-next">Next</a></li>@endif
		</ul>


		<ul style="margin-bottom:15px;" id="next_media">
		<?php $prev_media_list = ''; ?>
		@foreach($media_prev as $prev_media)

			
			<?php
			if($prev_media->id == $media->id) {
				$isActive = 'active';
			} else {
				$isActive = '';
			} ?>


			<?php $prev_media_list = "<li class='col-md-4'><a href='" . URL::to('media') . '/' . $prev_media->slug . "'><div class='imgLiquidFill imgLiquid " . $isActive . "' style='width:95px; height:95px;'><img alt='...' src='" . URL::to('/') . '/uploads/images/' . $prev_media->pic_url . "' /></div></a></li>" . $prev_media_list; ?>

		@endforeach

		<?php echo $prev_media_list; ?>

		@foreach($media_next as $next_media)

			<li class="col-md-4"><a href="{{ URL::to('media') . '/' . $next_media->slug }}"><div class="imgLiquidFill imgLiquid @if($next_media->id == $media->id) active @endif" style="width:95px; height:95px;"><img alt="..." src="{{ URL::to('/') . '/uploads/images/' . $next_media->pic_url }}" /></div></a></li>

		@endforeach
		</ul>

		<div style="clear:both"></div>

		<?php $tags = explode(',', $media->tags); ?>

		@if(count($tags) > 1)

		<h4>Tags</h4>

		<ul class="tags">
			@foreach($tags as $tag)
				<li><a href="{{ URL::to('tags') . '/' . $tag }}">{{ $tag }}</a></li>
			@endforeach
		</ul>
		<div style="clear:both"></div>

		@endif

		@if(isset($settings->square_ad) && !empty($settings->square_ad))
			{{ $settings->square_ad }}
		@else
			<img src="http://placehold.it/300x250&text=Advertisement" style='position:relative; left:1px; width:100%; overflow:hidden' />
		@endif
		

	</div><!-- single-right -->

</div>


<script type="text/javascript" src="{{ URL::asset('assets/js/imgLiquid-min.js') }}"></script>

@include('media.show-javascript')

<script type="text/javascript">
	
	$(document).ready(function(){

		$(".imgLiquidFill").imgLiquid();
	});

	function googlePlusShare(plusone){
		if(plusone.state == 'on'){
			$.post('{{ URL::to("add_user_point") }}', function(){});
		} else {

		}
	}
</script>

@stop

@section('javascript')

@if(!Auth::guest() && (Auth::user()->admin == 1 || Auth::user()->id == $item->user_id))
	<!-- Edit Modal -->
	<?php $categories = Category::all(); ?>
	<div class="modal fade" id="edit-modal" data-id="{{ $item->id }}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	  <div class="modal-dialog">
	    <div class="modal-content">
	      <div class="modal-header">
	        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
	        <h4 class="modal-title" id="myModalLabel">Editing {{ $item->title }}</h4>
	      </div>
	      <div class="modal-body">
	      
	      	{{ Form::model($media, array('method' => 'PATCH', 'route' => array('media.update', $item->id))) }}
			<ul>
		        <li>
		            <label for="title">Title</label>
		            <input type="text" class="form-control" name="title" id="title" value="{{ $item->title }}" />
		        </li>

		        <li>
		        	<label for="title">Category</label>
		        	<select class="form-control" id="category" name="category">
		        		@foreach($categories as $category)
		        			<option value="{{ $category->id }}" @if($category->id == $item->category_id) selected="selected" @endif>{{ $category->name }}</option>
		        		@endforeach
		        	</select>
		        </li>

		        <li>
		            <label for="source">Source</label>
		            <input type="text" class="form-control" name="source" id="source" value="{{ $item->link_url }}" />
		        </li>

		        <li>
		            <label for="title">Tags</label>
		            <input class="form-control tags_input" name="tags" id="tags" value="{{ $item->tags }}" style="width:100%; height:auto;" />
		        </li>
			</ul>
			<input type="hidden" id="id" name="id" value="{{ $item->id }}" />
			<input type="hidden" id="redirect" name="redirect" value="{{ Request::url() }}" />

	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
	        <input type="submit" class="btn btn-color" value="Update Media" />
	      </div>
	      {{ Form::close() }}
	    </div><!-- /.modal-content -->
	  </div><!-- /.modal-dialog -->
	</div><!-- /.modal -->

	<script type="text/javascript" src="{{ URL::asset('assets/js/tagsinput/jquery.tagsinput.js') }}"></script>
	<script>
		$(document).ready(function(){
			$('.tags_input').tagsInput();
		});

		function confirm_delete(obj){
			var delete_link = $(obj).data('href');
			var result = confirm('Are you sure you want to delete this item?');
			if(result){
				location.href=delete_link;
			}
		}
	</script>
@endif

@stop

