@extends('layouts.scaffold')

@section('main')

<h1>All Media</h1>

<p>{{ link_to_route('media.create', 'Add new media') }}</p>

@if ($media->count())
	<table class="table table-striped table-bordered">
		<thead>
			<tr>
				<th>User_id</th>
				<th>Title</th>
				<th>Active</th>
				<th>Vid</th>
				<th>Pic</th>
				<th>Pic_url</th>
				<th>Vid_embed</th>
				<th>Link_url</th>
				<th>Tags</th>
			</tr>
		</thead>

		<tbody>
			@foreach ($media as $media)
				<tr>
					<td>{{{ $media->user_id }}}</td>
					<td>{{{ $media->title }}}</td>
					<td>{{{ $media->active }}}</td>
					<td>{{{ $media->vid }}}</td>
					<td>{{{ $media->pic }}}</td>
					<td>{{{ $media->pic_url }}}</td>
					<td>{{{ $media->vid_embed }}}</td>
					<td>{{{ $media->link_url }}}</td>
					<td>{{{ $media->tags }}}</td>
                    <td>{{ link_to_route('media.edit', 'Edit', array($media->id), array('class' => 'btn btn-info')) }}</td>
                    <td>
                        {{ Form::open(array('method' => 'DELETE', 'route' => array('media.destroy', $media->id))) }}
                            {{ Form::submit('Delete', array('class' => 'btn btn-danger')) }}
                        {{ Form::close() }}
                    </td>
				</tr>
			@endforeach
		</tbody>
	</table>
@else
	There are no media
@endif

@stop
