@extends('layouts.master')

@section('css')
    <link rel="stylesheet" href="{{ URL::asset('assets/js/tagsinput/jquery.tagsinput.css') }}" />
@stop

@section('content')

<div class="container main_home_container">

    <div class="col-md-8 col-lg-8">

        <form method="POST" action="{{ URL::to('media') }}" id="media-form" accept-charset="UTF-8" file="1" enctype="multipart/form-data">
            
            <h2><i class="icon-cloud-upload"></i> Upload</h2>

            <input type="hidden" class="form-control" name="user_id" id="user_id" value="{{ Auth::user()->id }}" />

            <!-- Select between an image or a video -->
            <div class="btn-group vid-pic" data-toggle="buttons">
              <label class="btn btn-radio active">
                <input type="radio" name="pic" id="pic" checked> <i class="fa fa-picture-o"></i>  Image
              </label>
              <label class="btn btn-radio">
                <input type="radio" name="vid" id="vid"> <i class="icon-film"></i> Video
              </label>
            </div>

            <p><input name="title" class="form-control" type="text" id="title" placeholder="Title"></p>

            <select name="category_id" id="category_id" class="form-control">
            <option value="1">Select a Category</option>
                @foreach($categories as $category)
                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                @endforeach
            </select>
            
           
            <div style="clear:both"></div>
            <div id="img_upload" style="padding-left:100px; background:#f1f1f1; padding:15px; margin-top:15px; margin-bottom:15px;">
                <i class="fa fa-picture-o" style="font-size:50px; color:#aaa; float:left"></i>
                <p style="margin-left:65px; margin-bottom:6px;"><input type="file" multiple="true" id="pic_url" name="pic_url" style="" /></p>
                <h4 style="margin-left:65px; padding-top:0px;">or enter a URL</h4>
                <p><input type="text" class="form-control" id="img_url" name="img_url" style="" placeholder="Image URL" /></p> 
            </div>

            <div id="vid_upload" style="display:none; padding-left:100px; background:#f1f1f1; padding:15px; margin-top:15px; margin-bottom:15px;">
                <label for="vid_url">
                    <i class="icon-film" style="font-size:50px; color:#aaa; float:left"></i> 
                    <p style="margin-left:65px; margin-bottom:6px; font-weight:normal; margin-top:2px;">Add a Video</p>
                    <h4 style="margin-left:65px; padding-top:0px; margin-top:8px;">Add a Youtube, Vimeo, or Vine URL below:</h4>
                </label>
                <p><input type="text" name="vid_url" class="form-control" id="vid_url" placeholder="Add URL Here" /></p>
            </div>
            
            <p><input name="link_url" class="form-control" type="text" id="link_url" placeholder="Source (Optional)" /></p>
            
            <p><input name="tags" class="form-control" id="tags" placeholder="tags (optional)" /></p>      
            <input class="btn btn-color submit-media" type="submit" value="Submit">

        </form>

        @if ($errors->any())
        	<ul style="margin:0px; padding:0px;">
        		{{ implode('', $errors->all('<li class="error">:message</li>')) }}
        	</ul>
        @endif

    </div>

    @include('includes.sidebar')

</div>

<script type="text/javascript" src="{{ URL::asset('assets/js/tagsinput/jquery.tagsinput.js') }}"></script>

<script type="text/javascript">

    $(document).ready(function(){

        $('#tags').tagsInput();

        $('#img_url').keyup(function (){
            console.log($(this).val());
            if($(this).val() != ''){
                $('#pic_url').attr('disabled', 'true');
            } else {
                $('#pic_url').removeAttr('disabled');
            }
        });

        $('.vid-pic input').change(function(){
            if($(this).attr('id') == 'pic'){
                $('#img_upload').show();
                $('.drop_container').show();
                $('#import-fb').show();
                $('.img-drop').show();
                $('#vid_upload').hide();
            } else{
                console.log('hit');
                $('#vid_upload').show();
                $('#img_upload').hide();
                $('#import-fb').hide();
                $('.img-drop').hide();
                $('.drop_container').hide();
            }
        });


        $('.submit-media').click(function(){
            $('#media-form').submit();
        });
    });

   

    // Setup the dnd listeners.
    //var dropZone = document.getElementById('drop');
    //dropZone.addEventListener('dragover', handleDragOver, false);
    //dropZone.addEventListener('drop', handleFileSelect, false);

    //document.getElementById('files').addEventListener('change', handleFileSelect, false);


</script>

@stop


