<!DOCTYPE html>
<html>
<head>
    <?php $settings = Setting::first(); ?>
    <title>{{ $settings->website_name }} - {{ $settings->website_description }}</title>
    <meta name="viewport" content="initial-scale=1">
    <link rel="stylesheet" href="{{ URL::asset('assets/bootstrap/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ URL::asset('assets/bootstrap/css/bootstrap-theme.min.css') }}" />
    
    <link rel="stylesheet" href="{{ URL::asset('assets/css/plan.min.css') }}" />
    <link rel="stylesheet" href="{{ URL::asset('assets/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ URL::asset('assets/css/style.css') }}" />
    <link rel="stylesheet" href="{{ URL::asset('assets/css/style-responsive.css') }}" />

    @if($settings->color_scheme == 'dark' || (isset($_GET['color_scheme']) && $_GET['color_scheme'] == 'dark') )
      <link rel="stylesheet" href="{{ URL::asset('assets/css/style-dark.css') }}" />
    @endif

    <link rel="stylesheet" href="{{ URL::asset('assets/css/animate.min.css') }}" />
    <link rel="stylesheet" href="{{ URL::asset('assets/css/font-awesome.min.css') }}" />
    <link rel="stylesheet" href="{{ URL::asset('assets/css/noty.css') }}" />
    <link rel="stylesheet" href="{{ URL::asset('assets/css/nprogress.css') }}" />
    
    <link rel="icon" href="{{ URL::to('/') . '/' . $settings->favicon }}" type="image/x-icon">
    <link rel="shortcut icon" href="{{ URL::to('/') . '/' . $settings->favicon }}" type="image/x-icon">
    @yield('css')

    @include('includes.custom_css')

    <!--[if lte IE 8]>
      <script type="text/javascript" src="{{ URL::asset('assets/js/respond.min.js') }}"></script>
    <![endif]-->
    
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery-2.1.0.min.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/bootstrap/js/bootstrap.min.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/masonry.pkgd.min.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/imagesloaded.pkgd.min.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.infinitescroll.min.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.form.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.sticky.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.nearest.min.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.fitvid.js') }}"></script>
    

    @if(isset($media->title) && isset($media->pic_url) && isset($media->description))
      <meta property="og:title" content="{{ $media->title }}"/>
      <meta property="og:image" content="{{ URL::to('/') . '/uploads/images/' . $media->pic_url }}"/>
      <meta property="og:description" content="{{ $media->description }}"/>

      <meta itemprop="name" content="{{ $media->title }}">
      <meta itemprop="description" content="{{ $media->description }}">
      <meta itemprop="image" content="{{ URL::to('/') . '/uploads/images/' . $media->pic_url }}">
    @endif

</head>
<body class="">


	<nav class="navbar navbar-fixed-top" role="navigation">
		<div class="container">
      <!-- Brand and toggle get grouped for better mobile display -->
      <div class="navbar-header">
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-ex1-collapse">
          <span class="sr-only">Toggle navigation</span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
        </button>
        <a class="navbar-brand logo" href="{{ URL::to('/') }}"><img src="{{ URL::to('/') . '/' . $settings->logo }}" style="height:35px; width:auto;" /></a>
      
        <div class="mobile-menu-toggle"><i class="fa fa-bars"></i></div>

        <div class="mobile-menu">

          @if(!Auth::guest())

            

            <?php $user = Auth::user(); ?>
            <?php $user_points = DB::table('points')->where('user_id', '=', $user->id)->sum('points'); ?>
            <a href="{{ URL::to('user') . '/' . $user->username; }}" class="usr-avatar"><img src="{{ URL::to('') }}/uploads/avatars/{{ $user->avatar }}" alt="{{ $user->username }}" class="img-circle user-avatar-large"></a>
            <a href="{{ URL::to('user') . '/' . $user->username; }}" class="username"><h2>{{ $user->username }}</h2></a>
            <p class="points"><i class="fa fa-star" style="color:gold"></i> {{ $user_points }} points</p>
            <div id="avatar-bg"></div>

          @endif

          <ul>
            <li class="@if(Request::is('/') || Request::is('category/*')) active @endif"><a href="{{ URL::to('/') }}"><i class="fa fa-home"></i> Home</a></li>
           <li class="dropdown @if(Request::is('popular/*') || Request::is('popular')) active @endif">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-star"></i> Popular <b class="caret"></b></a>
            <ul class="dropdown-menu">
              <li><a href="{{ URL::to('popular/week') }}">for the Week</a></li>
              <li><a href="{{ URL::to('popular/month') }}">for the Month</a></li>
              <li><a href="{{ URL::to('popular/year') }}">for the Year</a></li>
              <li><a href="{{ URL::to('popular') }}">All Time</a></li>
            </ul>
          </li>
          
          <?php $categories = Category::orderBy('order', 'ASC')->get(); ?>

          <li class="dropdown">
              <a href="#" class="dropdown-toggle categories" data-toggle="dropdown"><i class="fa fa-folder-open"></i> Categories <b class="caret"></b></a>
              
              <ul class="dropdown-menu">
                  <li>
                   
                          @foreach ($categories as $category)
                            <a href="{{ URL::to('category') . '/' . slugify($category->name) }}">{{ $category->name }}</a>
                @endforeach

                   
                  </li>
                </ul>
         </li>
        </ul>  


        <ul class="nav navbar-nav navbar-right">
        @if(Auth::guest())
        
        
            <li class="@if(Request::is('signin')) active @endif"><a href="{{ URL::to('signin') }}">Signin</a></li>
            
            @if($settings->user_registration)
              <li class="@if(Request::is('signup')) active @endif"><a href="{{ URL::to('signup') }}">Signup</a></li>
            @endif

        @else

        <?php $user_points = DB::table('points')->where('user_id', '=', Auth::user()->id)->sum('points'); ?>

          <li class="dropdown">
              <a href="#" class="dropdown-toggle" data-toggle="dropdown" id="user-dropdown"><b class="caret"></b><div id="user-info"><h4><i class="fa fa-gear"></i> Settings</h4></div> </a>
              <ul class="dropdown-menu">
                @if(Auth::user()->admin)
                  <li><a href="{{ URL::to('admin') }}"><i class="fa fa-coffee"></i> Admin</a></li>
                @endif
                <li><a href="{{ URL::to('user') . '/' . Auth::user()->username; }}"><i class="fa fa-user"></i> My Profile</a></li>
                <li><a href="{{ URL::to('logout') }}"><i class="fa fa-power-off"></i> Logout</a></li>
              </ul>
            </li>

        @endif
            @if($settings->user_registration || !Auth::guest())
              <li><a href="{{ URL::to('upload') }}" class="upload-btn"><i class="fa fa-cloud-upload"></i> Upload</a></li>
            @endif
          </ul>


        </div>
      </div>


      <!-- Collect the nav links, forms, and other content for toggling -->
      <div class="collapse navbar-collapse navbar-ex1-collapse">
      
      <ul class="nav navbar-nav navbar-left">
        <!--li><a href="#" id="categories_open"><i class="fa fa-th-list"></i> Categories</a></li-->
        <li class="@if(Request::is('/') || Request::is('category/*')) active @endif"><a href="{{ URL::to('/') }}"><i class="fa fa-home"></i> Home</a><div class="nav-border-bottom"></div></li>
         <li class="dropdown @if(Request::is('popular/*') || Request::is('popular')) active @endif">
          <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-star"></i> Popular <b class="caret"></b><div class="nav-border-bottom"></div></a>
          <ul class="dropdown-menu">
            <li><a href="{{ URL::to('popular/week') }}">for the Week</a></li>
            <li><a href="{{ URL::to('popular/month') }}">for the Month</a></li>
            <li><a href="{{ URL::to('popular/year') }}">for the Year</a></li>
            <li><a href="{{ URL::to('popular') }}">All Time</a></li>
          </ul>
        </li>
        
        <?php $categories = Category::orderBy('order', 'ASC')->get(); ?>

        <li class="dropdown">
            <a href="#" class="dropdown-toggle categories" data-toggle="dropdown"><i class="fa fa-folder-open"></i> Categories <b class="caret"></b><div class="nav-border-bottom"></div></a>
            
            <ul class="dropdown-menu">
                <li>
                 
                        @foreach ($categories as $category)
                          <a href="{{ URL::to('category') . '/' . slugify($category->name) }}">{{ $category->name }}</a>
              @endforeach

                 
                </li>
              </ul>
       </li>
      </ul>  


      <ul class="nav navbar-nav navbar-right">
      
      @if($settings->user_registration || !Auth::guest())
        <li><a href="{{ URL::to('upload') }}" class="upload-btn"><i class="fa fa-cloud-upload"></i> Upload</a></li>
      @endif

      @if(Auth::guest())
    	
    	
          <li class="@if(Request::is('signin')) active @endif"><a href="{{ URL::to('signin') }}">Signin</a><div class="nav-border-bottom"></div></li>
          @if($settings->user_registration)
            <li class="@if(Request::is('signup')) active @endif"><a href="{{ URL::to('signup') }}">Signup</a><div class="nav-border-bottom"></div></li>
          @endif
      @else

      <?php $user_points = DB::table('points')->where('user_id', '=', Auth::user()->id)->sum('points'); ?>

        <li class="dropdown">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown" id="user-dropdown"><img src="{{ URL::to('') }}/uploads/avatars/{{ Auth::user()->avatar }}" class="img-circle" /><b class="caret"></b><div id="user-info"><h4>{{ Auth::user()->username }}</h4><p>{{ $user_points }} points</p></div> </a>
            <ul class="dropdown-menu">
              @if(Auth::user()->admin)
                <li><a href="{{ URL::to('admin') }}"><i class="fa fa-coffee"></i> Admin</a></li>
              @endif
              <li><a href="{{ URL::to('user') . '/' . Auth::user()->username; }}"><i class="fa fa-user"></i> My Profile</a></li>
              <li><a href="{{ URL::to('logout') }}"><i class="fa fa-power-off"></i> Logout</a></li>
            </ul>
          </li>

      @endif
    </ul>



  </div><!-- /.navbar-collapse -->
</div><!-- /.container -->
</nav>

@yield('outer-content')

<div id="main_container">

    @yield('content')

</div>

<div id="footer">
&copy; {{ date('Y') . ' ' . $settings->website_name }}
</div>

<script type="text/javascript" src="{{ URL::asset('assets/js/noty/jquery.noty.js') }}"></script>
<script type="text/javascript" src="{{ URL::asset('assets/js/noty/themes/default.js') }}"></script>
<script type="text/javascript" src="{{ URL::asset('assets/js/noty/layouts/bottomRight.js') }}"></script>
<script type="text/javascript" src="{{ URL::asset('assets/js/noty/layouts/top.js') }}"></script>
<script type="text/javascript" src="{{ URL::asset('assets/js/nprogress.js') }}"></script>

<script type="text/javascript">
  $('document').ready(function(){

    NProgress.start();

    @if(Session::get('note') != '' && Session::get('note_type') != '')
        var n = noty({text: '{{ Session::get("note") }}', layout: 'top', type: '{{ Session::get("note_type") }}', template: '<div class="noty_message"><span class="noty_text"></span><div class="noty_close"></div></div>', closeWith: ['button'], timeout:2000 });
        <?php Session::forget('note');
              Session::forget('note_type');
        ?>
    @endif


  });


  $(window).load(function () {
    NProgress.done();
  });

  $(window).resize(function(){
    jquery_sticky_footer();
  });


  $(window).bind("load", function() {    
    jquery_sticky_footer();
  });

  function jquery_sticky_footer(){
    var footer = $("#footer");
    var pos = footer.position();
    var height = $(window).height();
    height = height - pos.top;
    height = height - footer.outerHeight();
    if (height > 0) {
      footer.css({'margin-top' : height+'px'});
    }
  }

  /********** Mobile Functionality **********/

  var mobileSafari = '';

  $(document).ready(function(){
    $('.mobile-menu-toggle').click(function(){
      $('.mobile-menu').toggle();
      $('body').toggleClass('mobile-margin').toggleClass('body-relative');
      $('.navbar').toggleClass('mobile-margin');
    });


    // Assign a variable for the application being used
    var nVer = navigator.appVersion;
    // Assign a variable for the device being used
    var nAgt = navigator.userAgent;
    var nameOffset,verOffset,ix;
   
   
    // First check to see if the platform is an iPhone or iPod
    if(navigator.platform == 'iPhone' || navigator.platform == 'iPod'){
      // In Safari, the true version is after "Safari" 
      if ((verOffset=nAgt.indexOf('Safari'))!=-1) {
        // Set a variable to use later
        mobileSafari = 'Safari';
      }
    }
   
    // If is mobile Safari set window height +60
    if (mobileSafari == 'Safari') { 
      // Height + 60px
      $('.mobile-menu').css('height', (parseInt($(window).height())+ 60) + 'px' );
    } else {
      // Else use the default window height
      $('.mobile-menu').css('height', $(window).height()); 
    };

  });

  $(window).resize(function(){
    // If is mobile Safari set window height +60
    if (mobileSafari == 'Safari') { 
      // Height + 60px
      $('.mobile-menu').css('height', (parseInt($(window).height())+ 60) + 'px' );
    } else {
      // Else use the default window height
      $('.mobile-menu').css('height', $(window).height()); 
    };
  });

  /********** End Mobile Functionality **********/


</script>

@yield('javascript')


@if(isset($settings->analytics))
  {{ $settings->analytics }}
@endif

</body>
</html>