@extends('layouts.master')

@section('content')

<div class="container">

    <div class="full-container">

		<h1>All Categories</h1>
		<a class="btn btn-info pull-right" style="margin-top:15px;" href="{{ URL::to('/') }}/categories/create">Add New Category</a>

		@if ($categories->count())
			<table class="table table-striped table-bordered">
				<thead>
					<tr>
						<th>Name</th>
						<th>Order</th>
						<th>Edit</th>
						<th>Delete</th>
					</tr>
				</thead>

				<tbody>
					@foreach ($categories as $category)
						<tr>
							<td>{{{ $category->name }}}</td>
							<td>{{{ $category->order }}}</td>
		                    <td>{{ link_to_route('categories.edit', 'Edit', array($category->id), array('class' => 'btn btn-info')) }}</td>
		                    <td>
		                        {{ Form::open(array('method' => 'DELETE', 'route' => array('categories.destroy', $category->id))) }}
		                            {{ Form::submit('Delete', array('class' => 'btn btn-danger')) }}
		                        {{ Form::close() }}
		                    </td>
						</tr>
					@endforeach
				</tbody>
			</table>
		@else
			There are no categories
		@endif

	</div>

</div>

@stop
