@extends('layouts.master')

@section('content')


<div class="container main_home_container">

	<div class="white_container">
		
		<h2 style="margin-bottom:20px;"><i class="fa fa-user"></i><span> Users</span></h2>

		<div class="table-responsive">
			<table class="table table-condensed">
				<tr>
					<th>Username</th>
					<th>Number of Flags</th>
					<th>Actions</th>
					@foreach($users as $user)
					<tr>
						<td><a href="{{ URL::to('user') . '/' . $user->username }}" target="_blank">
							<?php if(strlen($user->username) > 40){
									echo substr($user->username, 0, 40) . '...';
								  } else {
								  	echo $user->username;
								  }
							?>
							</a>
						</td>
						<td>
							{{ $user->totalFlags() }}
						</td>
						<td>
							<!--a href="#" class="btn btn-xs btn-primary" style="margin-right:10px;"><span class="glyphicon glyphicon-edit"></span> Edit</a!-->
							@if($user->active)
								<a href="{{ URL::to('admin/deactivate_user') . '/' . $user->id }}" class="btn btn-xs btn-danger"><span class="fa fa-minus-circle"></span> Disable User</a>
							@else
								<a href="{{ URL::to('admin/activate_user') . '/' . $user->id }}" class="btn btn-xs btn-success"><span class="fa fa-plus-circle"></span> Enable User</a>
							@endif
						</td>
						
					</tr>
					@endforeach
			</table>
		</div>
		
	</div>

</div>

@stop