@extends('layouts.master')

@section('css')
	<link rel="stylesheet" href="{{ URL::asset('assets/js/jquery-minicolors/jquery.minicolors.css') }}" />
@stop

@section('content')

<div class="container main_home_container">

	<div class="left_container col-md-8 col-lg-8">
		
		<h2 style="margin-bottom:20px;"><i class="fa fa-cog"></i><span> Site Settings</span></h2>
		<form method="POST" action="{{ URL::to('admin/') . '/update_settings' }}" id="media-form" accept-charset="UTF-8" file="1" enctype="multipart/form-data">
			<ul>
				<li>
					<label for="website_name">Website name:</label>
					{{ Form::text('website_name', $settings->website_name, array('class'=>'form-control')) }}
				</li>

				<li>
					<label for="website_description">Website description:</label>
					{{ Form::text('website_description', $settings->website_description, array('class'=>'form-control')) }}
				</li>

				<li>
					<label for="logo">Logo:</label>
					<img src="{{ URL::to('/') . '/' . $settings->logo }}" width="200" />
					<input type="file" name="logo" id="logo" style="margin-top:10px;" />
				</li>

				<li>
					<label for="favicon">Favicon:</label>
					<img src="{{ URL::to('/') . '/' . $settings->favicon }}" width="16px" />
					<input type="file" name="favicon" id="favicon" style="margin-top:10px;" />
				</li>

				<li>
					<label for="color_scheme">Color Scheme:</label>
					@if(!isset($settings->color_scheme))
						<?php $settings->color_scheme = ''; ?>
					@endif
					{{ Form::select('color_scheme', array('light' => 'light', 'dark' => 'dark'), $settings->color_scheme) }}
				</li>

				<li>
					@if(isset($settings->primary_color))<?php $primary_color = $settings->primary_color ?>@else<?php $primary_color = ''; ?>@endif
					<label for="primary_color">Primary Color:</label>
					{{ Form::text('primary_color', $primary_color, array('class'=>'form-control', 'id' => 'primary_color',  'style'=> 'width:110px;')) }}
				</li>

				<li>
					@if(isset($settings->secondary_color))<?php $secondary_color = $settings->secondary_color ?>@else<?php $secondary_color = ''; ?>@endif
					<label for="secondary_color">Secondary Color: (The color of the like button and links)</label>
					{{ Form::text('secondary_color', $secondary_color, array('class'=>'form-control', 'id' => 'secondary_color',  'style'=> 'width:110px;')) }}
				</li>

				<li>
					<label for="like_icon">Like icon:</label>
					@if(!isset($settings->like_icon))
						<?php $settings->like_icon = ''; ?>
					@endif
					{{ Form::select('like_icon', array('fa-thumbs-o-up' => 'Thumbs Up', 'fa-star' => 'Star', 'fa-heart' => 'Heart', 'fa-sun-o' => 'Sun', 'fa-smile-o' => 'Smile', 'fa-check' => 'Checkmark'), $settings->like_icon) }}
				</li>

				<li>
					@if(isset($settings->fb_key))<?php $fb_key = $settings->fb_key ?>@else<?php $fb_key = ''; ?>@endif
					<label for="fb_key">Facebook App Key:</label>
					{{ Form::text('fb_key', $fb_key, array('class'=>'form-control')) }}
				</li>

				<li>
					@if(isset($settings->fb_secret_key))<?php $fb_secret_key = $settings->fb_secret_key ?>@else<?php $fb_secret_key = ''; ?>@endif
					<label for="fb_secret_key">Facebook App Secret Key:</label>
					{{ Form::text('fb_secret_key', $fb_secret_key, array('class'=>'form-control')) }}
				</li>

				<li>
					@if(isset($settings->facebook_page_id))<?php $facebook_page_id = $settings->facebook_page_id ?>@else<?php $facebook_page_id = ''; ?>@endif
					<label for="facebook_page_id">Facebook Page ID: ex. facebook.com/page_id (without facebook.com)</label>
					{{ Form::text('facebook_page_id', $facebook_page_id, array('class'=>'form-control')) }}
				</li>

				<li>
					@if(isset($settings->google_key))<?php $google_key = $settings->google_key ?>@else<?php $google_key = ''; ?>@endif
					<label for="google_key">Google Oauth Key:</label>
					{{ Form::text('google_key', $google_key, array('class'=>'form-control')) }}
				</li>

				<li>
					@if(isset($settings->google_secret_key))<?php $google_secret_key = $settings->google_secret_key ?>@else<?php $google_secret_key = ''; ?>@endif
					<label for="google_secret_key">Google Secret Key:</label>
					{{ Form::text('google_secret_key', $google_secret_key, array('class'=>'form-control')) }}
				</li>

				<li>
					@if(isset($settings->google_page_id))<?php $google_page_id = $settings->google_page_id ?>@else<?php $google_page_id = ''; ?>@endif
					<label for="google_page_id">Google Plus User ID:</label>
					{{ Form::text('google_page_id', $google_page_id, array('class'=>'form-control')) }}
				</li>

				<li>
					@if(isset($settings->twitter_page_id))<?php $twitter_page_id = $settings->twitter_page_id ?>@else<?php $twitter_page_id = ''; ?>@endif
					<label for="twitter_page_id">Twitter Username:</label>
					{{ Form::text('twitter_page_id', $twitter_page_id, array('class'=>'form-control')) }}
				</li>

				<li>
					<label for="auto_approve_posts">Auto approve posts:</label>

					@if(isset($settings->auto_approve_posts))<?php $auto_approve = $settings->auto_approve_posts ?>@else<?php $auto_approve = 1 ?>@endif
					{{ Form::checkbox('auto_approve_posts', '', $auto_approve) }}
				</li>

				<li>
					<label for="user_registration">Allow User Registration:</label>

					@if(isset($settings->user_registration))<?php $user_registration = $settings->user_registration ?>@else<?php $user_registration = 1 ?>@endif
					{{ Form::checkbox('user_registration', '', $user_registration) }}
				</li>

				<li>
					<label for="infinite_scroll">Enable Infinite Scroll:</label>

					@if(isset($settings->infinite_scroll))<?php $infinite_scroll = $settings->infinite_scroll ?>@else<?php $infinite_scroll = 1 ?>@endif
					{{ Form::checkbox('infinite_scroll', '', $infinite_scroll) }}
				</li>

				<li>
					@if(isset($settings->square_ad))<?php $square_ad = $settings->square_ad ?>@else<?php $square_ad = ''; ?>@endif
					<label for="square_ad">Sidebar Advertisement (~300x250px) you can add HTML below:</label>
					{{ Form::textarea('square_ad', $square_ad, array('class'=>'form-control')) }}
				</li>

				<li>
					@if(isset($settings->analytics))<?php $analytics = $settings->analytics ?>@else<?php $analytics = ''; ?>@endif
					<label for="analytics">Analytics code:</label>
					{{ Form::textarea('analytics', $analytics, array('class'=>'form-control')) }}
				</li>

				<li style="min-height:45px">
					<input type="submit" class="btn btn-color pull-right" value="update settings" />
				</li>
				<div style="clear:both"></div>
			</ul>
		</form>
	</div>

	@include('includes.sidebar')

</div>

<script type="text/javascript" src="{{ URL::asset('assets/js/jquery-minicolors/jquery.minicolors.js') }}"></script>
<script type="text/javascript">
	$(document).ready(function(){
		console.log('what');
		$('input#primary_color, input#secondary_color').minicolors();
	});
</script>

@stop

