@extends('layouts.master')

@section('css')
    <link rel="stylesheet" href="{{ URL::asset('assets/js/tagsinput/jquery.tagsinput.css') }}" />
@stop


@section('content')

<div class="container main_home_container">

	<div class="col-sm-12" style="padding-left:0px;">
		


		<h2 style="margin-bottom:5px;"><i class="fa fa-picture-o"></i><span> Media</span></h2>
		<a href="{{ URL::to('admin') }}" style="margin-bottom:15px; display:block;"><i class="fa fa-arrow-circle-left"></i> Back to Admin</a>

		<div class="table-responsive">
			<table class="table table-striped">
				<tr class="table-header">
					<th><a href="?sort=title&order=<?php if(isset($_GET['order']) && $_GET['order'] == 'ASC'){ echo 'DESC'; }else{ echo 'ASC'; } ?>">Title <i class="fa fa-sort"></i></a></th>
					<th>Category</th>
					<th><a href="?sort=active&order=<?php if(isset($_GET['order']) && $_GET['order'] == 'ASC'){ echo 'DESC'; }else{ echo 'ASC'; } ?>">Active <i class="fa fa-sort"></i></th>
					<th>Likes</th>
					<th>Flags</th>
					<th><a href="?sort=created_at&order=<?php if(isset($_GET['order']) && $_GET['order'] == 'ASC'){ echo 'DESC'; }else{ echo 'ASC'; } ?>">Date Added <i class="fa fa-sort"></i></th>
					<th>Actions</th>
					@foreach($media as $item)
					<tr>
						<td><a href="{{ URL::to('media') . '/' . $item->slug }}" data-toggle="modal">
							<?php if(strlen($item->title) > 40){
									echo substr($item->title, 0, 40) . '...';
								  } else {
								  	echo $item->title;
								  }
							?>
							</a>
						</td>
						<td>@if($item->category)<a href="{{ URL::to('category') . '/' . strtolower($item->category->name) }}">{{ $item->category->name }}</a>@endif</td>
						<td class="active-{{$item->id}}">{{ $item->active }}</th>
						<td>{{ $item->totalLikes() }}</td>
						<td>{{ $item->totalFlags() }}</td>
						<td>{{ date('M d, Y - h:ia', strtotime($item->created_at)) }}</td>
						<td><a href="#" data-toggle="modal" data-target="#edit-{{ $item->id }}" class="btn btn-xs btn-primary edit-media" style="margin-right:10px;"><span class="glyphicon glyphicon-edit"></span> Edit</a><a href="#_" data-href="{{ URL::to('media/delete') . '/' . $item->id }}" onclick="confirm_delete(this)" class="btn btn-xs btn-danger" style="margin-right:10px;"><span class="glyphicon glyphicon-trash"></span> Delete</a><a href="#_" data-id="{{ $item->id }}" data-href="{{ URL::to('admin/media/toggle_active') . '/' . $item->id }}" onclick="toggle_active(this)" class="btn btn-xs @if($item->active) btn-danger @else btn-success @endif active-toggle"><span class="fa fa-minus-circle"></span> <span class="text">@if($item->active) Set Inactive @else Set Active @endif</span></a></td>
						
					</tr>
					@endforeach
			</table>
		</div>

	</div>

	{{ $media->links() }}

</div>
<script type="text/javascript" src="{{ URL::asset('assets/js/bootstrap-confirmation.js') }}"></script>
<script>
$(document).ready(function(){
	$('.active-toggle').click(function(){
		if($(this).hasClass('btn-danger')){
			$(this).removeClass('btn-danger').addClass('btn-success');
			$(this).children('span.fa').removeClass('fa-minus-circle').addClass('fa-plus-circle');
			$(this).children('span.text').text('Set Active');
			active_class = '.active-' + $(this).data('id');
			$(active_class).text(0);
		} else {
			$(this).removeClass('btn-success').addClass('btn-danger');
			$(this).children('span.fa').removeClass('fa-plus-circle').addClass('fa-minus-circle');
			$(this).children('span.text').text('Set Inactive');
			active_class = '.active-' + $(this).data('id');
			$(active_class).text(1);
		}

	});
});

function confirm_delete(obj){
	var delete_link = $(obj).data('href');
	var result = confirm('Are you sure you want to delete this item?');
	if(result){
		location.href=delete_link;
	}
}

function toggle_active(obj){
	url = $(obj).data('href');
	$.get(url);
}
	//$('.edit-media').confirmation();
</script>

@stop

@section('javascript')

<?php $categories = Category::orderBy('order', 'ASC')->get(); ?>

	@foreach($media as $item)
	<!-- Modal -->
	<div class="modal fade" id="edit-{{ $item->id }}" data-id="{{ $item->id }}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	  <div class="modal-dialog">
	    <div class="modal-content">
	      <div class="modal-header">
	        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
	        <h4 class="modal-title" id="myModalLabel">Editing {{ $item->title }}</h4>
	      </div>
	      <div class="modal-body">
	      
	      	{{ Form::model($media, array('method' => 'PATCH', 'route' => array('media.update', $item->id))) }}
			<ul>
		        <li>
		            <label for="title">Title</label>
		            <input type="text" class="form-control" name="title" id="title" value="{{ $item->title }}" />
		        </li>

		        <li>
		        	<label for="title">Category</label>
		        	<select class="form-control" id="category" name="category">
		        		@foreach($categories as $category)
		        			<option value="{{ $category->id }}" @if($category->id == $item->category_id) selected="selected" @endif>{{ $category->name }}</option>
		        		@endforeach
		        	</select>
		        </li>

		        <li>
		            <label for="source">Source</label>
		            <input type="text" class="form-control" name="source" id="source" value="{{ $item->link_url }}" />
		        </li>

		        <li>
		            <label for="title">Tags</label>
		            <input class="form-control tags_input" name="tags" id="tags" value="{{ $item->tags }}" style="width:100%; height:auto;" />
		        </li>
			</ul>
			<input type="hidden" id="id" name="id" value="{{ $item->id }}" />
			<input type="hidden" id="redirect" name="redirect" value="{{ Request::url() }}" />

	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
	        <input type="submit" class="btn btn-color" value="Update Media" />
	      </div>
	      {{ Form::close() }}
	    </div><!-- /.modal-content -->
	  </div><!-- /.modal-dialog -->
	</div><!-- /.modal -->



	@endforeach

	<script type="text/javascript" src="{{ URL::asset('assets/js/tagsinput/jquery.tagsinput.js') }}"></script>
	<script>
		$(document).ready(function(){
			$('.tags_input').tagsInput();
		});
	</script>
@stop
