@extends('layouts.master')

@section('content')


<div class="container main_home_container">

	<div class="white_container">
		
		<h2 style="margin-bottom:20px; float:left;"><i class="fa fa-list"></i><span> Categories</span></h2>
		<div class="btn btn-color" style="margin-left:20px;" data-toggle="modal" data-target="#new-category"><span class="glyphicon glyphicon-plus"></span> New Category</div>
		<div class="table-responsive">
			<table class="table table-condensed">
				<tr>
					<th>Category</th>
					<th>Total Media per Category</th>
					<th>Order</th>
					<th>Actions</th>
					@foreach($categories as $category)

							<tr>
								<td>
									{{ $category->name }}
								</td>
								<td>
									{{ $category->totalMedia() }}
								</td>
								<td>
									{{ $category->order }}
								</td>
								<td style="width:190px;">
									<a href="#" data-toggle="modal" data-target="#edit-{{ $category->id }}" class="btn btn-xs btn-primary edit-media" style="margin-right:10px;"><span class="glyphicon glyphicon-edit"></span> Edit</a>
									@if($category->id != 1)
										<a href="{{ URL::to('category/delete') . '/' . $category->id }}" class="btn btn-xs btn-danger"><span class="glyphicon glyphicon-trash"></span> Delete</a>
									@endif
								</td>
								
							</tr>
							
					@endforeach
			</table>
		</div>
		
	</div>

</div>

@stop

@section('javascript')


	<!-- Create Category Modal -->
	<div class="modal fade" id="new-category" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	  <div class="modal-dialog">
	    <div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
				<h4 class="modal-title" id="myModalLabel">New Category</h4>
			</div>
		    <div class="modal-body">
		      
		      	<form method="POST" action="{{ URL::to('categories') }}" accept-charset="UTF-8">
				<p><input name="name" type="text" class="form-control" id="name" placeholder="name"></p>
				<p><input name="order" type="text" class="form-control" id="order" placeholder="order"></p>
		      	
			</div><!-- .modal-body -->
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
				<input type="submit" class="btn btn-color" value="Add Category" />
			</div>
				</form>

	    </div><!-- /.modal-content -->
	  </div><!-- /.modal-dialog -->
	</div><!-- /.modal -->
	<!-- END Create Category Modal -->

	@foreach($categories as $category)
	<!-- Modal -->
	<div class="modal fade" id="edit-{{ $category->id }}" data-id="{{ $category->id }}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	  <div class="modal-dialog">
	    <div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
				<h4 class="modal-title" id="myModalLabel">Editing {{ $category->name }}</h4>
			</div>
		    <div class="modal-body">
		      
		      	<form method="POST" action="{{ URL::to('categories/update') . '/' . $category->id }}" accept-charset="UTF-8">
					<ul>
				        <li>
				        	<label for="name">Name</label>
		           			<input type="text" @if($category->id != 1) readonly="readonly" @endif class="form-control" name="name" id="name" value="{{ $category->name }}" />
				        </li>

				        <li>
				        	<label for="order">Order</label>
		           			<input type="number" class="form-control" name="order" id="order" value="{{ $category->order }}" />
				        </li>
					</ul>
			</div><!-- .modal-body -->
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
				<input type="submit" class="btn btn-color" value="Update Category" />
			</div>
			</form>

	    </div><!-- /.modal-content -->
	  </div><!-- /.modal-dialog -->
	</div><!-- /.modal -->



	@endforeach

@stop