<?php

/*
|--------------------------------------------------------------------------
| Ninja Media Script
|--------------------------------------------------------------------------
|
| Version: 1.0.3
| Date: Feb. 26, 2014
|
*/


// **********	INSTALLATION ROUTES *********//

Route::get('install', 'HomeController@install');
Route::post('install_db', 'HomeController@add_db_credentials');
Route::post('install_connection', 'HomeController@test_db_connection');
Route::post('install_data', 'HomeController@add_db_data');
Route::post('install_admin', 'HomeController@add_admin_user');

// ********** UPGRADE ROUTES **********//
Route::get('upgrade', 'HomeController@upgrade');


// **********	HOME/ROOT ROUTE *********//

Route::get('/', 'HomeController@home');


// ********* POPULAR ROUTE ********** //

Route::get('popular', function(){

	$media = Media::where('active', '=', '1')->join('media_likes', 'media.id', '=', 'media_likes.media_id')->groupBy('media_likes.media_id')->orderBy(DB::raw('COUNT(media_likes.id)'), 'DESC')->select('media.*')->paginate(30);

    $data = array(
    	'media' => $media);

	return View::make('home', $data);

});

Route::get('popular/week', function(){

	$media = Media::where('active', '=', '1')->join('media_likes', 'media.id', '=', 'media_likes.media_id')->where('media_likes.created_at', '>=', date('Y-m-d H:i:s', strtotime('-1 week')))->groupBy('media_likes.media_id')->orderBy(DB::raw('COUNT(media_likes.id)'), 'DESC')->select('media.*')->paginate(30);

    $data = array(
    	'media' => $media);

	return View::make('home', $data);

});

Route::get('popular/month', function(){

	$media = Media::where('active', '=', '1')->join('media_likes', 'media.id', '=', 'media_likes.media_id')->where('media_likes.created_at', '>=', date('Y-m-d H:i:s', strtotime('-1 month')))->groupBy('media_likes.media_id')->orderBy(DB::raw('COUNT(media_likes.id)'), 'DESC')->select('media.*')->paginate(30);

    $data = array(
    	'media' => $media);

	return View::make('home', $data);

});

Route::get('popular/year', function(){

	$media = Media::where('active', '=', '1')->join('media_likes', 'media.id', '=', 'media_likes.media_id')->where('media_likes.created_at', '>=', date('Y-m-d H:i:s', strtotime('-1 year')))->groupBy('media_likes.media_id')->orderBy(DB::raw('COUNT(media_likes.id)'), 'DESC')->select('media.*')->paginate(30);

    $data = array(
    	'media' => $media);

	return View::make('home', $data);

});


// ********* TAGS ROUTE ********** //

Route::get('tags/{tag}', function($tag){
	
	$media = Media::where('active', '=', 1)->where('tags', 'LIKE', $tag.',%')->orWhere('tags', 'LIKE', '%,'.$tag.',%')->orWhere('tags', 'LIKE', '%,'.$tag)->orderBy('created_at', 'desc')->paginate(Config::get('site.num_results_per_page'));

	$data = array(
		'media' => $media,
		'tag' => $tag
		);

	return View::make('home', $data);
});


// ********* CATEGORY ROUTE ********** //

Route::get('category/{category}', 'CategoriesController@index');


// ********** USER AUTHENTICATION ROUTES  ********** //

// SIGN IN

Route::get('signin', function(){
	return View::make('auth.signin');
});

Route::post('signin', 'UserController@signin');

// SIGNUP

Route::get('signup', function(){
	return View::make('auth.signup');
});

Route::post('signup', 'UserController@signup');

// LOGOUT

Route::get('logout', function(){
	Auth::logout();
	return Redirect::to('/');
});

// OAUTH ROUTES

Route::get('auth/facebook', 'UserController@facebook');
Route::get('auth/google', 'UserController@google');

Route::get('google', function(){
	$googleService = OAuth::consumer( 'Google' );
	// get googleService authorization
    $url = $googleService->getAuthorizationUri();

    // return to facebook login url
    return Response::make()->header( 'Location', (string)$url );
});

// PASSWORD RESET

Route::get('password_reset', array(
  'uses' => 'UserController@password_reset',
  'as' => 'password.remind'
));

Route::post('password_reset', array(
  'uses' => 'UserController@password_request',
  'as' => 'password.request'
));

Route::get('password_reset/{token}', array(
  'uses' => 'UserController@password_reset_token',
  'as' => 'password.reset'
));

Route::post('password_reset/{token}', array(
  'uses' => 'UserController@password_reset_post',
  'as' => 'password.update'
));


// **********	SEARCH ROUTES  ********** //

Route::post('search', function(){
	$search = Input::get('search');
});


// **********	SINGLE MEDIA ROUTE ********** //

Route::get('media/{slug}', 'MediaController@show');

/********** API Routes **********/

Route::controller('api', 'ApiController');


// **********	USER PROFILE ROUTES   ********** //

Route::get('user/{username}', 'UserController@profile');
Route::get('user/{username}/likes', 'UserController@profile_likes');


// **********	POINTS / FLAGS / LIKE ROUTES ********** //

Route::post('add_user_point', 'UserController@add_user_point');
Route::post('media/add_flag', 'MediaController@add_flag');
Route::post('media/add_like', 'MediaController@add_like');
Route::post('user/add_flag', 'UserController@add_flag');


// **********	COMMENTS ROUTES  **********//

Route::resource('comments', 'CommentsController');
Route::post('comments/vote_up', 'CommentsController@vote_up');
Route::post('comments/vote_down', 'CommentsController@vote_down');
Route::post('comments/add_flag', 'CommentsController@add_flag');


// **********	USER LOGGED IN ROUTES  ********** //

Route::group(array('before' => 'auth'), function()
{
	/********** Upload Routes **********/
	Route::get('upload', 'MediaController@create');
	Route::post('upload', 'MediaController@create');
	Route::post('image_ajax_upload', 'MediaController@image_ajax_upload');
	Route::resource('media', 'MediaController');

	/********** DELETE Media/Comments Routes *********/
	Route::get('media/delete/{id}', 'MediaController@delete');
	Route::get('comments/delete/{id}', 'CommentsController@delete');

	/********** User Routes **********/
	Route::get('user/{username}/edit', 'UserController@edit');
	Route::get('user/{username}/points', 'UserController@points');
	Route::get('user/{username}/asked', 'UserController@asked');
	Route::post('user/update/{id}', 'UserController@update');

});


// **********	ADMIN ROUTES  ********** //

Route::group(array('before' => 'admin'), function(){
	Route::get('admin', 'AdminController@index');
	Route::get('admin/media', 'AdminController@media');
	Route::get('admin/media/toggle_active/{id}', 'AdminController@toggle_active');
	Route::get('admin/comments', 'AdminController@comments');
	Route::get('admin/users', 'AdminController@users');
	Route::get('admin/categories', 'AdminController@categories');
	Route::post('categories/update/{id}', 'CategoriesController@update');
	Route::get('admin/settings', 'AdminController@settings');
	Route::get('admin/flagged/answers', 'AdminController@flagged_answers');
	Route::get('admin/flagged/users', 'AdminController@flagged_users');
	Route::get('admin/custom_css', 'AdminController@custom_css');
	Route::post('admin/custom_css', 'AdminController@update_custom_css');
	Route::post('admin/update_settings', 'AdminController@update_settings');
	Route::get('admin/deactivate_user/{id}', 'AdminController@deactivate_user');
	Route::get('admin/activate_user/{id}', 'AdminController@activate_user');
	Route::get('category/delete/{id}', 'CategoriesController@delete');
	Route::resource('categories', 'CategoriesController');
	
});


// ********** Sitemap Route ********** //

Route::get('sitemap', function(){
	$sitemap = array();

	// Add static pages like this:
	// $sitemap->add(URL::to('/'), '2013-11-16T12:30:00+02:00', '1.0', 'daily');
	// $sitemap->add(URL::to('about'), '2013-11-16T12:30:00+02:00', '0.7', 'monthly');
	// $sitemap->add(URL::to('categories'), '2013-11-16T12:30:00+02:00', '0.7', 'monthly');
	// $sitemap->add(URL::to('tags'), '2013-11-16T12:30:00+02:00', '0.7', 'monthly');
	// $sitemap->add(URL::to('login'), '2013-11-16T12:30:00+02:00', '0.8', 'weekly');
	// $sitemap->add(URL::to('register'), '2013-11-16T12:30:00+02:00', '0.8', 'weekly');

	// Add dynamic pages of the site like this (using an example of this very site):

	$media = Media::where('active', '=', 1);

	foreach($media as $item) {
	  $sitemap->add(URL::to("media/{$item->slug}"), $media->created_at, '0.9', 'weekly');
	}

	$categories = Category::all();

	foreach($categories as $category) {
	  $sitemap->add(URL::to("categories/{$category->slug}"), $category->created_at, '0.9', 'weekly');
	}

	// Now, output the sitemap:
	return $sitemap->render('xml');
});


// ********** FUNCTION TO SLUGIFY MEDIA ********** //

function slugify($text) {
    // replace non letter or digits by -
	$text = preg_replace('~[^\\pL\d]+~u', '-', $text);

	// trim
	$text = trim($text, '-');

	// transliterate
	$text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

	// lowercase
	$text = strtolower($text);

	// remove unwanted characters
	$text = preg_replace('~[^-\w]+~', '', $text);

	if (empty($text))
	{
	return 'n-a';
	}

  	return $text;
}