<?php 

class UserController extends BaseController{

	/**
	 * User Repository
	 *
	 * @var User
	 */
	protected $user;

	public function __construct(User $user)
	{
		$this->user = $user;
	}

	public static $rules = array(
		'username' => 'required|unique:users',
        'email' => 'required|email|unique:users',
        'password' => 'required|confirmed'
    );

    // *********** USER SIGNUP ********** //

	public function signup(){

		$validation = Validator::make( Input::all(), static::$rules );

		if ($validation->fails()){
			return Redirect::to('signup')->with(array('note' => 'Error: Please make sure to enter a valid email, your passwords match, and your username is more than 3 characters', 'note_type' => 'error'));
		}


		$username = htmlspecialchars(stripslashes(Input::get('username')));

		$user = User::where('username', '=', $username)->first();

		if(!$user){

			$settings = Setting::first();

			if($settings->user_registration){

				if( count(explode(' ', $username)) == 1 ){

					if(Input::get('password') != ''){
						$user = $this->new_user( $username, Input::get('email'), Hash::make(Input::get('password')) ); 
				    

					    if($user){
					    	Auth::attempt(array('email' => Input::get('email'), 'password' => Input::get('password')));
					    	$this->new_user_points($user->id);
					    }

					    return Redirect::to('/')->with(array('note' => 'Your Account has been Successfully Created! Please Sign in Below.', 'note_type' => 'success'));

					} else {
						return Redirect::to('signup')->with(array('note' => 'invalid password, please try again.', 'note_type' => 'error'));
					}

				} else {
					return Redirect::to('/signup')->with(array('note' => 'Please make sure that your username does not contain any spaces.', 'note_type' => 'error'));
				}

			} else {
				return Redirect::to('/')->with(array('note' => 'Sorry, Registration has been closed.', 'note_type' => 'error'));
			}

		} else {
			return Redirect::to('signup')->with(array('note' => 'Sorry, this username is already in use. Please try another name.', 'note_type' => 'error'));
		}

	}

	// *********** CREATE A NEW USERNAME WITH USERNAME EMAIL AND PASSWORD ********** //

	private function new_user($username, $email, $password, $filename = NULL){
	    $user = new User;
	    $user->username = $username;
	    $user->email = $email;
	    $user->password = $password;

	    if($filename){
	    	$user->avatar = $filename;
	    }

	    $user->save();

	    return $user;
	}

	// *********** WHEN USER SIGNS UP AWARD THEM WITH POINTS ********** //

	private function new_user_points($user_id){
		$point = new Point;
    	$point->user_id = $user_id;
    	$point->points = 200;
    	$point->description = 'Registration';
    	$point->save();
	}

	// *********** USER SIGNIN ********** //

	public function signin(){

	    // get login POST data
	    $email_login = array(
	        'email' => Input::get('email'),
	        'password' => Input::get('password')
	    );

	    $username_login = array(
	        'username' => Input::get('email'),
	        'password' => Input::get('password')
	    );

	    if ( Auth::attempt($email_login) || Auth::attempt($username_login) ){

	    	$this->add_user_login_point();
	    	return Redirect::to('/')->with(array('note' => 'You have been successfully logged in.', 'note_type' => 'success'));
	    	
	    } else {
	        // auth failure! redirect to login with errors
	        return Redirect::to('signin')->with(array('note' => 'Incorrect login or password.', 'note_type' => 'error'));
	    }

	}

	// *********** FACEBOOK OAUTH SIGNIN/SIGNUP ********** //

	public function facebook(){
	
		$settings = Setting::first();

		if($settings->user_registration){	

			// get data from input
		    $code = Input::get( 'code' );

		    // get fb service
		    $fb = OAuth::consumer( 'Facebook' );

		    // check if code is valid

		    // if code is provided get user data and sign in
		    if ( !empty( $code ) ) {

		        // This was a callback request from google, get the token
		        $token = $fb->requestAccessToken( $code );

		        // Send a request with it
		        $result = json_decode( $fb->request( '/me?fields=picture,email,id,username' ), true );

		        $oauth_userid = $result['id'];
		        $oauth_username = $result['username'];
		        $oauth_email = $result['email'];
		        $oauth_picture = 'http://graph.facebook.com/' . $oauth_userid . '/picture?type=large';
		        if(isset($oauth_userid) && isset($oauth_username) && isset($oauth_email) && isset($oauth_picture)){
		        	
		        	$fb_auth = OauthFacebook::where('oauth_userid', '=', $oauth_userid)->first();
			        	
			        if(isset($fb_auth->id)){
			        	$user = User::find($fb_auth->user_id);
			        } else {
			        	// Execute Add or Login Oauth User
			        	$user = User::where('email', '=', $oauth_email)->first();

			        	if(!isset($user->id)){
			        		$username = $this->create_username_if_exists($oauth_username);
			        		$email = $oauth_email;
			        		$password = Hash::make($this->rand_string(15));

			        		$user = $this->new_user($username, $email, $password, $this->uploadImageFromURL($oauth_picture, $username));

			        		$this->new_user_points($user->id);

			        		$new_oauth_user = new OauthFacebook;
			        		$new_oauth_user->user_id = $user->id;
			        		$new_oauth_user->oauth_userid = $oauth_userid;
			        		$new_oauth_user->save();

			        	} else {
			        		// Redirect and send error message that email already exists. Let them know that they can request to reset password if they do not remember
			        		return Redirect::to('/')->with(array('note' => 'This email is already associated with an account. Please Login first and then link your facebook account.', 'note_type' => 'error'));
			        	}
			        }

		        	// Redirect to new User Login;
		        	Auth::login($user);
		        	$this->add_user_login_point();

		        	return Redirect::to('/')->with(array('note' => 'You have been successfully logged in with Facebook.', 'note_type' => 'success'));
		        	

		        } else {
		        	// Something went wrong, redirect and send error msg
		        	echo 'Some Oauth information was not able to get retrieved. Please try again.';
		        	echo '<br />Info retrieved:<br />';
		        	echo '<br />userid: ' . $oauth_userid;
		        	echo '<br />username: ' . $oauth_username;
		        	echo '<br />email: ' . $oauth_email;
		        	echo '<br />picture: ' . $oauth_picture;
		        }

		    }
		    // if not ask for permission first
		    else {
		        // get fb authorization
		        $url = $fb->getAuthorizationUri();

		        // return to facebook login url
		        return Response::make()->header( 'Location', (string)$url );
		    }
		} else {
			return Redirect::to('/')->with(array('note' => 'Sorry, Registration has been closed.', 'note_type' => 'error'));
		}
	}

	// *********** GOOGLE OAUTH SIGNIN/SIGNUP ********** //

	public function google() {

		$settings = Setting::first();

		if($settings->user_registration){	
		    // get data from input
		    $code = Input::get( 'code' );

		    // get google service
		    $googleService = OAuth::consumer( 'Google' );

		    // check if code is valid

		    // if code is provided get user data and sign in
		    if ( !empty( $code ) ) {

		        // This was a callback request from google, get the token
		        $token = $googleService->requestAccessToken( $code );

		        // Send a request with it
		        $result = json_decode( $googleService->request( 'https://www.googleapis.com/oauth2/v1/userinfo' ), true );
		        // $message = 'Your unique Google user id is: ' . $result['id'] . ' and your name is ' . $result['name'];
		        // dd($result);

		        $oauth_userid = $result['id'];
		        $oauth_username = slugify($result['name']);
		        $oauth_email = $result['email'];
		        if(!isset($result['picture'])){
		        	$oauth_picture = NULL;
		        } else {
		        	$oauth_picture = $result['picture'];
		        }

		        if(isset($oauth_userid) && isset($oauth_username) && isset($oauth_email)){
		        	
		        	$google_auth = OauthGoogle::where('oauth_userid', '=', $oauth_userid)->first();
			        	
			        if(isset($google_auth->id)){
			        	$user = User::find($google_auth->user_id);
			        } else {
			        	// Execute Add or Login Oauth User
			        	$user = User::where('email', '=', $oauth_email)->first();

			        	if(!isset($user->id)){
			        		$username = $this->create_username_if_exists($oauth_username);
			        		$email = $oauth_email;
			        		$password = Hash::make($this->rand_string(15));

			        		$avatar = ($oauth_picture != NULL) ? $this->uploadImageFromURL($oauth_picture, $username) : NULL;

			        		$user = $this->new_user($username, $email, $password, $avatar);

			        		$this->new_user_points($user->id);

			        		$new_oauth_user = new OauthGoogle;
			        		$new_oauth_user->user_id = $user->id;
			        		$new_oauth_user->oauth_userid = $oauth_userid;
			        		$new_oauth_user->save();

			        	} else {
			        		// Redirect and send error message that email already exists. Let them know that they can request to reset password if they do not remember
			        		return Redirect::to('/')->with('error', 'This email is already associated with an account.');
			        	}
			        }


		        	// Redirect to new User Login;
		        	Auth::login($user);
		        	$this->add_user_login_point();

		        	return Redirect::to('/')->with('success', 'Your Account has been Successfully Created! Please Login Below.');
		        	

		        } else {
		        	// Something went wrong, redirect and send error msg
		        	echo 'Some Oauth information was not able to get retrieved. Please try again.';
		        	echo '<br />Info retrieved:<br />';
		        	echo '<br />userid: ' . $oauth_userid;
		        	echo '<br />username: ' . $oauth_username;
		        	echo '<br />email: ' . $oauth_email;
		        	echo '<br />picture: ' . $oauth_picture;
		        }



		    }
		    // if not ask for permission first
		    else {
		        // get googleService authorization
		        $url = $googleService->getAuthorizationUri();

		        // return to facebook login url
		        return Response::make()->header( 'Location', (string)$url );
		    }
		} else {
			return Redirect::to('/')->with(array('note' => 'Sorry, Registration has been closed.', 'note_type' => 'error'));
		}
	}

	// *********** LOOP THROUGH USERNAMES TO RETURN ONE THAT DOESN'T EXIST ********** //

	private function create_username_if_exists($username){
		$user = User::where('username', '=', $username)->first();

		while (isset($user->id)) {
			$username = $username . uniqid();
			$user = User::where('username', '=', $username)->first();
		}

		return $username;
	}

	// *********** RANDOM STRIN GENERATOR ********** //

	private function rand_string( $length ) {

	    $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
	    return substr(str_shuffle($chars),0,$length);

	}

	// *********** ADD USER LOGIN POINT, ONE PER DAY ********** //

	private function add_user_login_point(){
		$user_id = Auth::user()->id;

		$LastLoginPoints = Point::where('user_id', '=', $user_id)->where('description', '=', 'Daily Login')->orderBy('created_at', 'desc')->first();
		if(!isset($LastLoginPoints) || date('Ymd') !=  date('Ymd', strtotime($LastLoginPoints->created_at)) ){
			$point = new Point;
			$point->user_id = $user_id;
			$point->description = 'Daily Login';
			$point->points = 5;
			$point->save();
			return true;
		} else {
			return false;
		}
	}

	// *********** UPLOAD IMAGE FOR AVATAR ********** //

	private function uploadImage(){
		
		$file = Input::file('avatar');
		$upload_folder = 'uploads/avatars/';

		$filename =  $file->getClientOriginalName();

		if (file_exists($upload_folder.$filename)) {
			$filename =  uniqid() . '-' . $file->getClientOriginalName();
		}

	    $uploadSuccess = Input::file('avatar')->move($upload_folder, $filename);
		
		$img = Image::make($upload_folder . $filename)->resize(200, 200, false)->save($upload_folder . $filename);

		return $filename;

	}

	// *********** UPLOAD IMAGE FROM URL FOR AVATAR FROM OAUTH ********** //

	private function uploadImageFromURL($file_url, $filename){
		
		
		$file = file_get_contents($file_url);

		$upload_folder = 'uploads/avatars/';

		$filename = $filename . '.jpg';

		if (file_exists($upload_folder.$filename)) {
			$filename =  uniqid() . '-' . $filename . '.jpg';
		}

	    
	    //$extension = $file->getClientOriginalExtension(); //if you need extension of the file
	    $uploadSuccess = file_put_contents($upload_folder.$filename, $file); //$img->move($upload_folder, $filename);
	
		$img = Image::make($upload_folder . $filename)->resize(200, 200, false)->save($upload_folder . $filename);

		return $filename;

	}

	// *********** ADD USER FLAG ********** //

	public function add_flag(){
		$id = Input::get('user_id');
		$user_flag = UserFlag::where('user_id', '=', Auth::user()->id)->where('user_flagged_id', '=', $id)->first();

		if(isset($user_flag->id)){ 
			$user_flag->delete();
		} else {
			$flag = new UserFlag;
			$flag->user_id = Auth::user()->id;
			$flag->user_flagged_id = $id;
			$flag->save();
			echo $flag;
		}
	}


	// *********** UPDATE USER ********** //

	public function update($id)
	{
		$input = array_except(Input::all(), '_method');
		$validation = Validator::make($input, User::$update_rules);

		if ($validation->passes())
		{
			$user = $this->user->find($id);

			if(file_exists($input['avatar'])){
            	$input['avatar'] = $this->uploadImage();
            } else { $input['avatar'] = $user->avatar; }

            if($input['password'] == ''){
            	$input['password'] = $user->password;
            } else{ $input['password'] = Hash::make($input['password']); }

            if($user->username != $input['username']){
            	$username_exist = User::where('username', '=', $input['username'])->first();
            	if($username_exist){
            		return Redirect::to('user/' .$user->username)->with(array('note' => 'Sorry that username is already in use.', 'note_type' => 'error') );;
            	}
            }

			$user->update($input);

			return Redirect::to('user/' .$user->username);
		}

		return Redirect::to('user/' . Auth::user()->username)
			->withInput()
			->withErrors($validation)
			->with('message', 'There were validation errors.');
	}


	// *********** SHOW USER PROFILE ********** //

	public function profile($username){

		$user = User::where('username', '=', $username)->first();
		$medias = Media::where('user_id', '=', $user->id)->orderBy('created_at', 'desc')->paginate(Config::get('site.num_results_per_page'));

		$data = array(
				'user' => $user,
				'medias' => $medias,
				);

		return View::make('user.index', $data);
	}

	// *********** SHOW USER PROFILE LIKES ********** //

	public function profile_likes($username){

		$user = User::where('username', '=', $username)->first();
		$medias = MediaLike::where('user_id', '=', $user->id)->orderBy('created_at', 'desc')->paginate(Config::get('site.num_results_per_page'));

		$data = array(
				'user' => $user,
				'medias' => $medias,
				'likes' => true,
				);

		return View::make('user.index', $data);
	}

	// ********** USER POINTS PAGE **********  //

	public function points($username){

		$data = array(
			'user' => User::where('username', '=', $username)->first(),
			'points' => Point::where('user_id', '=', Auth::user()->id)->get(),
			);

		return View::make('user.points', $data);
	}

	// ********** RESET PASSWORD ********** //

	public function password_reset()
	{
		return View::make('auth.password_reset');
	}

	// ********** RESET REQUEST ********** //

	public function password_request()
	{
	  $credentials = array('email' => Input::get('email'));
	  return Password::remind($credentials, function($message){
	  	$message->subject('Password Reset Info');
	  });
	}

	// ********** RESET PASSWORD TOKEN ********** //

	public function password_reset_token($token)
	{
	  return View::make('auth.password_reset_form')->with('token', $token);
	}

	// ********** RESET PASSWORD POST ********** //

	public function password_reset_post()
	{
	  $credentials = array('email' => Input::get('email'));
	 
	  return Password::reset($credentials, function($user, $password)
	  {
	    $user->password = Hash::make($password);
	 
	    $user->save();
	 
	    return Redirect::to('signin')->with(array('note' => 'Your password has been successfully reset.', 'note_type' => 'success'));
	  });
	}

}