<?php

class HomeController extends BaseController {

	/*
	|--------------------------------------------------------------------------
	| Default Home Controller
	|--------------------------------------------------------------------------
	|
	| You may wish to use controllers instead of, or in addition to, Closure
	| based routes. That's great! Here is an example controller method to
	| get you started. To route to this controller, just add the route:
	|
	|	Route::get('/', 'HomeController@showWelcome');
	|
	*/


	// ********** Main Home Controller //

	public function home(){
		$search = Input::get('search');
		if(isset($search)){
			$media = Media::where('active', '=', 1)->where('title', 'LIKE', '%'.$search.'%')->orderBy('created_at', 'desc')->paginate(Config::get('site.num_results_per_page'));
		} else {
			$media = Media::where('active', '=', 1)->orderBy('created_at', 'desc')->paginate(Config::get('site.num_results_per_page'));
		}

		$data = array(
			'media' => $media,
			'search' => $search
			);

		return View::make('home', $data);
	}


	// ********** Main Install Route ********** //

	public function install(){
		try{

			$settings = Setting::first();
			if($settings){
				return Redirect::to('/');
			} else {
				throw new Exception('settings not set, first install the script');
			}

		}catch(Exception $e){

				return View::make('install');

		}
	}


	// ********** Add the DB Credentials to a file ********** //

	public function add_db_credentials(){
		if(Request::ajax()){

			try{

				$settings = Setting::first();
				if($settings){
					return Redirect::to('/');
				} else {
					throw new Exception('settings not set, first install the script');
				}

			}catch(Exception $e){

				$db_host = $_POST['database_host'];
				$db_name = $_POST['database_name'];
				$db_user = $_POST['database_user'];
				$db_password = $_POST['database_password'];
				
				$file = '../app/config/config.php';
				$config_string = "<?php return array('db_host' => '$db_host', 'db_name' => '$db_name', 'db_user' => '$db_user', 'db_password' => '$db_password');";
				$new_file = file_put_contents($file, $config_string);

				if($new_file !== FALSE){
					echo true;
				} else {
					echo false;
				}
			}

		} else {
			echo false;
		}
	}

	// ********** Test the Database Connection ********** //

	public function test_db_connection(){
		if(Request::ajax()){

			try{

				$db_host = $_POST['database_host'];
				$db_name = $_POST['database_name'];
				$db_user = $_POST['database_user'];
				$db_password = $_POST['database_password'];

				// Create connection
				$con=mysqli_connect($db_host,$db_user,$db_password,$db_name);

				// Check connection
				if (mysqli_connect_errno()){
					echo false;
				} else {
					echo true;
				}

			} catch (Exception $e){
				echo false;
			}

		} else {
			echo false;
		}
	}

	// ********** Add pre-installed data ********** //

	public function add_db_data(){
		if(Request::ajax()){
			try{

				$settings = Setting::first();
				if($settings){
					return Redirect::to('/');
				} else {
					throw new Exception('settings not set, first install the script');
				}

			}catch(Exception $e){

				try{

					$db_host = $_POST['database_host'];
					$db_name = $_POST['database_name'];
					$db_user = $_POST['database_user'];
					$db_password = $_POST['database_password'];

					Config::set('database.connections.mysql.host', $db_host);
					Config::set('database.connections.mysql.database', $db_name);
					Config::set('database.connections.mysql.username', $db_user);
					Config::set('database.connections.mysql.password', $db_password);
					
					Artisan::call('migrate');
					Artisan::call('db:seed', array('--class'=> "SettingsTableSeeder"));
					Artisan::call('db:seed', array('--class'=> "CategoriesTableSeeder"));

					if($_POST['preloaded_data'] == 'true'){
						Artisan::call('db:seed', array('--class'=> "MediaTableSeeder"));
					}

					$this->upgrade();

					echo true;
				
				} catch(Exception $e){
					echo false;
				}

			}

		} else {
			echo false;
		}
	}

	// ********** Add the admin to the database ********** //

	public function add_admin_user(){
		if(Request::ajax()){

			try{

				$user = User::first();
				if($user){
					return Redirect::to('/');
				} else {
					throw new Exception('We cannot detect any current user. Okay to add new admin');
				}

			}catch(Exception $e){

				$admin_username = Input::get('admin_username');
				$admin_email = Input::get('admin_email');
				$admin_password = Hash::make(Input::get('admin_password'));

				$user = new User;
				$user->username = $admin_username;
				$user->email = $admin_email;
				$user->password = $admin_password;
				$user->admin = 1;

				$new_user = $user->save();

				$point = new Point;
		    	$point->user_id = $user->id;
		    	$point->points = 200;
		    	$point->description = 'Registration';
		    	$point->save();

				if($new_user){
					echo true;
				} else {
					echo false;
				}

			}

		} else {
			echo false;
		}
	}

	// ********** Upgrade functionality ********** //

	public function upgrade(){

		$upgraded = $this->upgrade102();

		if($upgraded){
			return Redirect::to('/')->with(array('note' => 'Successfully Updated Your Script', 'note_type' => 'success') );
		} else {
			return Redirect::to('/');
		}

	}

	public function upgrade102(){
		$settings = Setting::first();

		if(!isset($settings->analytics)){

			Schema::table('settings', function($table)
			{
			    // Added for V 1.0.2
				$table->text('analytics');
				$table->boolean('user_registration')->default(1);
				$table->boolean('infinite_scroll')->default(1);
			});

			Schema::table('users', function($table){
				$table->string('activation_code');
			});

			return true;

		} else {
			return false;
		}
	}

}