<?php

class AdminController extends BaseController {

	/*
	|--------------------------------------------------------------------------
	| Default Home Controller
	|--------------------------------------------------------------------------
	|
	| You may wish to use controllers instead of, or in addition to, Closure
	| based routes. That's great! Here is an example controller method to
	| get you started. To route to this controller, just add the route:
	|
	|	Route::get('/', 'HomeController@showWelcome');
	|
	*/

	public function index()
	{
		return View::make('admin.index');
	}

	public function media()
	{
		if(isset($_GET['sort'])){
			if(!isset($_GET['order'])){
				$_GET['order'] = 'ASC';
			}
			$media = Media::orderBy($_GET['sort'], $_GET['order'])->paginate(Config::get('site.num_results_per_page'));
		} else {
			$media = Media::orderBy('created_at', 'DESC')->paginate(Config::get('site.num_results_per_page'));
		}
		
		$data = array(
			'media' => $media,
			);
		return View::make('admin.media', $data);
	}

	public function comments()
	{
		//$media = MediaFlag::groupBy('media_id')->get();
		$comments = Comment::all();
		$data = array(
			'comments' => $comments,
			);
		return View::make('admin.comments', $data);
	}

	public function users()
	{
		$users = User::all();
		$data = array(
			'users' => $users,
			);
		return View::make('admin.users', $data);
	}

	public function categories()
	{
		$categories = Category::orderBy('order', 'ASC')->get();
		$data = array(
			'categories' => $categories,
			);
		return View::make('admin.categories', $data);
	}

	public function settings()
	{
		$settings = Setting::first();
		$data = array(
			'settings' => $settings,
			);
		return View::make('admin.settings', $data);
	}

	public function update_settings()
	{
		$input = Input::all();
		$settings = Setting::first();

		if(isset($input['auto_approve_posts'])){
			$input['auto_approve_posts'] = 1;
		} else {
			$input['auto_approve_posts'] = 0;
		}

		$settings->auto_approve_posts = htmlspecialchars($input['auto_approve_posts']);

		if(isset($input['user_registration'])){
			$input['user_registration'] = 1;
		} else {
			$input['user_registration'] = 0;
		}

		$settings->user_registration = htmlspecialchars($input['user_registration']);

		if(isset($input['infinite_scroll'])){
			$input['infinite_scroll'] = 1;
		} else {
			$input['infinite_scroll'] = 0;
		}

		$settings->infinite_scroll = htmlspecialchars($input['infinite_scroll']);
		
		if(isset($input['logo'])){
			$settings->logo = $this->uploadImage(Input::file('logo'));
		}

		if(isset($input['favicon'])){
			$settings->favicon = $this->uploadImage(Input::file('favicon'));
		}

		$settings->website_name = htmlspecialchars($input['website_name']);
		$settings->website_description = htmlspecialchars($input['website_description']);

		$settings->color_scheme = htmlspecialchars($input['color_scheme']);
		$settings->primary_color = htmlspecialchars($input['primary_color']);
		$settings->secondary_color = htmlspecialchars($input['secondary_color']);
		$settings->like_icon = htmlspecialchars($input['like_icon']);

		$settings->fb_key = htmlspecialchars($input['fb_key']);
		$settings->fb_secret_key = htmlspecialchars($input['fb_secret_key']);
		$settings->facebook_page_id = htmlspecialchars($input['facebook_page_id']);

		$settings->google_key = htmlspecialchars($input['google_key']);
		$settings->google_secret_key = htmlspecialchars($input['google_secret_key']);
		$settings->google_page_id = htmlspecialchars($input['google_page_id']);

		$settings->twitter_page_id = htmlspecialchars($input['twitter_page_id']);
		$settings->square_ad = stripslashes($input['square_ad']);

		$settings->analytics = stripslashes($input['analytics']);

		$settings->save();

		$data = array(
			'settings' => $settings,
			);

		return Redirect::to('admin/settings')->with(array('note' => 'Successfully updated site settings.', 'note_type' => 'success'));
	}

	public function flagged_answers()
	{
		$answers = CommentFlag::groupBy('comment_id')->get();
		$data = array(
			'flagged_answers' => $answers,
			);
		return View::make('admin.flagged_answers', $data);
	}

	public function flagged_users()
	{
		$users = UserFlag::groupBy('user_flagged_id')->get();
		$data = array(
			'flagged_users' => $users,
			);
		return View::make('admin.flagged_users', $data);
	}

	public function custom_css(){
		$data = array('custom_css' => Setting::first()->custom_css);
		return View::make('admin.custom_css', $data);
	}

	public function update_custom_css(){
		$css = Input::get('css');
		$settings = Setting::first();
		$settings->custom_css = $css;
		$settings->save();
		return $settings;
	}

	public function deactivate_user($id){
		$user = User::find($id);
		$user->active = 0;
		$user->save();
		
		return Redirect::to('admin/users');
	}

	public function activate_user($id){
		$user = User::find($id);
		$user->active = 1;
		$user->save();
		
		return Redirect::to('admin/users');
	}

	private function uploadImage($img){
		
		$file = $img;
		$upload_folder = 'uploads/settings/';

		if (!file_exists($upload_folder)) {
			mkdir($upload_folder, 0777, true);
		}

		$filename =  $file->getClientOriginalName();

		if (file_exists($upload_folder.$filename)) {
			$filename =  uniqid() . '-' . $filename;
		}

	    $uploadSuccess = $img->move($upload_folder, $filename);

		return $upload_folder . $filename;

	}

	public function toggle_active($id){
		$media = Media::find($id);
		if($media->active == 1){
			$media->active = 0;
		} else {
			$media->active = 1;
		}
		$media->save();
	}

}