<?php
/*
Plugin Name: Navi, by Bonfire 
Plugin URI: http://bonfirethemes.com/
Description: A stylish and lighweight WordPress menu. Customize under Appearance > Customize > Navi Plugin.
Version: 1.6
Author: اسکریپت دات کام
Author URI: http://www.اسکریپت.com
License: GPL2
*/

	//
	// Add meta tag to theme header (no tap highlighting on Windows devices)
	//
	function bonfire_navi_meta() {
	?>
		<meta name="msapplication-tap-highlight" content="no" /> 
	<?php
	}
	add_action('wp_head','bonfire_navi_meta');

	//
	// Add menu to theme
	//
	function bonfire_navi_footer() {
	?>

        <!-- BEGIN LOGO -->
        <?php if( get_theme_mod('bonfire_navi_hide_logo') != '') { ?>
        <?php } else { ?>
            <div class="navi-logo-wrapper<?php if( get_theme_mod('bonfire_navi_logo_position') == '') { ?><?php } else { ?> navi-left<?php } ?><?php if( get_theme_mod('bonfire_navi_absolute_position') != '') { ?> navi-absolute<?php } ?><?php if( get_theme_mod('bonfire_navi_logo_above_menu') != '') { ?> navi-logo-above-menu<?php } ?>">
            <?php if ( get_theme_mod( 'navi_logo' ) ) : ?>
                <!-- BEGIN LOGO IMAGE -->
                <div class="navi-logo-image<?php if ( is_admin_bar_showing() ) { ?> wp-toolbar-active<?php } ?>">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo get_theme_mod( 'navi_logo' ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"></a>
                </div>
                <!-- END LOGO IMAGE -->
            <?php else : ?>
                <!-- BEGIN LOGO -->
                <div class="navi-logo<?php if ( is_admin_bar_showing() ) { ?> wp-toolbar-active<?php } ?>">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <?php bloginfo('name'); ?>
                    </a>
                </div>
                <!-- END LOGO -->
            <?php endif; ?>
            </div>
        <?php } ?>
        <!-- END LOGO -->

		<!-- BEGIN MENU BUTTON -->
		<div class="navi-main-menu-button-wrapper<?php if ( is_admin_bar_showing() ) { ?> wp-toolbar-active<?php } ?><?php if( get_theme_mod('bonfire_navi_absolute_position') != '') { ?> navi-absolute<?php } ?><?php if( get_theme_mod('bonfire_navi_left_right_position') != '') { ?> navi-right<?php } ?>">
        
            <!-- BEGIN MENU BUTTON LABEL (if one is entered) -->
            <?php if(get_theme_mod('navi_menu_button_label') != '') { ?>
            <div class="navi-menu-button-label">
                <?php echo get_theme_mod('navi_menu_button_label'); ?>
            </div>
            <?php } ?>
            <!-- END MENU BUTTON LABEL (if one is entered) -->
            
            <!-- BEGIN MENU BUTTON STYLES -->
            <?php if( get_theme_mod('bonfire_navi_hide_menu_button') == '') { ?>
                <?php $navi_menu_button_style = get_theme_mod( 'bonfire_navi_menu_button_style' ); if( $navi_menu_button_style == '' ) { 
                    echo '
                    <div class="navi-main-menu-button">
                        <div class="navi-main-menu-button-middle"></div>
                    </div>
                    ';
                }
                else if( $navi_menu_button_style != '' ) { switch ( $navi_menu_button_style ) {
                case 'style1':
                echo '
                    <div class="navi-main-menu-button">
                        <div class="navi-main-menu-button-middle"></div>
                    </div>
                ';
                break; case 'style2':
                echo '
                    <div class="navi-main-menu-button-two">
                        <div class="navi-main-menu-button-two-middle"></div>
                    </div>
                ';
                break; case 'style3':
                echo '
                    <div class="navi-main-menu-button-three">
                        <div class="navi-main-menu-button-three-middle"></div>
                    </div>
                ';
                break; case 'style4':
                echo '
                    <div class="navi-main-menu-button-four">
                        <div class="navi-main-menu-button-four-middle"></div>
                    </div>
                ';
                break; case 'style5':
                echo '
                    <div class="navi-main-menu-button-five">
                        <div class="navi-main-menu-button-five-middle"></div>
                    </div>
                ';
                break; case 'style6':
                echo '
                    <div class="navi-main-menu-button-six">
                    </div>
                ';
                break; }} ?>
            <?php } ?>
            <!-- END MENU BUTTON STYLES -->
		</div>
		<!-- END MENU BUTTON -->

		<!-- BEGIN MAIN WRAPPER -->
		<div class="navi-main-wrapper<?php if ( is_admin_bar_showing() ) { ?> wp-toolbar-active<?php } ?>">
			<!-- BEGIN MENU -->
			<div class="navi-menu-wrapper">
				<!-- BEGIN MENU -->
				<?php wp_nav_menu( array( 'container_class' => 'navi-by-bonfire', 'theme_location' => 'navi-by-bonfire', 'fallback_cb' => '' ) ); ?>
				<!-- END MENU -->
			</div>
			<!-- END MENU -->
		</div>
		<!-- END MAIN WRAPPER -->
		
		<!-- BEGIN BACKGROUND LINES -->
		<div class="navi-bg-lines-wrapper">
			<div class="navi-bg-line-one"></div>
			<div class="navi-bg-line-two"></div>
			<div class="navi-bg-line-three"></div>
			<div class="navi-bg-line-four"></div>
			<div class="navi-bg-line-five"></div>
			<div class="navi-bg-line-six"></div>
		</div>
		<!-- END BACKGROUND LINES -->
		
        <!-- BEGIN BACKGROUND IMAGE -->
        <div class="navi-background-image" style="background-image:url(<?php echo get_theme_mod('navi_background_image'); ?>);"></div>
        <!-- END BACKGROUND IMAGE -->
        
		<!-- BEGIN MAIN BACKGROUND -->
		<div class="navi-main-background<?php if ( is_admin_bar_showing() ) { ?> wp-toolbar-active<?php } ?>">
		</div>
		<!-- END MAIN BACKGROUND -->

	<?php
	}
	add_action('wp_footer','bonfire_navi_footer');

    //
	// WORDPRESS LIVE CUSTOMIZER
	//
	function navi_theme_customizer( $wp_customize ) {
	
        //
        // ADD "NAVI" PANEL TO LIVE CUSTOMIZER 
        //
        $wp_customize->add_panel('navi_panel', array('title' => __('Navi Plugin', 'navi'),'priority' => 10,));

        //
        // ADD "MENU BUTTON" SECTION TO "NAVI" PANEL 
        //
        $wp_customize->add_section('navi_menu_button_section',array('title' => __( 'Menu Button', 'navi' ),'panel' => 'navi_panel','priority' => 10));
        
        /* hide menu button */
        $wp_customize->add_setting('bonfire_navi_hide_menu_button',array('sanitize_callback' => 'sanitize_bonfire_navi_hide_menu_button',));
        function sanitize_bonfire_navi_hide_menu_button( $input ) { if ( $input == 1 ) { return 1; } else { return ''; } }
        $wp_customize->add_control('bonfire_navi_hide_menu_button',array('type' => 'checkbox','label' => 'Hide menu button','description' => 'Useful if you want to use a custom element as the menu activator, in which case give it the "navi-main-menu-activator" class. Menu label will remain visible (if one is entered below).', 'section' => 'navi_menu_button_section',));
        
        /* menu button left/right */
        $wp_customize->add_setting('bonfire_navi_left_right_position',array('sanitize_callback' => 'sanitize_bonfire_navi_left_right_position',));
        function sanitize_bonfire_navi_left_right_position( $input ) { if ( $input == 1 ) { return 1; } else { return ''; } }
        $wp_customize->add_control('bonfire_navi_left_right_position',array('type' => 'checkbox','label' => 'Show menu button on the right','description' => 'If unticked, button will appear on the left', 'section' => 'navi_menu_button_section',));
        
        /* menu button style */
        $wp_customize->add_setting('bonfire_navi_menu_button_style',array(
            'default' => 'style1',
        ));
        $wp_customize->add_control('bonfire_navi_menu_button_style',array(
            'type' => 'select',
            'label' => 'Button style',
            'section' => 'navi_menu_button_section',
            'choices' => array(
                'style1' => 'Style #1',
                'style2' => 'Style #2',
                'style3' => 'Style #3',
                'style4' => 'Style #4',
                'style5' => 'Style #5',
                'style6' => 'Style #6',
        ),
        ));
        
        /* menu button animation */
        $wp_customize->add_setting('bonfire_navi_button_style',array( 'default' => 'styleone' ));
        $wp_customize->add_control('bonfire_navi_button_style',
            array(
                'type' => 'radio',
                'label' => 'Animation',
                'description' => 'Choose menu button animation style',
                'choices' => array(
                    'styleone' => 'No animation',
                    'styletwo' => 'Minus sign',
                    'stylethree' => 'X sign',
                ),
                'section' => 'navi_menu_button_section',
            ));
        
        /* menu button color */
        $wp_customize->add_setting( 'bonfire_navi_menu_button_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_menu_button_color',array(
            'label' => 'Menu button color', 'section' => 'navi_menu_button_section', 'settings' => 'bonfire_navi_menu_button_color' )
        ));
        
        /* menu button hover color */
        $wp_customize->add_setting( 'bonfire_navi_menu_button_hover_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_menu_button_hover_color',array(
            'label' => 'Menu button hover color', 'section' => 'navi_menu_button_section', 'settings' => 'bonfire_navi_menu_button_hover_color' )
        ));
        
        /* active menu button color */
        $wp_customize->add_setting( 'bonfire_navi_menu_button_active_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_menu_button_active_color',array(
                'label' => 'Active menu button color', 'section' => 'navi_menu_button_section', 'settings' => 'bonfire_navi_menu_button_active_color' )
        ));
        
        /* active menu button hover color */
        $wp_customize->add_setting( 'bonfire_navi_menu_button_active_hover_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_menu_button_active_hover_color',array(
                'label' => 'Active menu button hover color', 'section' => 'navi_menu_button_section', 'settings' => 'bonfire_navi_menu_button_active_hover_color' )
        ));
        
        /* menu button top distance */
        $wp_customize->add_setting('bonfire_navi_menu_button_top',array('sanitize_callback' => 'sanitize_bonfire_navi_menu_button_top',));
        function sanitize_bonfire_navi_menu_button_top($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('bonfire_navi_menu_button_top',array(
            'type' => 'text',
            'label' => 'Top distance (in pixels)',
            'description' => 'Example: 75.',
            'section' => 'navi_menu_button_section',
        ));
        
        /* menu button side distance */
        $wp_customize->add_setting('bonfire_navi_menu_button_side',array('sanitize_callback' => 'sanitize_bonfire_navi_menu_button_side',));
        function sanitize_bonfire_navi_menu_button_side($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('bonfire_navi_menu_button_side',array(
            'type' => 'text',
            'label' => 'Side distance (in pixels)',
            'description' => 'Example: 75.',
            'section' => 'navi_menu_button_section',
        ));
        
        
        
        
        
        
        
        
        
        /* menu button label */
        $wp_customize->add_setting('navi_menu_button_label',array('default' => '','sanitize_callback' => 'sanitize_navi_menu_button_label',));
        function sanitize_navi_menu_button_label($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('navi_menu_button_label',array('type' => 'text','label' => 'Label','description' => 'If empty, no label will be shown','section' => 'navi_menu_button_section',));
        
        /* menu button label horizontal position */
        $wp_customize->add_setting('navi_menu_button_label_horizontal_position',array('default' => '','sanitize_callback' => 'sanitize_navi_menu_button_label_horizontal_position',));
        function sanitize_navi_menu_button_label_horizontal_position($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('navi_menu_button_label_horizontal_position',array('type' => 'text','label' => 'Label horizontal position (in pixels)','description' => 'Label position is relative to the menu button. Negative values accepted. If empty, defaults to 40 (if empty when menu button is hidden, defaults to 0)','section' => 'navi_menu_button_section',));
        
        /* menu button label vertical position */
        $wp_customize->add_setting('navi_menu_button_label_vertical_position',array('default' => '','sanitize_callback' => 'sanitize_navi_menu_button_label_vertical_position',));
        function sanitize_navi_menu_button_label_vertical_position($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('navi_menu_button_label_vertical_position',array('type' => 'text','label' => 'Label vertical position (in pixels)','description' => 'Label position is relative to the menu button. Negative values accepted. If empty, defaults to 6 (if empty when menu button is hidden, defaults to 0)','section' => 'navi_menu_button_section',));

        /* menu button label color */
        $wp_customize->add_setting( 'navi_menu_button_label_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'navi_menu_button_label_color',array(
            'label' => 'Label', 'settings' => 'navi_menu_button_label_color', 'section' => 'navi_menu_button_section' )
        ));
        
        /* menu button label hover color */
        $wp_customize->add_setting( 'navi_menu_button_label_hover_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'navi_menu_button_label_hover_color',array(
            'label' => 'Label Hover', 'settings' => 'navi_menu_button_label_hover_color', 'section' => 'navi_menu_button_section' )
        ));
        
        /* menu button label font size */
        $wp_customize->add_setting('navi_menu_button_label_font_size',array('default' => '','sanitize_callback' => 'sanitize_navi_menu_button_label_font_size',));
        function sanitize_navi_menu_button_label_font_size($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('navi_menu_button_label_font_size',array('type' => 'text','label' => 'Label font size (in pixels)','description' => 'If empty, defaults to 11','section' => 'navi_menu_button_section',));

        
        

        //
        // ADD "LOGO" SECTION TO "NAVI" PANEL 
        //
        $wp_customize->add_section('navi_logo_section',array('title' => __( 'Logo', 'navi' ),'panel' => 'navi_panel','priority' => 11,));
        
        /* hide logo */
        $wp_customize->add_setting('bonfire_navi_hide_logo',array('sanitize_callback' => 'sanitize_bonfire_navi_hide_logo',));
        function sanitize_bonfire_navi_hide_logo( $input ) { if ( $input == 1 ) { return 1; } else { return ''; } }
        $wp_customize->add_control('bonfire_navi_hide_logo',array('type' => 'checkbox','label' => 'Hide logo','description' => 'Tick if you want to hide the logo', 'section' => 'navi_logo_section',));
        
        /* show logo on left */
        $wp_customize->add_setting('bonfire_navi_logo_position',array('sanitize_callback' => 'sanitize_bonfire_navi_logo_position',));
        function sanitize_bonfire_navi_logo_position( $input ) {if ( $input == 1 ) {return 1;} else {return '';}}
        $wp_customize->add_control('bonfire_navi_logo_position',array('type' => 'checkbox','label' => 'Show logo on left','description' => 'If unticked, logo will appear on the right','section' => 'navi_logo_section',));
        
        /* show logo above menu */
        $wp_customize->add_setting('bonfire_navi_logo_above_menu',array('sanitize_callback' => 'sanitize_bonfire_navi_logo_above_menu',));
        function sanitize_bonfire_navi_logo_above_menu( $input ) {if ( $input == 1 ) {return 1;} else {return '';}}
        $wp_customize->add_control('bonfire_navi_logo_above_menu',array('type' => 'checkbox','label' => 'Show logo above menu','description' => 'If unticked, logo will appear below menu','section' => 'navi_logo_section',));
        
        /* logo upload */
        $wp_customize->add_setting( 'navi_logo',array ( 'default' => '','sanitize_callback' => 'esc_url_raw'));
        $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,'navi_logo',array('label' => 'Logo image','description' => 'Upload a logo image to replace the default site name','section' => 'navi_logo_section','settings' => 'navi_logo',)));
        
        /* logo text color */
        $wp_customize->add_setting( 'bonfire_navi_logo_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_logo_color',array( 'label' => 'Logo color', 'section' => 'navi_logo_section', 'settings' => 'bonfire_navi_logo_color' )));
        
        /* logo text hover color */
        $wp_customize->add_setting( 'bonfire_navi_logo_hover_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_logo_hover_color',array( 'label' => 'Logo hover color', 'section' => 'navi_logo_section', 'settings' => 'bonfire_navi_logo_hover_color' )));
        
        /* logo top distance */
        $wp_customize->add_setting('bonfire_navi_logo_top',array('sanitize_callback' => 'sanitize_bonfire_navi_logo_top',));
        function sanitize_bonfire_navi_logo_top($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('bonfire_navi_logo_top',array(
            'type' => 'text',
            'label' => 'Top distance (in pixels)',
            'description' => 'Example: 50.',
            'section' => 'navi_logo_section',
        ));
        
        /* logo side distance */
        $wp_customize->add_setting('bonfire_navi_logo_side',array('sanitize_callback' => 'sanitize_bonfire_navi_logo_side',));
        function sanitize_bonfire_navi_logo_side($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('bonfire_navi_logo_side',array('label' => 'Side distance (in pixels)','description' => 'Example: 50.','section' => 'navi_logo_section','type' => 'text',));

        //
        // ADD "MENU" SECTION TO "NAVI" PANEL 
        //
        $wp_customize->add_section('navi_menu_section',array('title' => __( 'Menu', 'navi' ),'panel'  => 'navi_panel','priority' => 12));
        
        /* background image */
        $wp_customize->add_setting( 'navi_background_image' );
        $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'navi_background_image',array(
            'label' => 'Background image',
            'description' => 'Choose background image',
            'section' => 'navi_menu_section',
            'settings' => 'navi_background_image'
            )
        ));
        
        /* background as pattern */
        $wp_customize->add_setting('navi_background_pattern',array('sanitize_callback' => 'sanitize_navi_background_pattern',));
        function sanitize_navi_background_pattern( $input ) {if ( $input == 1 ) {return 1;} else {return '';}}
        $wp_customize->add_control('navi_background_pattern',array('type' => 'checkbox','label' => 'Show background image as pattern','section' => 'navi_menu_section',));
        
        /* background image opacity */
        $wp_customize->add_setting('navi_background_image_opacity',array('default' => '','sanitize_callback' => 'sanitize_navi_background_image_opacity',));
        function sanitize_navi_background_image_opacity($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('navi_background_image_opacity',array('type' => 'text','label' => 'Background image opacity','description' => 'Example: 0.5. If empty, defaults to 1.','section' => 'navi_menu_section',));
        
        /* background color */
        $wp_customize->add_setting( 'bonfire_navi_menu_background_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_menu_background_color',array( 'label' => 'Background', 'section' => 'navi_menu_section', 'settings' => 'bonfire_navi_menu_background_color' )));
        
        /* background opacity */
        $wp_customize->add_setting('bonfire_navi_menu_background_opacity',array('sanitize_callback' => 'sanitize_bonfire_navi_menu_background_opacity',));
        function sanitize_bonfire_navi_menu_background_opacity($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('bonfire_navi_menu_background_opacity',array(
            'type' => 'text',
            'label' => 'Background opacity (0-1)',
            'description' => 'Example: 0.75. If empty, defaults to 0.9',
            'section' => 'navi_menu_section',
        ));
        
        /* background lines color */
        $wp_customize->add_setting( 'bonfire_navi_menu_background_lines_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_menu_background_lines_color',array( 'label' => 'Background lines', 'section' => 'navi_menu_section', 'settings' => 'bonfire_navi_menu_background_lines_color' )));
        
        /* background lines opacity */
        $wp_customize->add_setting('bonfire_navi_menu_background_lines_opacity',array('sanitize_callback' => 'sanitize_bonfire_navi_menu_background_lines_opacity',));
        function sanitize_bonfire_navi_menu_background_lines_opacity($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('bonfire_navi_menu_background_lines_opacity',array(
            'type' => 'text',
            'label' => 'Background lines opacity (0-1)',
            'description' => 'Example: 0.25. If empty, defaults to 0.1',
            'section' => 'navi_menu_section',
        ));
        
        /* menu item color */
        $wp_customize->add_setting( 'bonfire_navi_menu_item_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_menu_item_color',array( 'label' => 'Menu item', 'section' => 'navi_menu_section', 'settings' => 'bonfire_navi_menu_item_color' )));
        
        /* menu item hover color */
        $wp_customize->add_setting( 'bonfire_navi_menu_item_hover_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_menu_item_hover_color',array( 'label' => 'Menu item hover', 'section' => 'navi_menu_section', 'settings' => 'bonfire_navi_menu_item_hover_color' )));
        
        /* current item color */
        $wp_customize->add_setting( 'bonfire_navi_menu_current_item_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_menu_current_item_color',array( 'label' => 'Current menu item', 'section' => 'navi_menu_section', 'settings' => 'bonfire_navi_menu_current_item_color' )));
        
        /* menu arrow color */
        $wp_customize->add_setting( 'bonfire_navi_menu_arrow_color', array( 'sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'bonfire_navi_menu_arrow_color',array( 'label' => 'Menu arrow', 'section' => 'navi_menu_section', 'settings' => 'bonfire_navi_menu_arrow_color' )));
        
        /* menu top distance */
        $wp_customize->add_setting('bonfire_navi_menu_top_distance',array('sanitize_callback' => 'sanitize_bonfire_navi_menu_top_distance',));
        function sanitize_bonfire_navi_menu_top_distance($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('bonfire_navi_menu_top_distance',array(
            'type' => 'text',
            'label' => 'Top distance (in pixels)',
            'description' => 'Example: 200.',
            'section' => 'navi_menu_section',
        ));
        
        /* menu side distance */
        $wp_customize->add_setting('bonfire_navi_menu_side_distance',array('sanitize_callback' => 'sanitize_bonfire_navi_menu_side_distance',));
        function sanitize_bonfire_navi_menu_side_distance($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('bonfire_navi_menu_side_distance',array(
            'type' => 'text',
            'label' => 'Side distance (in pixels)',
            'description' => 'Example: 200.',
            'section' => 'navi_menu_section',
        ));
        
        /* menu on the right */
        $wp_customize->add_setting('navi_menu_right_position',array('sanitize_callback' => 'sanitize_navi_menu_right_position',));
        function sanitize_navi_menu_right_position( $input ) {if ( $input == 1 ) {return 1;} else {return '';}}
        $wp_customize->add_control('navi_menu_right_position',array('type' => 'checkbox','label' => 'Show menu on right side','section' => 'navi_menu_section',));

        //
        // ADD "MISC" SECTION TO "NAVI" PANEL 
        //
        $wp_customize->add_section('navi_misc_section',array('title' => __( 'Misc', 'navi' ),'panel'  => 'navi_panel','priority' => 13));
        
        /* absolute position */
        $wp_customize->add_setting('bonfire_navi_absolute_position',array('sanitize_callback' => 'sanitize_bonfire_navi_absolute_position',));
        function sanitize_bonfire_navi_absolute_position( $input ) { if ( $input == 1 ) { return 1; } else { return ''; } }
        $wp_customize->add_control('bonfire_navi_absolute_position',array('type' => 'checkbox','label' => 'Absolute positioning','description' => 'Menu button and logo will leave the screen when scrolled', 'section' => 'navi_misc_section',));
        
        /* smaller than */
        $wp_customize->add_setting('bonfire_navi_smaller_than',array('sanitize_callback' => 'sanitize_bonfire_navi_smaller_than',));
        function sanitize_bonfire_navi_smaller_than($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('bonfire_navi_smaller_than',array(
            'type' => 'text',
            'label' => 'Hide at certain width/resolution',
            'description' => '<strong>Example #1:</strong> If you want to show Navi on desktop only, enter the values as 0 and 500. <br><br> <strong>Example #2:</strong> If you want to show Navi on mobile only, enter the values as 500 and 5000. <br><br> Feel free to experiment with your own values to get the result that is right for you. If fields are empty, Navi will be visible at all browser widths and resolutions. <br><br> Hide Navi menu if browser width or screen resolution (in pixels) is between...',
            'section' => 'navi_misc_section',
        ));
        
        /* larger than */
        $wp_customize->add_setting('bonfire_navi_larger_than',array('sanitize_callback' => 'sanitize_bonfire_navi_larger_than',));
        function sanitize_bonfire_navi_larger_than($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('bonfire_navi_larger_than',array(
            'type' => 'text',
            'description' => '..and:',
            'section' => 'navi_misc_section',
        ));
        
        /* hide theme menu */
        $wp_customize->add_setting('bonfire_navi_hide_theme_menu',array('sanitize_callback' => 'sanitize_bonfire_navi_hide_theme_menu',));
        function sanitize_bonfire_navi_hide_theme_menu($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('bonfire_navi_hide_theme_menu',array(
            'type' => 'text',
            'label' => 'Advanced: Hide theme menu',
            'description' => 'If you have set Navi to show only at a certain resolution, know the class/ID of your theme menu and would like to hide it when Navi is visible, enter the class/ID into this field (example: "#my-theme-menu"). Multiple classes/IDs can be entered (separate with comma as you would in a stylesheet).',
            'section' => 'navi_misc_section',
        ));

	}
	add_action('customize_register', 'navi_theme_customizer');

    //
	// ENQUEUE navi.css
	//
	function bonfire_navi_css() {
		wp_register_style( 'bonfire-navi-css', plugins_url( '/navi.css', __FILE__ ) . '', array(), '1', 'all' );
		wp_enqueue_style( 'bonfire-navi-css' );
	}
	add_action( 'wp_enqueue_scripts', 'bonfire_navi_css' );

	//
	// ENQUEUE navi-accordion.js
	//
	function bonfire_navi_accordion() {
		wp_register_script( 'bonfire-navi-accordion', plugins_url( '/navi-accordion.js', __FILE__ ) . '', array( 'jquery' ), '1' );  
		wp_enqueue_script( 'bonfire-navi-accordion' );
	}
	add_action( 'wp_enqueue_scripts', 'bonfire_navi_accordion' );

	//
	// ENQUEUE navi.js
	//
	function bonfire_navi_js() {
		wp_register_script( 'bonfire-navi-js', plugins_url( '/navi.js', __FILE__ ) . '', array( 'jquery' ), '1', true );  
		wp_enqueue_script( 'bonfire-navi-js' );
	}
	add_action( 'wp_enqueue_scripts', 'bonfire_navi_js' );

	//
	// Enqueue Google WebFonts
	//
	function bonfire_navi_font() {
	$protocol = is_ssl() ? 'https' : 'http';
		wp_enqueue_style( 'bonfire-navi-font', "$protocol://fonts.googleapis.com/css?family=Roboto:300,400' rel='stylesheet' type='text/css" );
	}
	add_action( 'wp_enqueue_scripts', 'bonfire_navi_font' );

	//
	// Register Custom Menu Function
	//
	if (function_exists('register_nav_menus')) {
		register_nav_menus( array(
			'navi-by-bonfire' => ( 'Navi Plugin' )
		) );
	}
    
    //
	// Add 'Settings' link to plugin page
	//
    add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'navi_add_action_links' );
    function navi_add_action_links ( $links ) {
        $mylinks = array(
        '<a href="' . admin_url( 'customize.php?autofocus[panel]=navi_panel' ) . '">Settings</a>',
        );
    return array_merge( $links, $mylinks );
    }

	//
	// Insert theme customizer options into the footer
	//
	function bonfire_navi_header_customize() {
	?>
		<style>
		/**************************************************************
		*** CUSTOM STYLING
		**************************************************************/
		/* logo */
        .navi-logo a { color:<?php echo get_theme_mod('bonfire_navi_logo_color'); ?>; }
        .navi-logo a:hover { color:<?php echo get_theme_mod('bonfire_navi_logo_hover_color'); ?>; }
        /* menu button */
		.navi-main-menu-button:before,
		.navi-main-menu-button div.navi-main-menu-button-middle:before,
        .navi-main-menu-button:after,
        .navi-main-menu-button-two:before,
		.navi-main-menu-button-two div.navi-main-menu-button-two-middle:before,
        .navi-main-menu-button-two:after,
        .navi-main-menu-button-three:before,
		.navi-main-menu-button-three div.navi-main-menu-button-three-middle:before,
        .navi-main-menu-button-three:after,
        .navi-main-menu-button-four:before,
		.navi-main-menu-button-four div.navi-main-menu-button-four-middle:before,
        .navi-main-menu-button-four:after,
        .navi-main-menu-button-five:before,
		.navi-main-menu-button-five div.navi-main-menu-button-five-middle:before,
        .navi-main-menu-button-five:after,
        .navi-main-menu-button-six:before,
        .navi-main-menu-button-six:after { background-color:<?php echo get_theme_mod('bonfire_navi_menu_button_color'); ?>; }
        /* if menu button hidden, remove button height and set default label position to 0 */
        <?php if(get_theme_mod('bonfire_navi_hide_menu_button') != '') { ?>
        .navi-main-menu-button-wrapper { height:auto; }
        .navi-menu-button-label { top:0; left:0; }
        <?php } ?>
        /* menu button label */
        .navi-menu-button-label {
            left:<?php echo get_theme_mod('navi_menu_button_label_horizontal_position'); ?>px;
            top:<?php echo get_theme_mod('navi_menu_button_label_vertical_position'); ?>px;
            color:<?php echo get_theme_mod('navi_menu_button_label_color'); ?>;
            font-size:<?php echo get_theme_mod('navi_menu_button_label_font_size'); ?>px;
        }
		/* menu button hover */
		<?php if ( wp_is_mobile() ) { ?>
		<?php } else { ?>
            /* menu label hover */
            .navi-main-menu-button-wrapper:hover .navi-menu-button-label { color:<?php echo get_theme_mod('navi_menu_button_label_hover_color'); ?>; }
            /* menu button style #2 hovers */
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-two:before { width:20px; margin-left:10px; }
            .navi-menu-active .navi-main-menu-button-wrapper:hover .navi-main-menu-button-two:before { margin-left:0; }
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-two:after { width:30px; margin-left:0; }
            /* menu button style #3 hovers */
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-three div.navi-main-menu-button-three-middle:before { width:25px; }
            /* menu button style #4 hovers */
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-four:before { width:15px; }
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-four:after { width:25px; }
            /* hover colors */
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button:before,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button div.navi-main-menu-button-middle:before,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button:after,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-two:before,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-two div.navi-main-menu-button-two-middle:before,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-two:after,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-three:before,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-three div.navi-main-menu-button-three-middle:before,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-three:after,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-four:before,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-four div.navi-main-menu-button-four-middle:before,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-four:after,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-five:before,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-five div.navi-main-menu-button-five-middle:before,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-five:after,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-six:before,
            .navi-main-menu-button-wrapper:hover .navi-main-menu-button-six:after { background-color:<?php echo get_theme_mod('bonfire_navi_menu_button_hover_color'); ?>; }
		<?php } ?>
		/* menu button active */
		.navi-menu-active .navi-main-menu-button:before,
		.navi-menu-active .navi-main-menu-button div.navi-main-menu-button-middle:before,
        .navi-menu-active .navi-main-menu-button:after,
        .navi-menu-active .navi-main-menu-button-two:before,
		.navi-menu-active .navi-main-menu-button-two div.navi-main-menu-button-two-middle:before,
        .navi-menu-active .navi-main-menu-button-two:after,
        .navi-menu-active .navi-main-menu-button-three:before,
		.navi-menu-active .navi-main-menu-button-three div.navi-main-menu-button-three-middle:before,
        .navi-menu-active .navi-main-menu-button-three:after,
        .navi-menu-active .navi-main-menu-button-four:before,
		.navi-menu-active .navi-main-menu-button-four div.navi-main-menu-button-four-middle:before,
        .navi-menu-active .navi-main-menu-button-four:after,
        .navi-menu-active .navi-main-menu-button-five:before,
		.navi-menu-active .navi-main-menu-button-five div.navi-main-menu-button-five-middle:before,
        .navi-menu-active .navi-main-menu-button-five:after,
        .navi-menu-active .navi-main-menu-button-six:before,
        .navi-menu-active .navi-main-menu-button-six:after { background-color:<?php echo get_theme_mod('bonfire_navi_menu_button_active_color'); ?>; }
		/* menu button active hover */
		<?php if ( wp_is_mobile() ) { ?>
		<?php } else { ?>
            .navi-menu-active .navi-main-menu-button:hover:before,
            .navi-menu-active .navi-main-menu-button:hover div.navi-main-menu-button-middle:before,
            .navi-menu-active .navi-main-menu-button:hover:after,
            .navi-menu-active .navi-main-menu-button-two:hover:before,
            .navi-menu-active .navi-main-menu-button-two:hover div.navi-main-menu-button-two-middle:before,
            .navi-menu-active .navi-main-menu-button-two:hover:after,
            .navi-menu-active .navi-main-menu-button-three:hover:before,
            .navi-menu-active .navi-main-menu-button-three:hover div.navi-main-menu-button-three-middle:before,
            .navi-menu-active .navi-main-menu-button-three:hover:after,
            .navi-menu-active .navi-main-menu-button-four:hover:before,
            .navi-menu-active .navi-main-menu-button-four:hover div.navi-main-menu-button-four-middle:before,
            .navi-menu-active .navi-main-menu-button-four:hover:after,
            .navi-menu-active .navi-main-menu-button-five:hover:before,
            .navi-menu-active .navi-main-menu-button-five:hover div.navi-main-menu-button-five-middle:before,
            .navi-menu-active .navi-main-menu-button-five:hover:after,
            .navi-menu-active .navi-main-menu-button-six:hover:before,
            .navi-menu-active .navi-main-menu-button-six:hover:after { background-color:<?php echo get_theme_mod('bonfire_navi_menu_button_active_hover_color'); ?>; }
		<?php } ?>

		/* menu */
		.navi-main-background { background-color:<?php echo get_theme_mod('bonfire_navi_menu_background_color'); ?>; }
		.navi-bg-line-one,
		.navi-bg-line-two,
		.navi-bg-line-three,
		.navi-bg-line-four,
		.navi-bg-line-five,
		.navi-bg-line-six { background-color:<?php echo get_theme_mod('bonfire_navi_menu_background_lines_color'); ?>; }
		.navi-by-bonfire ul li a,
		.navi-by-bonfire ul li ul.sub-menu li a { color:<?php echo get_theme_mod('bonfire_navi_menu_item_color'); ?>; }
		.navi-by-bonfire ul li a:hover,
		.navi-by-bonfire ul li ul.sub-menu li a:hover {color:<?php echo get_theme_mod('bonfire_navi_menu_item_hover_color'); ?> !important; }
		.navi-by-bonfire ul li.current-menu-item a,
		.navi-by-bonfire ul li ul.sub-menu li.current-menu-item a { color:<?php echo get_theme_mod('bonfire_navi_menu_current_item_color'); ?>; }
		.sub-menu-arrow-line { background-color:<?php echo get_theme_mod('bonfire_navi_menu_arrow_color'); ?>; }
		.sub-menu-arrow-tip-right { border-left-color:<?php echo get_theme_mod('bonfire_navi_menu_arrow_color'); ?>; }
		.sub-menu-arrow-tip-left { border-right-color:<?php echo get_theme_mod('bonfire_navi_menu_arrow_color'); ?>; }

        /* fine-tune logo top/left/right distance */
		<?php if( get_theme_mod('bonfire_navi_logo_position') == '') { ?>
        .navi-logo-wrapper {
			top:<?php echo get_theme_mod('bonfire_navi_logo_top'); ?>px;
			left:auto;
			right:<?php echo get_theme_mod('bonfire_navi_logo_side'); ?>px;
		}
		<?php } else { ?>
		.navi-logo-wrapper {
			top:<?php echo get_theme_mod('bonfire_navi_logo_top'); ?>px;
			left:<?php echo get_theme_mod('bonfire_navi_logo_side'); ?>px;
		}
		<?php } ?>

		/* fine-tune menu button top/left/right distance */
		<?php if( get_theme_mod('bonfire_navi_left_right_position') == '') { ?>
		.navi-main-menu-button-wrapper {
			top:<?php echo get_theme_mod('bonfire_navi_menu_button_top'); ?>px;
			left:<?php echo get_theme_mod('bonfire_navi_menu_button_side'); ?>px;
		}
		<?php } else { ?>
		.navi-main-menu-button-wrapper {
			top:<?php echo get_theme_mod('bonfire_navi_menu_button_top'); ?>px;
			left:auto;
			right:<?php echo get_theme_mod('bonfire_navi_menu_button_side'); ?>px;
		}
		<?php } ?>
		
        /* background image as cover/pattern + background image opacity */
        .navi-background-image {
        <?php if( get_theme_mod('navi_background_pattern') == '') { ?>
            background-size:cover;
            background-repeat:no-repeat;
        <?php } else { ?>
            background-repeat:repeat;
        <?php } ?>
        }
        .navi-background-image-active {
            opacity:<?php echo get_theme_mod('navi_background_image_opacity'); ?>;
        }
        
		/* background opacity */
		.navi-main-background-active {
			opacity:<?php echo get_theme_mod('bonfire_navi_menu_background_opacity'); ?>;
		}
		/* background lines opacity */
		.navi-bg-lines-wrapper-active {
			opacity:<?php echo get_theme_mod('bonfire_navi_menu_background_lines_opacity'); ?>;
		}
		
		/* menu top/side distance, right positioning */
		.navi-menu-wrapper {
            top:<?php echo get_theme_mod('bonfire_navi_menu_top_distance'); ?>px;
        <?php if( get_theme_mod('navi_menu_right_position') == '') { ?>
            margin-left:<?php echo get_theme_mod('bonfire_navi_menu_side_distance'); ?>px;
        <?php } else { ?>
            margin-left:auto;
            margin-right:<?php echo get_theme_mod('bonfire_navi_menu_side_distance'); ?>px;
        <?php } ?>
		}

        /* menu button animations (-/X) */
        <?php $bonfire_navi_button_style = get_theme_mod('bonfire_navi_button_style'); if($bonfire_navi_button_style != '') { switch ($bonfire_navi_button_style) { ?><?php case 'styletwo': ?>
        /* MINUS SIGN ANIMATION */
            /* button style #1 top bar*/
			.navi-menu-active .navi-main-menu-button:before {
				opacity:0;
				
				-webkit-transform:translateX(10px);
				-moz-transform:translateX(10px);
				transform:translateX(10px);
				
				-webkit-transition:-webkit-transform .25s ease, opacity .15s ease .1s;
				-moz-transition:-moz-transform .25s ease, opacity .15s ease .1s;
				transition:transform .25s ease, opacity .15s ease .1s;
			}
			/* button style #1 bottom bar*/
			.navi-menu-active .navi-main-menu-button:after {
				opacity:0;
				
				-webkit-transform:translateX(-10px);
				-moz-transform:translateX(-10px);
				transform:translateX(-10px);
				
				-webkit-transition:-webkit-transform .25s ease, opacity .15s ease .1s;
				-moz-transition:-moz-transform .25s ease, opacity .15s ease .1s;
				transition:transform .25s ease, opacity .15s ease .1s;
			}
            /* button style #2 top bar*/
			.navi-menu-active .navi-main-menu-button-two:before {
				opacity:0;
				
				-webkit-transform:translateX(10px);
				-moz-transform:translateX(10px);
				transform:translateX(10px);
				
				-webkit-transition:-webkit-transform .25s ease, opacity .15s ease .1s;
				-moz-transition:-moz-transform .25s ease, opacity .15s ease .1s;
				transition:transform .25s ease, opacity .15s ease .1s;
			}
			/* button style #2 bottom bar*/
			.navi-menu-active .navi-main-menu-button-two:after {
				opacity:0;
				
				-webkit-transform:translateX(-10px);
				-moz-transform:translateX(-10px);
				transform:translateX(-10px);
				
				-webkit-transition:-webkit-transform .25s ease, opacity .15s ease .1s;
				-moz-transition:-moz-transform .25s ease, opacity .15s ease .1s;
				transition:transform .25s ease, opacity .15s ease .1s;
			}
            /* button style #3 top bar*/
			.navi-menu-active .navi-main-menu-button-three:before {
				opacity:0;
				
				-webkit-transform:translateX(10px);
				-moz-transform:translateX(10px);
				transform:translateX(10px);
				
				-webkit-transition:-webkit-transform .25s ease, opacity .15s ease .1s;
				-moz-transition:-moz-transform .25s ease, opacity .15s ease .1s;
				transition:transform .25s ease, opacity .15s ease .1s;
			}
			/* button style #3 bottom bar*/
			.navi-menu-active .navi-main-menu-button-three:after {
				opacity:0;
				
				-webkit-transform:translateX(-10px);
				-moz-transform:translateX(-10px);
				transform:translateX(-10px);
				
				-webkit-transition:-webkit-transform .25s ease, opacity .15s ease .1s;
				-moz-transition:-moz-transform .25s ease, opacity .15s ease .1s;
				transition:transform .25s ease, opacity .15s ease .1s;
			}
            /* button style #3 middle bar*/
            .navi-menu-active div.navi-main-menu-button-three-middle:before {
                width:25px;
            }
            /* button style #4 top bar*/
			.navi-menu-active .navi-main-menu-button-four:before {
				opacity:0;
				
				-webkit-transform:translateX(10px);
				-moz-transform:translateX(10px);
				transform:translateX(10px);
				
				-webkit-transition:-webkit-transform .25s ease, opacity .15s ease .1s;
				-moz-transition:-moz-transform .25s ease, opacity .15s ease .1s;
				transition:transform .25s ease, opacity .15s ease .1s;
			}
			/* button style #4 bottom bar*/
			.navi-menu-active .navi-main-menu-button-four:after {
				opacity:0;
				
				-webkit-transform:translateX(-10px);
				-moz-transform:translateX(-10px);
				transform:translateX(-10px);
				
				-webkit-transition:-webkit-transform .25s ease, opacity .15s ease .1s;
				-moz-transition:-moz-transform .25s ease, opacity .15s ease .1s;
				transition:transform .25s ease, opacity .15s ease .1s;
			}
            /* button style #5 top bar*/
			.navi-menu-active .navi-main-menu-button-five:before {
				opacity:0;
				
				-webkit-transform:translateX(10px);
				-moz-transform:translateX(10px);
				transform:translateX(10px);
				
				-webkit-transition:-webkit-transform .25s ease, opacity .15s ease .1s;
				-moz-transition:-moz-transform .25s ease, opacity .15s ease .1s;
				transition:transform .25s ease, opacity .15s ease .1s;
			}
			/* button style #5 bottom bar*/
			.navi-menu-active .navi-main-menu-button-five:after {
				opacity:0;
				
				-webkit-transform:translateX(-10px);
				-moz-transform:translateX(-10px);
				transform:translateX(-10px);
				
				-webkit-transition:-webkit-transform .25s ease, opacity .15s ease .1s;
				-moz-transition:-moz-transform .25s ease, opacity .15s ease .1s;
				transition:transform .25s ease, opacity .15s ease .1s;
			}
            /* button style #6 top bar*/
			.navi-menu-active .navi-main-menu-button-six:before {
				-webkit-transform:translateY(4px);
				-moz-transform:translateY(4px);
				transform:translateY(4px);
				
				-webkit-transition:-webkit-transform .25s ease;
				-moz-transition:-moz-transform .25s ease;
				transition:transform .25s ease;
			}
			/* button style #6 bottom bar*/
			.navi-menu-active .navi-main-menu-button-six:after {
				-webkit-transform:translateY(-4px);
				-moz-transform:translateY(-4px);
				transform:translateY(-4px);
				
				-webkit-transition:-webkit-transform .25s ease;
				-moz-transition:-moz-transform .25s ease;
				transition:transform .25s ease;
			}
        <?php break; case 'stylethree': ?>
        /* X SIGN ANIMATION */
            /* button style #1 top bar*/
			.navi-menu-active .navi-main-menu-button:before {
				transform:translateY(9px) rotate(45deg);
				-moz-transform:translateY(9px) rotate(45deg);
				-webkit-transform:translateY(9px) rotate(45deg);
			}
			/* button style #1 bottom bar*/
			.navi-menu-active .navi-main-menu-button:after {
				transform:translateY(-9px) rotate(-45deg);
				-moz-transform:translateY(-9px) rotate(-45deg);
				-webkit-transform:translateY(-9px) rotate(-45deg);
			}
			/* button style #1 middle bar*/
			.navi-menu-active div.navi-main-menu-button-middle:before {
				opacity:0;
				pointer-events:none;
				
				-webkit-transform:translateX(-20px);
				-moz-transform:translateX(-20px);
				transform:translateX(-20px);
				
				-webkit-transition:all .25s ease, opacity .25s ease .025s;
				-moz-transition:all .25s ease, opacity .25s ease .025s;
				transition:all .25s ease, opacity .25s ease .025s;
			}
            /* button style #2 top bar*/
			.navi-menu-active .navi-main-menu-button-two:before {
				transform:translateY(9px) rotate(45deg);
				-moz-transform:translateY(9px) rotate(45deg);
				-webkit-transform:translateY(9px) rotate(45deg);
			}
            .navi-menu-active:hover .navi-main-menu-button-two:before { margin-left:0; width:30px; }
			/* button style #2 bottom bar*/
			.navi-menu-active .navi-main-menu-button-two:after {
                width:30px;
                margin-left:0;
				transform:translateY(-9px) rotate(-45deg);
				-moz-transform:translateY(-9px) rotate(-45deg);
				-webkit-transform:translateY(-9px) rotate(-45deg);
			}
			/* button style #2 middle bar*/
			.navi-menu-active div.navi-main-menu-button-two-middle:before {
				opacity:0;
				pointer-events:none;
				
				-webkit-transform:translateX(-20px);
				-moz-transform:translateX(-20px);
				transform:translateX(-20px);
				
				-webkit-transition:all .25s ease, opacity .25s ease .025s;
				-moz-transition:all .25s ease, opacity .25s ease .025s;
				transition:all .25s ease, opacity .25s ease .025s;
			}
            /* button style #3 top bar*/
			.navi-menu-active .navi-main-menu-button-three:before {
				transform:translateY(9px) rotate(45deg);
				-moz-transform:translateY(9px) rotate(45deg);
				-webkit-transform:translateY(9px) rotate(45deg);
			}
			/* button style #3 bottom bar*/
			.navi-menu-active .navi-main-menu-button-three:after {
				transform:translateY(-9px) rotate(-45deg);
				-moz-transform:translateY(-9px) rotate(-45deg);
				-webkit-transform:translateY(-9px) rotate(-45deg);
			}
			/* button style #3 middle bar*/
			.navi-menu-active div.navi-main-menu-button-three-middle:before {
				opacity:0;
				pointer-events:none;
				
				-webkit-transform:translateX(-20px);
				-moz-transform:translateX(-20px);
				transform:translateX(-20px);
				
				-webkit-transition:all .25s ease, opacity .25s ease .025s;
				-moz-transition:all .25s ease, opacity .25s ease .025s;
				transition:all .25s ease, opacity .25s ease .025s;
			}
            /* button style #4 top bar*/
			.navi-menu-active .navi-main-menu-button-four:before {
				transform:translateY(9px) rotate(45deg);
				-moz-transform:translateY(9px) rotate(45deg);
				-webkit-transform:translateY(9px) rotate(45deg);
			}
            .navi-menu-active:hover .navi-main-menu-button-four:before { width:25px; }
			/* button style #4 bottom bar*/
			.navi-menu-active .navi-main-menu-button-four:after {
                width:25px;
				transform:translateY(-9px) rotate(-45deg);
				-moz-transform:translateY(-9px) rotate(-45deg);
				-webkit-transform:translateY(-9px) rotate(-45deg);
			}
			/* button style #4 middle bar*/
			.navi-menu-active div.navi-main-menu-button-four-middle:before {
				opacity:0;
				pointer-events:none;
				
				-webkit-transform:translateX(-20px);
				-moz-transform:translateX(-20px);
				transform:translateX(-20px);
				
				-webkit-transition:all .25s ease, opacity .25s ease .025s;
				-moz-transition:all .25s ease, opacity .25s ease .025s;
				transition:all .25s ease, opacity .25s ease .025s;
			}
            /* button style #5 top bar*/
			.navi-menu-active .navi-main-menu-button-five:before {
				transform:translateY(11px) rotate(45deg);
				-moz-transform:translateY(11px) rotate(45deg);
				-webkit-transform:translateY(11px) rotate(45deg);
			}
			/* button style #5 bottom bar*/
			.navi-menu-active .navi-main-menu-button-five:after {
				transform:translateY(-11px) rotate(-45deg);
				-moz-transform:translateY(-11px) rotate(-45deg);
				-webkit-transform:translateY(-11px) rotate(-45deg);
			}
			/* button style #5 middle bar*/
			.navi-menu-active div.navi-main-menu-button-five-middle:before {
				opacity:0;
				pointer-events:none;
				
				-webkit-transform:translateX(-20px);
				-moz-transform:translateX(-20px);
				transform:translateX(-20px);
				
				-webkit-transition:all .25s ease, opacity .25s ease .025s;
				-moz-transition:all .25s ease, opacity .25s ease .025s;
				transition:all .25s ease, opacity .25s ease .025s;
			}
            /* button style #6 top bar*/
			.navi-menu-active .navi-main-menu-button-six:before {
				transform:translateY(4px) rotate(45deg);
				-moz-transform:translateY(4px) rotate(45deg);
				-webkit-transform:translateY(4px) rotate(45deg);
			}
			/* button style #6 bottom bar*/
			.navi-menu-active .navi-main-menu-button-six:after {
				transform:translateY(-4px) rotate(-45deg);
				-moz-transform:translateY(-4px) rotate(-45deg);
				-webkit-transform:translateY(-4px) rotate(-45deg);
			}
        <?php break; } } ?>
		
		/* hide navi between resolutions */
		@media ( min-width:<?php echo get_theme_mod('bonfire_navi_smaller_than'); ?>px) and (max-width:<?php echo get_theme_mod('bonfire_navi_larger_than'); ?>px) {
			.navi-main-menu-button-wrapper,
			.navi-main-wrapper,
			.navi-main-background,
			.navi-bg-lines-wrapper,
            .navi-logo-wrapper { display:none; }
		}
        /* hide theme menu */
		<?php if( get_theme_mod('bonfire_navi_hide_theme_menu') != '') { ?>
		@media screen and (max-width:<?php echo get_theme_mod('bonfire_navi_smaller_than'); ?>px) {
			<?php echo get_theme_mod('bonfire_navi_hide_theme_menu'); ?> { display:none !important; }
		}
		@media screen and (min-width:<?php echo get_theme_mod('bonfire_navi_larger_than'); ?>px) {
			<?php echo get_theme_mod('bonfire_navi_hide_theme_menu'); ?> { display:none !important; }
		}
		<?php } ?>
		</style>
		<!-- END CUSTOM COLORS (WP THEME CUSTOMIZER) -->
	
	<?php
	}
	add_action('wp_footer','bonfire_navi_header_customize');

?>