<?php
/**
 * IBPArcade score submitting module for MyArcadePlugin Pro
 *
 * @author Daniel Bakovic <contact@myarcadeplugin.com>
 * @copyright 2009-2015 Daniel Bakovic
 * @license http://myarcadeplugin.com
 */

// --- SCORES --- //
$act      = isset($_GET['act']) ? strtolower($_GET['act']) : false;
$autocom  = isset($_GET['autocom']) ? strtolower($_GET['autocom']) : false;
$do       = isset($_GET['do']) ? strtolower($_GET['do']) : false;

if ( ($act == 'arcade') || ($autocom == 'arcade') ) {
  global $wpdb;

  if ( defined( 'MYARCADE_DEBUG' ) && MYARCADE_DEBUG ) {
    myarcade_log_score('IBP/PHPBB Game Submitted Data: ' ."\n". 'POST: ' . print_r($_POST, true) ."\n". 'GET: ' . print_r($_GET, true) );
  }

  switch ($do) {
    case 'verifyscore' : {
      // v3 and v32 score verification
      $_SESSION['time']   = time();
      $_SESSION['rand1']  = rand(1, 100);
      $_SESSION['rand2']  = rand(1, 100);

      echo '&randchar=', $_SESSION['rand1'] ,'&randchar2=', $_SESSION['rand2'] ,'&savescore=1&blah=OK';

      if ( defined( 'MYARCADE_DEBUG' ) && MYARCADE_DEBUG ) {
        myarcade_log_score('Verify Score: ' . print_r($_SESSION, true) );
      }

      // End here for now..
      die();
    }
    break;

    case 'savescore': {
      // v3 and v32 score
      if ( defined( 'MYARCADE_DEBUG' ) && MYARCADE_DEBUG ) {
        myarcade_log_score('IBP/PHP Save Score');
      }

      $gname = $_POST['gname'];

      $game = myarcade_get_ibp_data( $gname );

      if ( ! $game || empty( $game['post_id'] ) || empty( $game['game_tag'] ) || empty( $game['score_order'] ) ) {
        // There is something wrong
        header('Location: ' . $_SERVER['HTTP_REFERER']);
        die();
      }

      // Save only when session is started
      if ( isset($_SESSION['time']) ) {
        // Check the session ( Allowed delay 10 sec for testing)
        //if ( (time() - $_SESSION['time']) <= 10 ) {
          $score = (float)(!empty($_POST['score']) ? $_POST['score'] : $_POST['gscore']);
          $secure = $score * $_SESSION['rand1'] ^ $_SESSION['rand2'];

          $current_user = wp_get_current_user();

          // Check if this is the same user
          if ( $current_user->ID && ( $current_user->ID == $_SESSION['uuid']) ) {

            if ($secure == $_POST['enscore']) {
              // Collect needed information
              $score_array = array(
                'session'   => $_SESSION['time'],
                'date'      => date('Y-m-d'),
                'datatype'  => 'number',
                'game_tag'  => $game['game_tag'],
                'user_id'   => $current_user->ID,
                'score'     => $score,
                'sortorder' => $game['score_order'],
              );

              myarcade_handle_score( $score_array );
            }
          } // end user id == session user id
        //}
      }

      $redirect = get_permalink( $game['post_id'] );
      header( 'Location: '.$redirect);
      die();
    }
    break;

    case 'newscore': {
      // -- v2 and phpBB-Amod scores -- //
      if ( defined( 'MYARCADE_DEBUG' ) && MYARCADE_DEBUG ) {
        myarcade_log_score('IBP/PHPBB New Score');
      }

      $gname = trim(!empty($_POST['game_name']) ? $_POST['game_name'] : $_POST['gname']);

      $game = myarcade_get_ibp_data( $gname );

      if ( ! $game || empty( $game['post_id'] ) || empty( $game['game_tag'] ) || empty( $game['score_order'] ) ) {
        // There is something wrong
        header('Location: ' . $_SERVER['HTTP_REFERER']);
        die();
      }

      // User has to be logged in
      $current_user = wp_get_current_user();

      // Check if this is the same user
      if ( $current_user->ID ) {
        $score = (float)(!empty($_POST['score']) ? $_POST['score'] : $_POST['gscore']);

        if ( empty($_SESSION['time']) ) {
          $session = time();
        }
        else {
          $session = $_SESSION['time'];
        }

        // Collect needed information
        $score_array = array(
          'session'   => $session,
          'date'      => date('Y-m-d'),
          'datatype'  => 'number',
          'game_tag'  => $game['game_tag'],
          'user_id'   => $current_user->ID,
          'score'     => $score,
          'sortorder' => $game['score_order'],
        );

        myarcade_handle_score( $score_array );
      } // end if user_ID

      $redirect = get_permalink( $game['post_id'] );
      header( 'Location: '.$redirect);
      die();
    }
    break;
  }
}

/**
 * Get IBPArcade game data
 */
function myarcade_get_ibp_data( $gname ) {
  global $wpdb;

  $post_id = $wpdb->get_var(
    "SELECT p.ID FROM {$wpdb->posts} AS p
      INNER JOIN {$wpdb->postmeta} AS m
       ON m.post_id = p.ID
        WHERE m.meta_key = 'mabp_game_slug'
         AND  m.meta_value = '{$gname}'"
   );

  if ( $post_id ) {
    $score_order  = get_post_meta( $post_id,'mabp_score_order', true );

    if ( ! $score_order ) {
      $score_order = 'DESC';
    }

    $game_tag     = get_post_meta( $post_id, 'mabp_game_tag', true );
  }
  else {
    $game = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix . 'myarcadegames'." WHERE slug = '$gname' LIMIT 1");

    if ( ! $game ) {
      return false;
    }

    $post_id = $game->postid;
    $score_order = $game->highscore_type;
    $game_tag = $game->game_tag;
  }

  if ( ! $score_order || 'high' == $score_order ) {
      $score_order = "DESC";
  }
  elseif ( 'low' == $score_order ) {
    $score_order = "ASC";
  }

  return compact( 'post_id', 'score_order', 'game_tag' );
}
?>