<?php
/**
 * Real Cron Trigger - Call this if you use "real" cron job on your server
 *
 * @author Daniel Bakovic <contact@myarcadeplugin.com>
 * @copyright 2009-2016 Daniel Bakovic
 * @license http://myarcadeplugin.com
 */

/*
 * Copyright @ Daniel Bakovic - kontakt@netreview.de
 * Do not modify! Do not sell! Do not distribute! -
 * Check our license Terms!
*/

$myarcade_cron_key = filter_input( INPUT_GET, 'apikey' );
$myarcade_cron_action = filter_input( INPUT_GET, 'action' );

if ( $myarcade_cron_key && $myarcade_cron_action ) {

  // Determinate the WordPress root folder
  $root = dirname( dirname( dirname( dirname( dirname(__FILE__)))));

  if ( file_exists($root . '/wp-load.php') ) {
    define('MYARCADE_DOING_ACTION', true);
    require_once($root . '/wp-load.php');
  } else {
    // WordPress not found
    die();
  }

  if ( function_exists('myarcade_get_apikey') ) {
    // Verify API key
    if ( myarcade_get_apikey() == sanitize_key( $myarcade_cron_key ) )  {
      // What should we do?
      switch ( $myarcade_cron_action ) {
        case 'publish': {
          myarcade_cron_publishing();
        } break;

        case 'fetch': {
          myarcade_cron_fetching();
        } break;

        default:
          // Do nothing
        break;
      }
    }
  }
}
?>