<?php
/**
 * Scirra
 *
 * @author Daniel Bakovic <contact@myarcadeplugin.com>
 * @copyright 2009-2015 Daniel Bakovic
 * @license http://myarcadeplugin.com
 */

/**
 * Copyright @ Daniel Bakovic - contact@myarcadeplugin.com
 * Do not modify! Do not sell! Do not distribute! -
 * Check our license Terms!
 */

// No direct Access
if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

/**
 * Display distributor settings on admin page
 *
 * @version 5.15.0
 * @access  public
 * @return  void
 */
function myarcade_settings_scirra() {
  $scirra = myarcade_get_settings( 'scirra' );
  ?>
  <h2 class="trigger"><?php _e("Scirra", 'myarcadeplugin'); ?></h2>
  <div class="toggle_container">
    <div class="block">
      <table class="optiontable" width="100%" cellpadding="5" cellspacing="5">
        <tr>
          <td colspan="2">
            <i>
              <?php printf( __( "%s distributes Flash and HTML5 games.", 'myarcadeplugin' ), '<a href="https://www.scirra.com/arcade" target="_blank">Scirra</a>' ); ?>
            </i>
            <br /><br />
          </td>
        </tr>

        <tr><td colspan="2"><h3><?php _e("Feed URL", 'myarcadeplugin'); ?></h3></td></tr>
        <tr>
          <td>
            <input type="text" size="40"  name="scirra_url" value="<?php echo $scirra['feed']; ?>" />
          </td>
          <td><i><?php _e("Edit this field only if Feed URL has been changed!", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h3><?php _e("Category", 'myarcadeplugin'); ?></h3></td></tr>

        <tr>
          <td>
            <select size="1" name="scirra_category" id="scirra_category">
              <option value="0" <?php myarcade_selected($scirra['category'], '0'); ?> ><?php _e("All Games", 'myarcadeplugin'); ?></option>
              <option value="3" <?php myarcade_selected($scirra['category'], '3'); ?> ><?php _e("Action", 'myarcadeplugin'); ?></option>
              <option value="2" <?php myarcade_selected($scirra['category'], '2'); ?> ><?php _e("Adventure", 'myarcadeplugin'); ?></option>
              <option value="9" <?php myarcade_selected($scirra['category'], '9'); ?> ><?php _e("Fighting", 'myarcadeplugin'); ?></option>
              <option value="10" <?php myarcade_selected($scirra['category'], '10'); ?> ><?php _e("Multiplayer", 'myarcadeplugin'); ?></option>
              <option value="4" <?php myarcade_selected($scirra['category'], '4'); ?> ><?php _e("Music", 'myarcadeplugin'); ?></option>
              <option value="1" <?php myarcade_selected($scirra['category'], '1'); ?> ><?php _e("Puzzle", 'myarcadeplugin'); ?></option>
              <option value="7" <?php myarcade_selected($scirra['category'], '7'); ?> ><?php _e("Racing", 'myarcadeplugin'); ?></option>
              <option value="11" <?php myarcade_selected($scirra['category'], '11'); ?> ><?php _e("RPG", 'myarcadeplugin'); ?></option>
              <option value="8" <?php myarcade_selected($scirra['category'], '8'); ?> ><?php _e("Shooting", 'myarcadeplugin'); ?></option>
              <option value="6" <?php myarcade_selected($scirra['category'], '6'); ?> ><?php _e("Sports", 'myarcadeplugin'); ?></option>
              <option value="5" <?php myarcade_selected($scirra['category'], '5'); ?> ><?php _e("Strategy", 'myarcadeplugin'); ?></option>
              <option value="13" <?php myarcade_selected($scirra['category'], '13'); ?> ><?php _e("Tutorial", 'myarcadeplugin'); ?></option>
              <option value="12" <?php myarcade_selected($scirra['category'], '12'); ?> ><?php _e("Other", 'myarcadeplugin'); ?></option>
            </select>
          </td>
          <td><i><?php _e("Select which games you would like to fetch.", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h3><?php _e("Automated Game Fetching", 'myarcadeplugin'); ?></h3></td></tr>

        <tr>
          <td>
            <input type="checkbox" name="scirra_cron_fetch" value="true" <?php myarcade_checked($scirra['cron_fetch'], true); ?> /><label class="opt">&nbsp;<?php _e("Yes", 'myarcadeplugin'); ?></label>
          </td>
          <td><i><?php _e("Enable this if you want to fetch games automatically. Go to 'General Settings' to select a cron interval.", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h4><?php _e("Fetch Games", 'myarcadeplugin'); ?></h4></td></tr>

        <tr>
          <td>
            <input type="text" size="40"  name="scirra_cron_fetch_limit" value="<?php echo $scirra['cron_fetch_limit']; ?>" />
          </td>
          <td><i><?php _e("How many games should be fetched on every cron trigger?", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h3><?php _e("Automated Game Publishing", 'myarcadeplugin'); ?></h3></td></tr>

        <tr>
          <td>
            <input type="checkbox" name="scirra_cron_publish" value="true" <?php myarcade_checked($scirra['cron_publish'], true); ?> /><label class="opt">&nbsp;<?php _e("Yes", 'myarcadeplugin'); ?></label>
          </td>
          <td><i><?php _e("Enable this if you want to publish games automatically. Go to 'General Settings' to select a cron interval.", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h4><?php _e("Publish Games", 'myarcadeplugin'); ?></h4></td></tr>

        <tr>
          <td>
            <input type="text" size="40"  name="scirra_cron_publish_limit" value="<?php echo $scirra['cron_publish_limit']; ?>" />
          </td>
          <td><i><?php _e("How many games should be published on every cron trigger?", 'myarcadeplugin'); ?></i></td>
        </tr>

      </table>
      <input class="button button-primary" id="submit" type="submit" name="submit" value="<?php _e("Save Settings", 'myarcadeplugin'); ?>" />
    </div>
  </div>
  <?php
}

/**
 * Retrieve distributor's default settings
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  array Default settings
 */
function myarcade_default_settings_scirra() {
  return array(
    'feed'          =>  'https://www.scirra.com/arcade/api/games.json',
    'category'      => 0,
    'cron_fetch'    => false,
    'cron_fetch_limit' => '1',
    'cron_publish'  => false,
    'cron_publish_limit' => '1',
  );
}

/**
 * Handle distributor settings update
 *
 * @version 5.19.0
 * @access  public
 * @return  void
 */
function myarcade_save_settings_scirra() {

  myarcade_check_settings_nonce();

    // Scirra Settings
  $scirra = array();
  if ( isset($_POST['scirra_url'])) $scirra['feed'] = esc_url_raw($_POST['scirra_url']); else $scirra['feed'] = '';

  $scirra['category']            = filter_input( INPUT_POST, 'scirra_category', FILTER_VALIDATE_INT, array( "options" => array( "default" => 0) ) );
  $scirra['cron_fetch']          = (isset($_POST['scirra_cron_fetch'])) ? true : false;
  $scirra['cron_fetch_limit']    = (isset($_POST['scirra_cron_fetch_limit']) ) ? intval($_POST['scirra_cron_fetch_limit']) : 1;
  $scirra['cron_publish']        = (isset($_POST['scirra_cron_publish']) ) ? true : false;
  $scirra['cron_publish_limit']  = (isset($_POST['scirra_cron_publish_limit']) ) ? intval($_POST['scirra_cron_publish_limit']) : 1;
    // Update Settings
    update_option('myarcade_scirra', $scirra);
}

/**
 * Display distributor fetch games options
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  void
 */
function myarcade_fetch_settings_scirra() {

  $scirra = myarcade_get_fetch_options_scirra();
  ?>

  <div class="myarcade_border white hide mabp_680" id="scirra">
    <div style="float:left;width:150px;">
      <input type="radio" name="fetchmethodscirra" value="latest" <?php myarcade_checked($scirra['method'], 'latest');?>>
    <label><?php _e("Latest Games", 'myarcadeplugin'); ?></label>
    <br />
    <input type="radio" name="fetchmethodscirra" value="offset" <?php myarcade_checked($scirra['method'], 'offset');?>>
    <label><?php _e("Use Offset", 'myarcadeplugin'); ?></label>
    </div>
    <div class="myarcade_border" style="float:left;padding-top: 5px;background-color: #F9F9F9">
    Fetch <input type="number" min="1" max="100" name="limitscirra" value="<?php echo $scirra['limit']; ?>" /> games <span id="offsscirra" class="hide">from offset <input id="radiooffsscirra" type="number" name="offsetscirra" value="<?php echo $scirra['offset']; ?>" /> </span>
    </div>
    <div class="clear"></div>
    <div style="float:left;width:150px">
      <?php _e("Game Order", 'myarcadeplugin'); ?>
    </div>
    <select name="orderbyscirra" id="orderbyscirra">
      <option value="PublishDateASC" <?php myarcade_selected($scirra['orderby'], "PublishDateASC"); ?>><?php _e("Oldest games first", 'myarcadeplugin'); ?></option>
      <option value="PublishDateDESC" <?php myarcade_selected($scirra['orderby'], "PublishDateDESC"); ?>><?php _e("Newest games first", 'myarcadeplugin'); ?></option>
      <option value="NameASC" <?php myarcade_selected($scirra['orderby'], "NameASC"); ?>><?php _e("Alphabetically", 'myarcadeplugin'); ?></option>
      <option value="NameDESC" <?php myarcade_selected($scirra['orderby'], "NameDESC"); ?>><?php _e("Reverse alphabetical", 'myarcadeplugin'); ?></option>
      <option value="UniquePlayersASC" <?php myarcade_selected($scirra['orderby'], "UniquePlayersASC"); ?>><?php _e("Fewest unique players", 'myarcadeplugin'); ?></option>
      <option value="UniquePlayersDESC" <?php myarcade_selected($scirra['orderby'], "UniquePlayersDESC"); ?>><?php _e("Most unique players", 'myarcadeplugin'); ?></option>
      <option value="BestRatedGames" <?php myarcade_selected($scirra['orderby'], "BestRatedGames"); ?>><?php _e("Highest rated games first", 'myarcadeplugin'); ?></option>
      <option value="HotnessDESC" <?php myarcade_selected($scirra['orderby'], "HotnessDESC"); ?>><?php _e("Hottest games first", 'myarcadeplugin'); ?></option>
    </select>
    <p class="clear"></p>

    <div style="float:left;width:150px">
    <label for="mobilescirra"><?php _e("Only Mobile Games", 'myarcadeplugin'); ?></label>
    </div>
    <input type="checkbox" name="mobilescirra" id="mobilescirra" value="true" <?php myarcade_checked( $scirra['mobile'], true) ?> /> <?php _e("Yes", 'myarcadeplugin'); ?>
    <div class="clear"></div>
  </div>
  <?php
}

/**
 * Generate an options array with submitted fetching parameters
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  array Fetching options
 */
function myarcade_get_fetch_options_scirra() {

  // Get distributor settings
  $settings = myarcade_get_settings( 'scirra' );

  $settings['method'] = 'latest';
  $settings['offset'] = 0;
  $settings['limit']  = 100;
  $settings['orderby'] = 'PublishDateDESC';
  $settings['mobile'] = false;

  if ( 'start' == filter_input( INPUT_POST, 'fetch' ) ) {
    $settings['method']  = filter_input( INPUT_POST, 'fetchmethodscirra' );
    $settings['offset']  = filter_input( INPUT_POST, 'offsetscirra' );
    $settings['limit']   = filter_input( INPUT_POST, 'limitscirra' );
    $settings['orderby'] = filter_input( INPUT_POST, 'orderbyscirra' );
    $settings['mobile'] =  filter_input( INPUT_POST, 'mobilescirra', FILTER_VALIDATE_BOOLEAN );
  }

  return $settings;
}

/**
 * Retrieve available distributor's categories mapped to MyArcadePlugin categories
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  array Distributor categories
 */
function myarcade_get_categories_scirra() {
  return array(
    "Action"      => "3",
    "Adventure"   => "2",
    "Arcade"      => false,
    "Board Game"  => false,
    "Casino"      => false,
    "Defense"     => false,
    "Customize"   => false,
    "Dress-Up"    => false,
    "Driving"     => "7",
    "Education"   => "13",
    "Fighting"    => "9",
    "Jigsaw"      => false,
    "Multiplayer" => "10",
    "Other"       => "12",
    "Puzzles"     => "1",
    "Rhythm"      => "4",
    "Shooting"    => "8",
    "Sports"      => "6",
    "Strategy"    => "5,11",
  );
}

/**
 * Fetch Scirra games
 *
 * @version 5.26.0
 * @access  public
 * @param   array  $args Fetching parameters
 * @return  void
 */
function myarcade_feed_scirra( $args = array() ) {
  global $wpdb;

   $defaults = array(
    'echo'     => false,
    'settings' => array()
  );

  $args = wp_parse_args( $args, $defaults );
  extract($args);

  $new_games = 0;
  $add_game = false;

  $scirra  = myarcade_get_fetch_options_scirra();
  $scirra_categories = myarcade_get_categories_scirra();
  $feedcategories = get_option('myarcade_categories');

  // Init settings var's
  if ( !empty($settings) ) {
    $settings = array_merge($scirra, $settings);
  }
  else {
    $settings = $scirra;
  }

  // Generate Fedd URL
  if ( $settings['limit'] > 0 ) {
    $settings['feed'] = add_query_arg( array("take" => intval( $settings['limit'] ) ), $settings['feed'] );
  }

  if ( $settings['method'] == 'offset' && isset( $settings['offset'] ) ) {
    $settings['feed'] = add_query_arg( array( 'skip' => intval( $settings['offset'] ) ), $settings['feed'] );
  }

  // We don't want incomplete games
  $settings['feed'] = add_query_arg( array( 'wip' => 0 ), $settings['feed'] );
  $settings['feed'] = add_query_arg( array( 'category' => intval( $settings['category'] ) ), $settings['feed'] );
  $settings['feed'] = add_query_arg( array( 'orderby' => $settings['orderby'] ), $settings['feed'] );

  // Include required fetch functions
  require_once( MYARCADE_CORE_DIR . '/fetch.php' );

  $games = myarcade_fetch_games( array('url' => $settings['feed'], 'service' => 'json', 'echo' => true) );

  if ( !empty( $games ) ) {
    foreach ( $games->games as $game_obj ) {

      // Should we fetch only mobile games?
      if ( filter_var( $settings['mobile'], FILTER_VALIDATE_BOOLEAN ) && ! filter_var( $game_obj->mobileEnabled, FILTER_VALIDATE_BOOLEAN ) ) {
        // This is not a mobile game... skip it.
        continue;
      }

      $game = new stdClass();
      $game->uuid = crc32( $game_obj->id ) . '_scirra';
      $game->game_tag = md5($game_obj->id . $game_obj->name.'scirra');

      $add_game = false;

      // Category-Check
      foreach ($feedcategories as $feedcat) {
        if ( $feedcat['Status'] != 'checked' ) {
          continue;
        }

        if ( empty( $scirra_categories[ $feedcat['Name'] ] ) ) {
          continue;
        }

        $category_ids = explode( ',',  $scirra_categories[ $feedcat['Name'] ] );

        if ( ! $category_ids || ! in_array( $game_obj->categoryID, $category_ids )  ) {
          // There is something wrong
          continue;
        }

        $game->categs = $feedcat['Name'];
        $add_game = true;
        break;
      }

      // Should we add this game?
      if ($add_game == false) {
        continue;
      }

      // Add game...
      $game->type           = 'scirra';
      $game->name           = esc_sql( $game_obj->name );
      $game->slug           = myarcade_make_slug($game->name);
      $game->description    = esc_sql( strip_tags($game_obj->longDescription) );
      $game->instructions   = esc_sql( strip_tags($game_obj->instructions) );
      $game->swf_url        = esc_sql($game_obj->iframeURL);
      $game->thumbnail_url  = esc_sql($game_obj->gameImageURL);

      // Embed code widht doesn't match with the given width.
      // Try to get it from the embed code
      $game->width          = $game_obj->width;
      $game->height         = $game_obj->height;

      if ( preg_match( "!width:\d+!" , $game_obj->iframeCode , $matches) ) {
        $width = intval( str_replace( "width:", "", $matches[0] ) );
        if ( $width > $game->width ) {
          $game->width = $width;
        }
      }

      if ( preg_match( "!height:\d+!" , $game_obj->iframeCode , $matches) ) {
        $height = intval( str_replace( "height:", "", $matches[0] ) );
        if ( $height > $game->height ) {
          $game->height = $height;
        }
      }

      // Add game to the database
      if ( myarcade_add_fetched_game( $game, $args ) ) {
        $new_games++;
      }
    }
  }

  // Show, how many games have been fetched
  myarcade_fetched_message( $new_games, $echo );
}

/**
 * Return game embed method
 *
 * @version 5.18.0
 * @since   5.18.0
 * @access  public
 * @return  string Embed Method
 */
function myarcade_embedtype_scirra() {
  return 'iframe';
}

/**
 * Return if games can be downloaded by this distirbutor
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  bool True if games can be downloaded
 */
function myarcade_can_download_scirra() {
  return false;
}
?>