<?php
/**
 * Plinga
 *
 * @author Daniel Bakovic <contact@myarcadeplugin.com>
 * @copyright 2009-2015 Daniel Bakovic
 * @license http://myarcadeplugin.com
 */

/**
 * Copyright @ Daniel Bakovic - contact@myarcadeplugin.com
 * Do not modify! Do not sell! Do not distribute!
 * Check our license Terms!
 */

/**
 * Save options function
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  void
 */
function myarcade_save_settings_plinga() {

  myarcade_check_settings_nonce();

  $settings = array();
  $settings['feed'] = esc_sql( filter_input( INPUT_POST, 'plinga_url' ) );
  $settings['platform_id'] = esc_sql( filter_input( INPUT_POST, 'plinga_platform_id' ) );
  $settings['cron_publish'] = filter_input( INPUT_POST, 'plinga_cron_publish', FILTER_VALIDATE_BOOLEAN );
  $settings['cron_publish_limit'] = filter_input( INPUT_POST, 'plinga_cron_publish_limit', FILTER_VALIDATE_INT, array( "options" => array( "default" => 1) ) );

  // Update settings
  update_option( 'myarcade_plinga', $settings );
}

/**
 * Display distributor settings on admin page
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  void
 */
function myarcade_settings_plinga() {
  $plinga = myarcade_get_settings( 'plinga' );
  ?>
  <h2 class="trigger"><?php _e("Plinga", 'myarcadeplugin'); ?></h2>
  <div class="toggle_container">
    <div class="block">
      <table class="optiontable" width="100%" cellpadding="5" cellspacing="5">
        <tr>
          <td colspan="2">
            <i>
              <?php printf( __( "%s distributes HTML5 games.", 'myarcadeplugin' ), '<a href="http://plinga.com" target="_blank">Plinga</a>' ); ?>
            </i>
            <br /><br />
          </td>
        </tr>
        <tr><td colspan="2"><h3><?php _e("Feed URL", 'myarcadeplugin'); ?></h3></td></tr>
        <tr>
          <td>
            <input type="text" size="40"  name="plinga_url" value="<?php echo $plinga['feed']; ?>" />
          </td>
          <td><i><?php _e("Edit this field only if Feed URL has been changed!", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h3><?php _e("Platform ID", 'myarcadeplugin'); ?></h3></td></tr>
        <tr>
          <td>
            <input type="text" size="40"  name="plinga_platform_id" value="<?php echo $plinga['platform_id']; ?>" />
          </td>
          <td><i><?php _e("Enter your Platform ID if available.", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h3><?php _e("Automated Game Publishing", 'myarcadeplugin'); ?></h3></td></tr>

        <tr>
          <td>
            <input type="checkbox" name="plinga_cron_publish" value="true" <?php myarcade_checked($plinga['cron_publish'], true); ?> /><label class="opt">&nbsp;<?php _e("Yes", 'myarcadeplugin'); ?></label>
          </td>
          <td><i><?php _e("Enable this if you want to publish games automatically. Go to 'General Settings' to select a cron interval.", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h4><?php _e("Publish Games", 'myarcadeplugin'); ?></h4></td></tr>

        <tr>
          <td>
            <input type="text" size="40"  name="plinga_cron_publish_limit" value="<?php echo $plinga['cron_publish_limit']; ?>" />
          </td>
          <td><i><?php _e("How many games should be published on every cron trigger?", 'myarcadeplugin'); ?></i></td>
        </tr>

      </table>
      <input class="button button-primary" id="submit" type="submit" name="submit" value="<?php _e("Save Settings", 'myarcadeplugin'); ?>" />
    </div>
  </div>
  <?php
}

/**
 * Load default distributor settings
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  array Default settings
 */
function myarcade_default_settings_plinga() {
  return array(
    'feed'          => 'http://plopx.s3.amazonaws.com/MyArcadePlugin/PlingaAll.xml',
    'platform_id'  => '',
    'cron_publish'  => false,
    'cron_publish_limit' => '1',
  );
}

/**
 * Fetch games
 *
 * @version 5.27.1
 * @since   5.19.0
 * @access  public
 * @param   array  $args Fetching parameters
 * @return  void
 */
function myarcade_feed_plinga( $args = array() ) {
  global $wpdb;

  $defaults = array(
    'echo'     => false,
    'settings' => array(),
  );

  $args = wp_parse_args( $args, $defaults );
  extract($args);

  $new_games = 0;
  $add_game = false;

  $plinga = myarcade_get_settings( 'plinga' );
  $feedcategories = get_option( 'myarcade_categories' );

  // Init settings var's
  if ( ! empty($settings) ) {
    $settings = array_merge( $plinga, $settings );
  }
  else {
    $settings = $plinga;
  }

  if ( empty( $settings['platform_id'] ) ) {
    // Use our default affiliate credentials
    $settings['platform_id'] = '1371';
  }

  // Include required fetch functions
  require_once( MYARCADE_CORE_DIR . '/fetch.php' );

  // Fetch games
  $xml_games = myarcade_fetch_games( array( 'url' => $settings['feed'], 'service' => 'xml', 'echo' => $echo ) );

  //====================================
  if ( !empty( $xml_games->gameset->game ) ) {
    foreach ( $xml_games->gameset->game as $game_obj ) {

      $game = new stdClass();
      $game->uuid     = $game_obj->id . '_plinga';
      // Generate a game tag for this game
      $game->game_tag = md5( $game_obj->id . 'plinga' );

      $add_game   = false;

      // Transform some categories
      $categories_string = 'Other';

      // Transform some feed categories
      switch ( $game_obj->category ) {

        case 'Match-3': {
          $game_obj->category = 'Board Game';
        } break;

        case 'Farming': {
          $game_obj->category = "Strategy";
        } break;
      }

      foreach ( $feedcategories as $feedcat ) {
        if ( ( $feedcat['Name'] == $game_obj->category ) && ( $feedcat['Status'] == 'checked' ) ) {
          $add_game = true;
          $categories_string = (string) $game_obj->category;
          break;
        }
      }

      if ( ! $add_game ) {
        continue;
      }

      // Extract game URL from iframe code
      if ( ! isset( $game_obj->gamecode->iframe['src'] ) ) {
        continue;
      }

      $game_url = trailingslashit( $game_obj->gamecode->iframe['src'] );

      if ( $settings['platform_id'] ) {
        $game_url = str_replace( '1371', $settings['platform_id'], $game_url );
      }

      $game->type          = 'plinga';
      $game->name          = esc_sql( trim( $game_obj->name ) );
      $game->slug          = myarcade_make_slug( trim( $game_obj->name ) );
      $game->description   = esc_sql( trim( (string) $game_obj->description ) );
      $game->instructions  = esc_sql( trim( (string) $game_obj->instructions ) );
      $game->categs        = $categories_string;
      $game->thumbnail_url  = esc_sql( trim( $game_obj->thumbnail ) );
      $game->swf_url       = esc_sql( myarcade_maybe_ssl( $game_url ) );
      $game->width         = esc_sql( trim( $game_obj->width ) );
      $game->height        = esc_sql( trim( $game_obj->height ) );
      $game->screen1_url   = !empty($game_obj->screenshot_1) ? trim( myarcade_maybe_ssl( $game_obj->screenshot_1 ) ) : '';
      $game->screen2_url   = !empty($game_obj->screenshot_2) ? trim( myarcade_maybe_ssl( $game_obj->screenshot_2 ) ) : '';
      $game->screen3_url   = !empty($game_obj->screenshot_3) ? trim( myarcade_maybe_ssl( $game_obj->screenshot_3 ) ) : '';
      $game->screen4_url   = !empty($game_obj->screenshot_4) ? trim( myarcade_maybe_ssl( $game_obj->screenshot_4 ) ): '';

      // Add game to the database
      if ( myarcade_add_fetched_game( $game, $args ) ) {
        $new_games++;
      }
    }
  }

  // Show, how many games have been fetched
  myarcade_fetched_message( $new_games, $echo );
}

/**
 * Return game embed method
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  string Embed Method
 */
function myarcade_embedtype_plinga() {
  return 'iframe';
}

/**
 * Return if games can be downloaded by this distirbutor
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  bool True if games can be downloaded
 */
function myarcade_can_download_plinga() {
  return false;
}
?>