<?php
/**
 * Kongregate
 *
 * @author Daniel Bakovic <contact@myarcadeplugin.com>
 * @copyright 2009-2015 Daniel Bakovic
 * @license http://myarcadeplugin.com
 */

/**
 * Copyright @ Daniel Bakovic - contact@myarcadeplugin.com
 * Do not modify! Do not sell! Do not distribute! -
 * Check our license Terms!
 */

// No direct Access
if ( ! defined( 'ABSPATH' ) ) {
  exit;
}
/**
 * Display distributor settings on admin page
 *
 * @version 5.15.0
 * @access  public
 * @return  void
 */
function myarcade_settings_kongregate() {
  $kongregate = myarcade_get_settings( 'kongregate' );
  ?>
  <h2 class="trigger"><?php _e("Kongregate", 'myarcadeplugin'); ?></h2>
  <div class="toggle_container">
    <div class="block">
      <table class="optiontable" width="100%" cellpadding="5" cellspacing="5">
        <tr>
          <td colspan="2">
            <i>
              <?php printf( __( "%s distributes Flash games.", 'myarcadeplugin' ), '<a href="http://www.kongregate.com/games_for_your_site" target="_blank">Kongegrate</a>' ); ?>
            </i>
            <br /><br />
          </td>
        </tr>
        <tr><td colspan="2"><h3><?php _e("Feed URL", 'myarcadeplugin'); ?></h3></td></tr>

        <tr>
          <td>
            <input type="text" size="40"  name="kongurl" value="<?php echo $kongregate['feed']; ?>" />
          </td>
          <td><i><?php _e("Edit this field only if Feed URL has been changed!", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h3><?php _e("Automated Game Publishing", 'myarcadeplugin'); ?></h3></td></tr>

        <tr>
          <td>
            <input type="checkbox" name="kong_cron_publish" value="true" <?php myarcade_checked($kongregate['cron_publish'], true); ?> /><label class="opt">&nbsp;<?php _e("Yes", 'myarcadeplugin'); ?></label>
          </td>
          <td><i><?php _e("Enable this if you want to publish games automatically. Go to 'General Settings' to select a cron interval.", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h4><?php _e("Publish Games", 'myarcadeplugin'); ?></h4></td></tr>

        <tr>
          <td>
            <input type="text" size="40"  name="kong_cron_publish_limit" value="<?php echo $kongregate['cron_publish_limit']; ?>" />
          </td>
          <td><i><?php _e("How many games should be published on every cron trigger?", 'myarcadeplugin'); ?></i></td>
        </tr>

      </table>
      <input class="button button-primary" id="submit" type="submit" name="submit" value="<?php _e("Save Settings", 'myarcadeplugin'); ?>" />
    </div>
  </div>
  <?php
}

/**
 * Retrieve distributor's default settings
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  array Default settings
 */
function myarcade_default_settings_kongregate() {
  return array(
    'feed'          => 'http://www.kongregate.com/games_for_your_site.xml',
    'cron_publish'  => false,
    'cron_publish_limit' => '1',
  );
}

/**
 * Handle distributor settings update
 *
 * @version 5.19.0
 * @access  public
 * @return  void
 */
function myarcade_save_settings_kongregate() {

  myarcade_check_settings_nonce();

  // Kongeregate Settings
  $kongregate = array();

  $kongregate['feed'] = esc_url_raw( filter_input( INPUT_POST, 'kongurl' ) );
  $kongregate['cron_publish'] = (isset($_POST['kong_cron_publish']) ) ? true : false;
  $kongregate['cron_publish_limit']  = (isset($_POST['kong_cron_publish_limit']) ) ? intval($_POST['kong_cron_publish_limit']) : 1;

  // Update Settings
  update_option('myarcade_kongregate', $kongregate);
}

/**
 * Retrieve available distributor's categories mapped to MyArcadePlugin categories
 *
 * @version 5.19.0
 * @since   5.19.0
 * @access  public
 * @return  array Distributor categories
 */
function myarcade_get_categories_kongregate() {
  return array(
    "Action"      => true,
    "Adventure"   => true,
    "Arcade"      => false,
    "Board Game"  => false,
    "Casino"      => false,
    "Defense"     => false,
    "Customize"   => false,
    "Dress-Up"    => false,
    "Driving"     => false,
    "Education"   => false,
    "Fighting"    => false,
    "Jigsaw"      => false,
    "Multiplayer" => true,
    "Other"       => false,
    "Puzzles"     => true,
    "Rhythm"      => true,
    "Shooting"    => true,
    "Sports"      => true,
    "Strategy"    => true,
  );
}

/**
 * Fetch Kongregate games
 *
 * @version 5.26.0
 * @access  public
 * @param   array  $args Fetching parameters
 * @return  void
 */
function myarcade_feed_kongregate( $args = array() ) {
  global $wpdb;

  $defaults = array(
    'echo'     => false,
    'settings' => array()
  );

  $args = wp_parse_args( $args, $defaults );
  extract($args);

  $new_games = 0;
  $add_game = false;

  $kongregate  = myarcade_get_settings( 'kongregate' );
  $kongregate_categories = myarcade_get_categories_kongregate();
  $feedcategories = get_option('myarcade_categories');

  // Include required fetch functions
  require_once( MYARCADE_CORE_DIR . '/fetch.php' );

  $games = myarcade_fetch_games( array('url' => $kongregate['feed'], 'service' => 'xml', 'echo' => true) );

  if ( ! empty( $games ) ) {
    foreach ( $games as $game_obj ) {

      $game = new stdClass();

      $game->uuid     = (string) $game_obj->id;
      // Generate a game tag for this game
      $game->game_tag = md5($game_obj->id.$game_obj->title.'kongregate');

      $add_game   = false;

      // Map Kongregate category names to our own names
      switch ($game_obj->category) {
        case 'Adventure & RPG': $game_obj->category = 'Adventure'; break;
        case 'Music & More':    $game_obj->category = 'Rhythm'; break;
        case 'Puzzle':          $game_obj->category = 'Puzzles'; break;
        case 'Shooter':         $game_obj->category = 'Shooting'; break;
        case 'Sports & Racing': $game_obj->category = 'Sports'; break;
        case 'Strategy & Defense': $game_obj->category = 'Strategy'; break;
      }

      // Category-Check
      foreach ( $feedcategories as $feedcat ) {
        if ( $feedcat['Status'] == 'checked' ) {
          if ( isset($kongregate_categories[ $feedcat['Name'] ]) && $kongregate_categories[ $feedcat['Name'] ] === true ) {
            $add_game = true;
            break;
          }
        }
      }

      // Should we add this game?
      if ($add_game == false) { continue; }

      // Add game...
      $game->type           = 'kongregate';
      $game->slug           = myarcade_make_slug($game_obj->title);
      $game->name           = esc_sql($game_obj->title);
      $game->description    = esc_sql( strip_tags($game_obj->description) );
      $game->instructions   = esc_sql( strip_tags($game_obj->instructions) );
      $game->rating         = esc_sql($game_obj->rating);
      $game->categs         = esc_sql($game_obj->category);
      // remove ? from  the thumbnail url
      $thumb_array = explode('?', $game_obj->thumbnail);
      $game->thumbnail_url = esc_sql( $thumb_array[0] );

      $game->swf_url        = esc_sql($game_obj->flash_file);

      // Add game to the database
      if ( myarcade_add_fetched_game( $game, $args ) ) {
        $new_games++;
      }
    }
  }

  // Show, how many games have been fetched
  myarcade_fetched_message( $new_games, $echo );
}

/**
 * Return game embed method
 *
 * @version 5.18.0
 * @since   5.18.0
 * @access  public
 * @return  string Embed Method
 */
function myarcade_embedtype_kongregate() {
  return 'flash';
}
?>