<?php
/**
 * GameFeed by Talkarcades
 *
 * @author Daniel Bakovic <contact@myarcadeplugin.com>
 * @copyright 2009-2015 Daniel Bakovic
 * @license http://myarcadeplugin.com
 */

/**
 * Copyright @ Daniel Bakovic - contact@myarcadeplugin.com
 * Do not modify! Do not sell! Do not distribute! -
 * Check our license Terms!
 */

// No direct Access
if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

/**
 * Display distributor settings on admin page
 *
 * @version 5.26.0
 * @access  public
 * @return  void
 */
function myarcade_settings_gamefeed() {
  $gamefeed = myarcade_get_settings( 'gamefeed' );
  $defaults = myarcade_default_settings_gamefeed();
  $gamefeed = wp_parse_args( $gamefeed, $defaults );
  ?>
  <h2 class="trigger"><?php _e("GameFeed by TalkArcades", 'myarcadeplugin'); ?></h2>
  <div class="toggle_container">
    <div class="block">
      <table class="optiontable" width="100%" cellpadding="5" cellspacing="5">
        <tr>
          <td colspan="2">
            <i>
              <?php printf( __( "%s distributes Flash games.", 'myarcadeplugin' ), '<a href="http://www.talkarcades.com" target="_blank">TalkArcades</a>' ); ?>
              <?php _e( "You need a free account on TalkArcades to be able to use the GameFeed AutoPublisher. Create a new account.", 'myarcadeplugin'); ?>
            </i>
            <br /><br />
          </td>
        </tr>

        <tr><td colspan="2"><h3><?php _e("GameFeed File Name", 'myarcadeplugin'); ?></h3></td></tr>
        <tr>
          <td>
            <input type="text" size="40"  name="gamefeed_feedname" value="<?php echo $gamefeed['feedname']; ?>" />
          </td>
          <td><i><?php _e("Paste the file name of your GameFeed Autopublisher.", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h3><?php _e("Game Status", 'myarcadeplugin'); ?></h3></td></tr>

        <tr>
          <td>
            <select size="1" name="gamefeed_status" id="gamefeed_status">
              <option value="publish" <?php myarcade_selected($gamefeed['status'], 'publish'); ?> ><?php _e("Publish", 'myarcadeplugin'); ?></option>
              <option value="draft" <?php myarcade_selected($gamefeed['status'], 'draft'); ?> ><?php _e("Draft", 'myarcadeplugin'); ?></option>
              <option value="add" <?php myarcade_selected($gamefeed['status'], 'add'); ?> ><?php _e("Add To Database (don't publish)", 'myarcadeplugin'); ?></option>
            </select>
          </td>
          <td><i><?php _e("Select a status for games added through AutoPublish from TalkArcades website.", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h3><?php _e("Automated Game Publishing", 'myarcadeplugin'); ?></h3></td></tr>

        <tr>
          <td>
            <input type="checkbox" name="gamefeed_cron_publish" value="true" <?php myarcade_checked($gamefeed['cron_publish'], true); ?> /><label class="opt">&nbsp;<?php _e("Yes", 'myarcadeplugin'); ?></label>
          </td>
          <td><i><?php _e("Enable this if you want to publish games automatically. Go to 'General Settings' to select a cron interval. This will only work if you have unpublished TalkArcades Games in your database.", 'myarcadeplugin'); ?></i></td>
        </tr>

        <tr><td colspan="2"><h4><?php _e("Publish Games", 'myarcadeplugin'); ?></h4></td></tr>

        <tr>
          <td>
            <input type="text" size="40"  name="gamefeed_cron_publish_limit" value="<?php echo $gamefeed['cron_publish_limit']; ?>" />
          </td>
          <td><i><?php _e("How many games should be published on every cron trigger?", 'myarcadeplugin'); ?></i></td>
        </tr>

      </table>
      <input class="button button-primary" id="submit" type="submit" name="submit" value="<?php _e("Save Settings", 'myarcadeplugin'); ?>" />
    </div>
  </div>
  <?php
}

/**
 * Retrieve distributor's default settings
 *
 * @version 5.26.0
 * @since   5.19.0
 * @access  public
 * @return  array Default settings
 */
function myarcade_default_settings_gamefeed() {
  return array(
    'feedname'      => '',
    'status'        => 'publish',
    'cron_publish'  => false,
    'cron_publish_limit' => '1',
  );
}

/**
 * Handle distributor settings update
 *
 * @version 5.26.0
 * @access  public
 * @return  void
 */
function myarcade_save_settings_gamefeed() {

  myarcade_check_settings_nonce();

  // GameFeed Settings
  $gamefeed = array();
  $gamefeed['feedname'] = esc_sql( filter_input( INPUT_POST, 'gamefeed_feedname' ) );
  $gamefeed['status'] = esc_sql( filter_input( INPUT_POST, 'gamefeed_status' ) );
  $gamefeed['cron_publish'] = (isset($_POST['gamefeed_cron_publish']) ) ? true : false;
  $gamefeed['cron_publish_limit']  = (isset($_POST['gamefeed_cron_publish_limit']) ) ? intval($_POST['gamefeed_cron_publish_limit']) : 1;
  // Update Settings
  update_option( 'myarcade_gamefeed', $gamefeed );
}

/**
 * Handles TalkArcades Autopublisher requests
 *
 * @version 5.26.0
 * @since   5.26.0
 * @return  string Status
 */
function myarcade_handle_autopublisher_gamefeed() {

  $defaults = array(
    'gfcmd' => false,
    'chlg'  => false,
  );

  parse_str( parse_url(  $_SERVER["REQUEST_URI"], PHP_URL_QUERY ), $request );

  $request = wp_parse_args( $request, $defaults );

  if ( ! empty( $request['gfcmd'] ) ) {
    switch ( $request['gfcmd'] ) {

      case "verify":
      case "status": {
        $status = myarcade_gamefeed_check();
      } break;

      case "pullgame": {
        $gameid = esc_sql( $request['gameid'] );
        $apcid  = esc_sql( $request['apcid'] );
        $dbg    = ( isset( $request['dbg'] ) ) ? esc_sql( $request['dbg'] ) : false;

        if ( $gameid && $apcid ) {
          $status = myarcade_gamefeed_pullgame( $gameid, $apcid, $dbg );
        }
        else {
          $status = "Missing parms [$gameid][$apcid].";
        }
      } break;

      case "catmap": {
        $status = myarcade_gamefeed_category_mapping();
      } break;

      case "plays": {
        // Currently we can't determinate that. So return 0
        $status = "0";
      } break;

      default: {
        // $statusstr = "bad call. AutoPublisher doesn't know command (". $command .").";
        $status = "no.";
      } break;
    }
  }
  else {
    // $statusstr = "bad call. AutoPublisher was passed an empty command (gfcmd).";
    $status = "no.";
  }

  // send back an acknowledgement
  echo $status;

  // boom done bye
  die();
}

/**
 * Equivalent to the original "sense" function. Check the site status (filesystem, database, config).
 * As WordPress is already loaded we do not need to check those.
 *
 * @version 5.26.0
 * @since   5.26.0
 * @return  string Check string
 */
function myarcade_gamefeed_check() {

  $return = array();
  $return['cfg'] = "clear.";
  // We do not need to check the file system as we are on WordPress
  $return['filesys'] = "clear.";
  // We do not need to check the database connection as we are already conected
  $return['db'] = "clear.";

  $keys = "";
  $values = "";

  foreach ( $return as $key => $value ) {
    $keys .= $key ."|";
    $values .= $value ."|";
  }

  return rtrim( $keys, "|" ) ."-=-". rtrim( $values, "|" );
}

/**
 * Retrieve all categories for mapping
 *
 * @version 5.26.0
 * @since   5.26.0
 * @return  string Category ids, name pairs
 */
function myarcade_gamefeed_category_mapping() {

  $general = get_option('myarcade_general');

  $ids = "";
  $names = "";

  // Get all categories
  if ( $general['post_type'] == 'post' ) {
    $category_ids = get_terms( 'category', array('fields' => 'ids', 'get' => 'all') );

    foreach ( $category_ids as $category_id ) {
      $ids   .= $category_id . "|";
      $names .= get_cat_name( $category_id ) . "|";
    }
  }
  else {
    if ( taxonomy_exists( $general['custom_category'] ) ) {
      $taxonomies = get_terms( $general['custom_category'], array( 'hide_empty' => false ) );

      foreach ( $taxonomies as $taxonomy ) {
        $ids   .= $taxonomy->term_id . "|";
        $names .= $taxonomy->name . "|";
      }
    }
  }

  return $result = rtrim( $names, "|" ) ."-=-". rtrim( $ids, "|" );
}

/**
 * Pull the requested game from TalkArcades
 *
 * @version 5.26.0
 * @since   5.26.0
 * @param   string $gameid Game to pull
 * @param   string $apcid
 * @param   string $debug Debug flag. Controls the debug output
 * @return  string  Status
 */
function myarcade_gamefeed_pullgame( $gameid, $apcid, $debug = false ) {

  if ( $debug ) {
    echo "<br />start: gameid=$gameid, apcid=$apcid, debug=$debug<br />";
  }

  // Include required files
  require_once( MYARCADE_CORE_DIR . '/addgames.php' );
  require_once( MYARCADE_CORE_DIR . '/file.php' );

  $url = "http://www.talkarcades.com/gamefeed.php?do=feed&gameid=$gameid&apcid=$apcid";
  $content = myarcade_get_file( $url );

  if ( ! empty( $content['error'] ) ) {
    return $content['error'];
  }

  if ( $debug ) {
    echo "<br />got feed: url=$url<br />";
  }

  // Explode the output into an array
  $twofisted = explode( "-=|=-", $content['response'] );
  $keez = explode( "|||", $twofisted[0] );
  $valz = explode( "|||", $twofisted[1] );

  $keyct = count($keez);
  for( $ii = 0; $ii < $keyct; $ii++ ) {
    $feed[ $keez[ $ii ] ] = $valz[ $ii ];
  }

  if ( $feed['magic'] != "gamefeed" ) {
    return "Unexpected feed format.";
  }

  if ( ! empty( $feed['warning'] ) ) {
    return $feed['warning'];
  }

  $general = get_option('myarcade_general');
  $gamefeed = myarcade_get_settings( 'gamefeed' );

  // Generate the MyArcadePlugin game object
  $game                = new stdClass;
  $game->uuid          = $gameid . '_gamefeed';
  $game->name          = esc_sql( $feed['title'] );
  $game->game_tag      = md5( $game->name . 'gamefeed' );
  $game->type          = 'gamefeed';
  $game->slug          = esc_sql( $feed['slug'] );
  $game->description   = esc_sql( $feed['description'] );
  $game->instructions  = esc_sql( $feed['controlsSentence'] );
  $game->tags          = esc_sql( $feed['taglistCSV'] );
  $game->swf_url       = esc_sql( $feed['gamepath'] );
  $game->width         = esc_sql( $feed['width'] );
  $game->height        = esc_sql( $feed['height'] );
  $game->thumbnail_url = esc_sql( $feed['image100path'] );
  $game->screen1_url   = $feed['image180path'];

  if ( ( $general['post_type'] != 'post' ) && taxonomy_exists( $general['custom_category'] ) ) {
    $taxonomy = $general['custom_category'];
  }
  else {
    $taxonomy = 'category';
  }

  $term = get_term_by( 'id', intval( $feed['categoryid'] ), $taxonomy );
  $game->categs =  ( ! empty( $term->name ) ) ? $term->name : "Other";

  if ( myarcade_add_fetched_game( $game ) ) {
    if ( "add" != $gamefeed['status'] ) {
      $game_id = $wpdb->get_var( "SELECT id FROM {$wpdb->prefix}myarcadegames WHERE uuid = '{$game->uuid}" );
      if ( $gameID ) {
        myarcade_add_games_to_blog( array( 'game_id' => $game_id, 'post_status' => $gamefeed['status'], 'echo' => false ) );
      }
    }
  }

  return "clear";
}
?>