require.config({
    baseUrl: 'js',
    paths: {
        'jquery': "libs/jquery",
        'bootstrap': 'libs/bootstrap.min',
        'bootstrap-notify': 'libs/bootstrap-notify.min',
        'moment': 'libs/moment.min',
        'daterangepicker': 'libs/daterangepicker.min',
        'select2': 'libs/select2.min',
        'underscore': 'libs/underscore',
        'backbone': 'libs/backbone',
        'backbone-validation': 'libs/backbone-validation-amd-min'
    },

    shim: {
        'bootstrap': ['jquery'],
        'bootstrap-notify': ['bootstrap'],
        'daterangepicker': ['bootstrap'],
        'select2': ['bootstrap']
    }
});

require(['app/app', 'backbone', 'backbone-validation', 'jquery', 'bootstrap', 'bootstrap-notify', 'daterangepicker', 'select2'],
    function (appRouter, Backbone) {
        "use strict";

        $(document).ready(function () {
            (function () {
                $("body").on('focus', ".datepicker", function () {
                    $(this).daterangepicker({
                        singleDatePicker: true,
                        showDropdowns: true,
                        locale: {
                            format: 'YYYY-MM-DD'
                        }
                    });
                });

                $.fn.select2.defaults.set("theme", "bootstrap");
                $.fn.select2.defaults.set("width", "auto");
                $.fn.select2.defaults.set("placeholder", "Select...");
                $.fn.select2.defaults.set("minimumInputLength", "1");
                $.fn.select2.defaults.set("allowClear", "true");
            })();
        });

        _.extend(Backbone.Validation.callbacks, {
            valid: function (view, attr, selector) {
                var $el = view.$('[name=' + attr + ']'),
                    $group = $el.closest('.form-group');

                $group.removeClass('has-error');
                $group.find('.help-block').html('').addClass('hidden');
            },
            invalid: function (view, attr, error, selector) {
                var $el = view.$('[name=' + attr + ']'),
                    $group = $el.closest('.form-group');

                $group.addClass('has-error');
                $group.find('.help-block').html(error).removeClass('hidden');
            }
        });

        var router = new appRouter();
        Backbone.history.start();
    }
);

//Function to manage notifications
function notifications(msg, type, icon) {
    $.notify({
        icon: icon,
        message: msg
    }, {
        offset: {
            y: 40
        },
        type: type,
        newest_on_top: true,
        placement: {
            from: "top",
            align: "center"
        },
        template: '<div data-notify="container" class="col-xs-11 col-sm-3 alert alert-{0}" role="alert">' +
        '<button type="button" aria-hidden="true" class="close" data-notify="dismiss">×</button>' +
        '<span data-notify="icon"></span> ' +
        '<span data-notify="title">{1}</span> ' +
        '<span data-notify="message">{2}</span>' +
        '<div class="progress" data-notify="progressbar">' +
        '<div class="progress-bar progress-bar-{0}" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>' +
        '</div>' +
        '<a href="{3}" target="{4}" data-notify="url"></a>' +
        '</div>'
    });
}

//Function to format select2 result
function formatResult (item) {
    if (item.status) {
        var status = item.status == 0 ? '' : 'text-danger';
        return '<span class="' + status + '">' + item.text + '</span>';
    }else {
        return item.text;
    }
}

define(function(require) {
    require(['moment'], function(moment) {
        window.moment = moment;
        return moment;
    });
});