define(['jquery',
        'underscore',
        'backbone',
        'backbone-validation',
        'i18n!nls/language'],
    function ($, _, Backbone, Validation, lang) {

        var StaffView = Backbone.View.extend({

            id: "staffDetails",

            template: _.template($('#addStaff').html()),

            collection: null,

            events: {
                "click .saveButton": "staffSave",
                "click .deleteButton": "staffDelete"
            },

            initialize: function () {
                this.listenTo(this.model, 'update', this.render);
                this.listenTo(this.model, 'destroy', this.remove);
                this.listenTo(this.model, 'request', this.loading.start);
                this.listenTo(this.model, 'sync error', this.loading.stop);
                Backbone.Validation.bind(this);
            },

            render: function () {
                $(this.el).html(this.template(_.extend(this.model.toJSON(), {lang: lang})));
                return this;
            },

            loading: {
                start: function () {
                    $(".loading-save", this.el).removeClass("hidden");
                },
                stop: function () {
                    $(".loading-save", this.el).addClass("hidden");
                }
            },

            staffSave: function (e) {
                e.preventDefault();
                var inputs = $('form', this.el).serializeArray(),
                    self = this,
                    isnew = this.model.isNew(),
                    data = {};
                $.each(inputs, function (i, input) {
                    data[input.name] = input.value;
                });
                this.model.set(data, {silent: true});
                this.model.save(null, {
                    success: function (model, response, options) {
                        notifications(lang.user_success_save, 'success', 'fa fa-check');
                        if (isnew) {
                            self.collection.add(model);
                            Backbone.history.navigate('settings/staff/' + model.get('id'), {trigger: true});
                        }
                    },
                    error: function (model, response, options) {
                        var msg = lang.user_error_save;
                        if (response.responseJSON) {
                            msg = response.responseJSON[Object.keys(response.responseJSON)[0]];
                        }
                        notifications(msg, 'danger', 'fa fa-exclamation-triangle');
                    }
                });
            },

            staffDelete: function (e) {
                e.preventDefault();
                this.model.destroy({
                    wait: true,
                    success: function (model, response) {
                        notifications(lang.user_success_del, 'success', 'fa fa-check');
                        Backbone.history.navigate('settings', {trigger: true});
                    },
                    error: function (model, xhr, options) {
                        notifications(lang.user_error_del, 'danger', 'fa fa-exclamation-triangle');
                    }
                });
            }

        });

        return StaffView;

    }
);