define(['jquery',
        'underscore',
        'backbone',
        'i18n!nls/language'],
    function ($, _, Backbone, lang) {

        var SettingsView = Backbone.View.extend({

            id: "settings",

            template: _.template($('#settingsView').html()),

            events: {
                "click tbody tr": "viewStaff"
            },

            collection: null,

            initialize: function () {
                this.listenTo(this.model, 'update', this.render);
                this.listenTo(this.model, 'destroy', this.remove);
                Backbone.Validation.bind(this);
            },

            render: function () {
                var staff = this.model.models,
                    len = staff.length;

                $(this.el).html(this.template(_.extend(this.model.toJSON(), {lang: lang})));

                for (var i = 0; i < len; i++) {
                    $("tbody", this.el).append(new StaffItemView({model: staff[i]}).render().el);
                }

                return this;
            },

            viewStaff: function (e) {
                var id = $(e.target).parent().attr("id");
                Backbone.history.navigate('settings/staff/' + id, {trigger: true});
            }

        });

        var StaffItemView = Backbone.View.extend({

            tagName: "tr",

            id: function () {
                return this.model.get('id');
            },

            template: _.template("<td><%- name %></td><td><%- email %></td><td><%- phone %></td>"),

            render: function () {
                $(this.el).html(this.template(this.model.toJSON()));
                return this;
            }

        });

        return SettingsView;

    }
);