define(['jquery',
        'underscore',
        'backbone',
        'app/views/pagination',
        'i18n!nls/language'],
    function ($, _, Backbone, Pagination, lang) {

        var RentalsListView = Backbone.View.extend({

            className: "col-md-8 col-md-offset-2",

            template: _.template($('#rentalsList').html()),

            events: {
                "input .search-input": "searchRentals",
                "click tbody tr": "viewRental"
            },

            page: 1,

            app: null,

            timeout: 0,

            initialize: function (options) {
                this.page = options.page || 1;
                this.app = options.app || null;
            },

            render: function () {
                var total_books = this.app.booksCollection.models.length,
                    total_clients = this.app.clientsCollection.models.length,
                    total_rentals = this.model.models.length;

                $(this.el).html(this.template({
                    total_books: total_books,
                    total_clients: total_clients,
                    total_rentals: total_rentals,
                    lang: lang
                }));

                $("#table-container", this.el).html(new RentalTableView({
                    model: this.model.models,
                    page: this.page
                }).render().el);
                return this;
            },

            searchRentals: function (e) {
                var self = this,
                    val = $(e.target).val();
                clearTimeout(this.timeout);
                if (val.length > 0) {
                    this.timeout = setTimeout(function () {
                        var rentals = self.model.filter(function (rental) {
                            var regex = new RegExp(val, "ig");
                            return regex.test(rental.get('client'));
                        });
                        $("#table-container", self.el).html(new RentalTableView({model: rentals}).render().el);
                    }, 800);
                } else {
                    $("#table-container", self.el).html(new RentalTableView({model: this.model.models}).render().el);
                }
            },

            viewRental: function (e) {
                var id = $(e.target).parent().attr("id");
                Backbone.history.navigate('rental/' + id, {trigger: true});
            }

        });

        var RentalTableView = Backbone.View.extend({

            className: "table-container",

            template: _.template($('#rentalsTable').html()),

            page: 1,

            initialize: function (options) {
                this.page = options.page || 1;
            },

            render: function () {
                var rentals = this.model,
                    len = rentals.length,
                    start = (this.page - 1) * 15,
                    end = Math.min(start + 15, len);

                $(this.el).html(this.template({lang: lang}));

                for (var i = start; i < end; i++) {
                    $("tbody", this.el).append(new RentalItemView({model: rentals[i]}).render().el);
                }

                if (len > 0) {
                    $(this.el).append(new Pagination({
                        model: this.model,
                        page: this.page,
                        path: "rentals",
                        per_page: 15
                    }).render().el);
                }

                return this;
            }

        });

        var RentalItemView = Backbone.View.extend({

            tagName: "tr",

            id: function () {
                return this.model.get('id');
            },

            template: _.template("<td><%- client %></td><td><%- book %></td><td><%- return_date %>"),

            render: function () {
                $(this.el).html(this.template(this.model.toJSON()));
                return this;
            }

        });

        return RentalsListView;

    }
);