define(['jquery',
        'underscore',
        'backbone',
        'app/models/rentals',
        'i18n!nls/language'],
    function ($, _, Backbone, Rental, lang) {

        var RentalView = Backbone.View.extend({

            id: "rentalsDetails",

            template: _.template($('#rentalView').html()),

            collection: null,

            events: {
                "click .saveButton": "rentalSave",
                "click .deleteButton": "rentalDelete"
            },

            initialize: function () {
                this.listenTo(this.model, 'update', this.render);
                this.listenTo(this.model, 'destroy', this.remove);
                this.listenTo(this.model, 'request', this.loading.start);
                this.listenTo(this.model, 'sync error', this.loading.stop);
                Backbone.Validation.bind(this);
            },

            render: function () {
                $(this.el).html(this.template(_.extend(this.model.toJSON(), {lang: lang})));
                $(".select2", this.el).select2({
                    ajax: {
                        dataType: 'json',
                        delay: 800,
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (item) {
                                    if (item.title) {
                                        return {
                                            text: item.title,
                                            id: item.id,
                                            status: item.status
                                        }
                                    } else {
                                        return {
                                            text: item.name,
                                            id: item.id
                                        }
                                    }
                                })
                            };
                        }
                    },
                    escapeMarkup: function (markup) {
                        return markup;
                    },
                    templateResult: formatResult
                });
                return this;
            },

            loading: {
                start: function () {
                    $(".loading-save", this.el).removeClass("hidden");
                },
                stop: function () {
                    $(".loading-save", this.el).addClass("hidden");
                }
            },

            rentalSave: function (e) {
                e.preventDefault();
                var inputs = $('form', this.el).serializeArray(),
                    self = this,
                    data = {},
                    books = {};
                $.each(inputs, function (i, input) {
                    if (input.name == "books") {
                        books[i] = input.value;
                    } else {
                        data[input.name] = input.value;
                    }
                });
                $.each(books, function (i, book) {
                    var model = self.model;
                    if (self.model.isNew()) {
                        model = new Rental();
                    }
                    model.set({
                        book_id: book,
                        renter_id: data.renter,
                        return_date: data.return_date
                    }, {silent: true});
                    model.save(null, {
                        success: function (model, response, options) {
                            notifications(lang.rental_success_save, 'success', 'fa fa-check');
                            if (self.collection) {
                                self.collection.add(model);
                                Backbone.history.navigate('rental/' + model.get('id'), {trigger: true});
                            }
                        },
                        error: function (model, response, options) {
                            var msg = lang.rental_error_save;
                            if (response.responseJSON) {
                                msg = response.responseJSON[Object.keys(response.responseJSON)[0]];
                            }
                            notifications(msg, 'danger', 'fa fa-exclamation-triangle');
                        }
                    });
                });
            },

            rentalDelete: function (e) {
                e.preventDefault();
                this.model.destroy({
                    wait: true,
                    success: function (model, response) {
                        notifications(lang.rental_success_del, 'success', 'fa fa-check');
                        Backbone.history.navigate('', {trigger: true});
                    },
                    error: function (model, xhr, options) {
                        notifications(lang.rental_error_del, 'danger', 'fa fa-exclamation-triangle');
                    }
                });
            }

        });

        return RentalView;

    }
);