define(['jquery',
        'underscore',
        'backbone'],
    function ($, _, Backbone) {

        var Pagination = Backbone.View.extend({

            className: "text-center",

            template: _.template($('#paginationView').html()),

            page: 1,

            per_page: 10,

            path: "",

            initialize: function (options) {
                this.page = options.page || 1;
                this.per_page = options.per_page || 10;
                this.path = options.path || '';
                this.render();
            },

            render: function () {
                var len = this.model.length,
                    pages = Math.ceil(len / this.per_page),
                    start = pages > 10 ? (this.page - 1) : 0,
                    end = (pages > 10) && (this.page + 5) <= pages ? (this.page + 5) : pages;

                $(this.el).html(this.template({
                    pages: pages,
                    page: this.page,
                    start: start,
                    end: end,
                    path: this.path
                }));

                return this;
            }
        });

        return Pagination;

    }
);