define(['jquery',
        'underscore',
        'backbone',
        'app/views/pagination',
        'app/collections/archive',
        'i18n!nls/language'],
    function ($, _, Backbone, Pagination, ArchiveCollection, lang) {

        var ArchiveView = Backbone.View.extend({

            template: _.template('<div class="text-center"><img src="img/spinner.svg" alt="Loanding..."><p><%= lang.loading %>...</p></div>'),

            collection: null,

            page: 1,

            type: 'book',

            timeout: 0,

            app: null,

            initialize: function (options) {
                this.type = options.type || "book";
                this.page = options.page || 1;
                if (options.app) {
                    this.app = options.app;
                    this.listenTo(this.app, 'route:updateHistory', function (route, params) {
                        this.update(route);
                    })
                }

            },

            render: function () {
                $(this.el).html(this.template({lang: lang}));
                var self = this,
                    history = new ArchiveCollection();
                history.fetch({
                    data: {type: this.type, id: this.model.get('id')},
                    success: function (collection, response, options) {
                        $(self.el).html(new ArchiveTableView({model: collection}).render().el);
                        self.collection = collection;
                    }
                });
                return this;
            },

            update: function (page) {
                $(this.el).html(new ArchiveTableView({model: this.collection, page: parseInt(page)}).render().el);
            }

        });

        var ArchiveTableView = Backbone.View.extend({

            className: "table-container",

            template: _.template($('#historyTable').html()),

            page: 1,

            initialize: function (options) {
                this.page = options.page || 1;
            },

            render: function () {
                var items = this.model.models,
                    len = items.length,
                    start = (this.page - 1) * 15,
                    end = Math.min(start + 15, len);

                $(this.el).html(this.template({lang: lang}));

                for (var i = start; i < end; i++) {
                    $("tbody", this.el).append(new ArchiveItemView({model: items[i]}).render().el);
                }

                if (len > 0) {
                    $(this.el).append(new Pagination({
                        model: this.model,
                        page: this.page,
                        path: "history",
                        per_page: 15
                    }).render().el);
                }

                return this;
            }

        });

        var ArchiveItemView = Backbone.View.extend({

            tagName: "tr",

            template: _.template("<td><%- updated_at %></td><td><%- book %></td><td><%- client %></td><td><%- lang.events[event] %></td>"),

            render: function () {
                $(this.el).html(this.template(_.extend(this.model.toJSON(), {lang: lang})));
                return this;
            }

        });

        return ArchiveView;

    }
);