define(['jquery',
        'underscore',
        'backbone',
        'i18n!nls/language'],
    function ($, _, Backbone, lang) {

        var HeaderView = Backbone.View.extend({

            template: _.template($('#headerView').html()),

            events: {
                "input .search-input": "searchBook"
            },

            timeout: 0,

            app: null,

            resultsView: null,

            initialize: function (options) {
                this.app = options.app;
                this.listenTo(this.app, 'route', function (route, params) {
                    this.selectMenu(route);
                });
                $(document).click(function (event) {
                    if (!$(event.target).closest('#searchBooks').length) {
                        $(".search-results").addClass('hidden');
                    }
                });
            },

            render: function () {
                $(this.el).html(this.template({lang: lang}));
                return this;
            },

            selectMenu: function (route) {
                $(this.el).find("li").removeClass('active');
                $("." + route).addClass('active');
            },

            searchBook: function (e) {
                var self = this,
                    val = $(e.target).val();
                clearTimeout(this.timeout);
                if (val.length > 0) {
                    this.timeout = setTimeout(function () {
                        var books = self.app.booksCollection.filter(function (book) {
                            var regex = new RegExp(val, "ig");
                            return regex.test(book.get('title'));
                        });
                        if (books.length > 0){
                            self.resultsView = new SearchResults({model: books});
                            $("#search-results", self.el).html(self.resultsView.render().el);
                        }
                    }, 800);
                } else {
                    if (self.resultsView) {
                        self.resultsView.remove();
                    }
                }
            }

        });

        var SearchResults = Backbone.View.extend({

            className: "search-results",

            template: _.template($('#searchResults').html()),

            events: {
                "click a": "complete"
            },

            render: function () {
                $(this.el).html(this.template({books: this.model, lang: lang}));
                return this;
            },

            complete: function (e) {
                var val = $(e.currentTarget).find('.result-title').text();
                $('.search-input').val(val);
                this.remove();
            }

        });

        return HeaderView;

    }
);