define(['jquery',
        'underscore',
        'backbone',
        'app/views/pagination',
        'i18n!nls/language'],
    function ($, _, Backbone, Pagination, lang) {

        var ClientsListView = Backbone.View.extend({

            className: "col-md-8 col-md-offset-2",

            template: _.template($('#clientsList').html()),

            events: {
                "input .search-input": "searchClients",
                "click tbody tr": "viewClient"
            },

            page: 1,

            timeout: 0,

            initialize: function (options) {
                this.page = options.page || 1;
            },

            render: function () {
                $(this.el).html(this.template({lang: lang}));

                $("#table-container", this.el).html(new ClientTableView({
                    model: this.model.models,
                    page: this.page
                }).render().el);

                if (this.model.models.length > 0) {
                    $('#table-container', this.el).append(new Pagination({
                        model: this.model.models,
                        page: this.page,
                        path: "clients",
                        per_page: 20
                    }).render().el);
                }

                return this;
            },

            searchClients: function (e) {
                var input = e.target,
                    self = this,
                    val = $(input).val();
                clearTimeout(this.timeout);
                if (val.length > 0) {
                    this.timeout = setTimeout(function () {
                        var clients = self.model.filter(function (client) {
                            var regex = new RegExp(val, "ig");
                            return regex.test(client.get('name'));
                        });
                        $("#table-container", self.el).html(new ClientTableView({model: clients}).render().el);
                    }, 1000);
                } else {
                    $("#table-container", self.el).html(new ClientTableView({model: this.model.models}).render().el);
                }
            },

            viewClient: function (e) {
                var id = $(e.target).parent().attr("id");
                Backbone.history.navigate('client/' + id, {trigger: true});
            }

        });

        var ClientTableView = Backbone.View.extend({

            className: "table-responsive",

            template: _.template($('#clientsTable').html()),

            page: 1,

            initialize: function (options) {
                this.page = options.page || 1;
            },

            render: function () {
                var clients = this.model,
                    len = clients.length,
                    start = (this.page - 1) * 20,
                    end = Math.min(start + 20, len);

                $(this.el).html(this.template({lang: lang}));

                for (var i = start; i < end; i++) {
                    $("tbody", this.el).append(new ClientItemView({model: clients[i]}).render().el);
                }
                return this;
            }

        });

        var ClientItemView = Backbone.View.extend({

            tagName: "tr",

            id: function () {
                return this.model.get('id');
            },

            template: _.template("<td><%- name %></td><td><%- address %></td><td><%- phone %></td><td><%- email %></td>"),

            render: function () {
                $(this.el).html(this.template(this.model.toJSON()));
                return this;
            }

        });

        return ClientsListView;

    }
);