define(['jquery',
        'underscore',
        'backbone',
        'backbone-validation',
        'app/views/history',
        'i18n!nls/language'],
    function ($, _, Backbone, Validation, ArchiveView, lang) {

        var ClientView = Backbone.View.extend({

            id: "clientDetails",

            template: _.template($('#clientView').html()),

            collection: null,

            events: {
                "click .saveButton": "clientSave",
                "click .deleteButton": "clientDelete"
            },

            app: null,

            initialize: function (options) {
                this.listenTo(this.model, 'update', this.render);
                this.listenTo(this.model, 'destroy', this.remove);
                this.listenTo(this.model, 'request', this.loading.start);
                this.listenTo(this.model, 'sync error', this.loading.stop);
                if (options.app) this.app = options.app;
                Backbone.Validation.bind(this);
            },

            render: function () {
                $(this.el).html(this.template(_.extend(this.model.toJSON(), {lang: lang})));
                if (!(this.model.isNew())) {
                    $('#history', this.el).html(new ArchiveView({model: this.model, type: 'client', app: this.app}).render().el);
                }
                return this;
            },

            loading: {
                start: function () {
                    $(".loading-save", this.el).removeClass("hidden");
                },
                stop: function () {
                    $(".loading-save", this.el).addClass("hidden");
                }
            },

            clientSave: function (e) {
                e.preventDefault();
                var inputs = $('form', this.el).serializeArray(),
                    self = this,
                    isnew = this.model.isNew(),
                    data = {};
                $.each(inputs, function (i, input) {
                    data[input.name] = input.value;
                });
                this.model.set(data);
                this.model.save(null, {
                    success: function (model, response, options) {
                        notifications(lang.client_success_save, 'success', 'fa fa-check');
                        if (isnew) {
                            self.collection.add(model);
                            Backbone.history.navigate('client/' + model.get('id'), {trigger: true});
                        }
                    },
                    error: function (model, response, options) {
                        var msg = lang.client_error_save;
                        if (response.responseJSON) {
                            msg = response.responseJSON[Object.keys(response.responseJSON)[0]];
                        }
                        notifications(msg, 'danger', 'fa fa-exclamation-triangle');
                    }
                });
            },

            clientDelete: function (e) {
                e.preventDefault();
                this.model.destroy({
                    wait: true,
                    success: function (model, response) {
                        notifications(lang.client_success_del, 'success', 'fa fa-check');
                        Backbone.history.navigate('clients', {trigger: true});
                    },
                    error: function (model, xhr, options) {
                        notifications(lang.client_error_del, 'danger', 'fa fa-exclamation-triangle');
                    }
                });
            }

        });

        return ClientView;

    }
);