define(['jquery',
        'underscore',
        'backbone',
        'app/views/pagination',
        'i18n!nls/language'],
    function ($, _, Backbone, Pagination, lang) {

        var BooksListView = Backbone.View.extend({

            id: "booksList",

            page: 1,

            initialize: function (options) {
                this.page = options.page || 1;
            },

            render: function () {
                var books = this.model.models,
                    len = books.length,
                    start = (this.page - 1) * 12,
                    end = Math.min(start + 12, len);

                for (var i = start; i < end; i++) {
                    $(this.el).append(new BookItemView({model: books[i]}).render().el);
                }

                if (len > 0) {
                    $(this.el).append(new Pagination({
                        model: books,
                        page: this.page,
                        path: "books",
                        per_page: 12
                    }).render().el);
                }
                return this;
            }

        });

        var BookItemView = Backbone.View.extend({

            className: 'col-xs-6 col-sm-3 col-md-2',

            template: _.template($('#bookList').html()),

            render: function () {
                $(this.el).html(this.template(_.extend(this.model.toJSON(), {lang: lang})));
                return this;
            }

        });

        return BooksListView;

    }
);