define(['jquery',
        'underscore',
        'backbone',
        'app/views/history',
        'i18n!nls/language'],
    function ($, _, Backbone, ArchiveView, lang) {

        var BookView = Backbone.View.extend({

            id: "bookDetails",

            template: _.template($('#bookView').html()),

            collection: null,

            events: {
                "change #inputImage": "coverPreview",
                "click .saveButton": "bookSave",
                "click .deleteButton": "bookDelete"
            },

            app: null,

            initialize: function (options) {
                this.listenTo(this.model, 'change', this.render);
                this.listenTo(this.model, 'destroy', this.remove);
                if (options.app) this.app = options.app;
                Backbone.Validation.bind(this);
            },

            render: function () {
                $(this.el).html(this.template(_.extend(this.model.toJSON(), {lang: lang})));
                if (!(this.model.isNew())) {
                    $('#history', this.el).html(new ArchiveView({model: this.model, type: 'book', app: this.app}).render().el);
                }
                return this;
            },

            coverPreview: function (e) {
                var input = e.target;
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#coverPreview').attr('src', e.target.result);
                    };
                    reader.readAsDataURL(input.files[0]);
                }
            },

            bookSave: function (e) {
                e.preventDefault();
                var self = this,
                    inputs = $('form', this.el).serializeArray(),
                    data = {};
                $.each(inputs, function (i, input) {
                    data[input.name] = input.value;
                });
                this.model.set(data, {silent: true});
                if (this.model.isValid(true)) {
                    var status = data.status;
                    data = new FormData($('form', this.el)[0]);
                    data.append("status", status);
                    $.ajax({
                        url: 'book/save',
                        type: 'POST',
                        data: data,
                        processData: false,
                        contentType: false,
                        beforeSend: function () {
                            $(".loading-save", self.el).removeClass("hidden");
                        },
                        complete: function () {
                            $(".loading-save", self.el).addClass("hidden");
                        },
                        success: function (data) {
                            if (data.id) {
                                self.model.set({
                                    id: data.id,
                                    title: data.title,
                                    author: data.author,
                                    published_on: data.published_on,
                                    cover: data.cover
                                });
                                if (self.collection) {
                                    self.collection.add(self.model);
                                    Backbone.history.navigate('book/' + self.model.id, {trigger: true});
                                }
                                notifications(lang.book_success_save, 'success', 'fa fa-check');
                            } else {
                                var msg = lang.book_error_save;
                                if (data[Object.keys(data)[0]]) {
                                    msg = data[Object.keys(data)[0]];
                                }
                                notifications(msg, 'danger', 'fa fa-exclamation-triangle');
                            }
                        },
                        error: function () {
                            notifications(lang.book_error_save, 'danger', 'fa fa-exclamation-triangle');
                        }
                    });
                }
            },

            bookDelete: function (e) {
                e.preventDefault();
                this.model.destroy({
                    wait: true,
                    success: function (model, response) {
                        notifications(lang.book_success_del, 'success', 'fa fa-check');
                        Backbone.history.navigate('', {trigger: true});
                    },
                    error: function (model, xhr, options) {
                        notifications(lang.book_error_del, 'danger', 'fa fa-exclamation-triangle');
                    }
                });
            }

        });

        return BookView;

    }
);