define(['backbone'],
    function (Backbone) {

        var Staff = Backbone.Model.extend({

            urlRoot: 'settings/staff',

            idAttribute: 'id',

            defaults: {
                id: null
            },

            validation: {
                name: {
                    required: true
                },
                email: {
                    required: true,
                    pattern: 'email'
                },
                password: {
                    min: 8,
                    required: false
                }
            }

        });

        return Staff;

    }
);