define(['backbone'],
    function (Backbone) {

        var Client = Backbone.Model.extend({

            urlRoot: 'client',

            idAttribute: 'id',

            defaults: {
                id: null,
                name: '',
                completed: false
            },

            validation: {
                name: {
                    required: true
                },
                address: {
                    required: true
                },
                phone: {
                    required: true
                },
                email: function (val, attr, computed) {
                    if (val.length > 1) {
                        return Backbone.Validation.validators.pattern(val, attr, 'email', this);
                    }
                }
            }

        });

        return Client;

    }
);