define(['backbone'],
    function (Backbone) {

        var Book = Backbone.Model.extend({

            idAttribute: 'id',

            defaults: {
                id: null,
                title: '',
                author: '',
                completed: false
            },

            validation: {
                title: {
                    required: true
                },
                author: {
                    required: true
                },
                published_on: {
                    maxLength: 4
                },
                isbn: {
                    maxLength: 20,
                    pattern: 'number'
                },
                pages: {
                    maxLength: 20,
                    pattern: 'number'
                },
                quantity: {
                    maxLength: 10,
                    pattern: 'number'
                },
                price: {
                    maxLength: 10
                }
            }

        });

        return Book;

    }
);