// External dependencies
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import assign from 'lodash/assign';

// Internal dependencies
import './icon.scss';


class ETBuilderIcon extends PureComponent {

  static defaultProps = {
    color: '#4c5866',
    size:  14,
  };

  static propTypes = {
    className: PropTypes.string,
    color:     PropTypes.string,
    block:     PropTypes.bool,
    icon:      PropTypes.string,
    iconSvg:   PropTypes.string,
    size:      PropTypes.oneOfType([
      PropTypes.string,
      PropTypes.number,
    ]),
    style:     PropTypes.object,
  };

  _renderGraphics() {
    switch (this.props.icon) {
      case 'add':
        return (
          <g>
            <path d="M18 13h-3v-3a1 1 0 0 0-2 0v3h-3a1 1 0 0 0 0 2h3v3a1 1 0 0 0 2 0v-3h3a1 1 0 0 0 0-2z" fillRule="evenodd"/>
          </g>
        );
      case 'back':
        return (
          <g>
            <path d="M14.988 10.963h-3v-2.52a.393.393 0 0 0-.63-.361l-5.2 4.5a.491.491 0 0 0 0 .72l5.2 4.5a.393.393 0 0 0 .63-.36v-2.52h2.99a2.992 2.992 0 0 1 2.99 2.972v1.287a.7.7 0 0 0 .7.694h2.59a.7.7 0 0 0 .7-.694v-1.3a6.948 6.948 0 0 0-6.97-6.918z" fillRule="evenodd"/>
          </g>
        );
      case 'check':
        return (
          <g>
            <path d="M19.203 9.21a.677.677 0 0 0-.98 0l-5.71 5.9-2.85-2.95a.675.675 0 0 0-.98 0l-1.48 1.523a.737.737 0 0 0 0 1.015l4.82 4.979a.677.677 0 0 0 .98 0l7.68-7.927a.737.737 0 0 0 0-1.015l-1.48-1.525z" fillRule="evenodd"/>
          </g>
        );
      case 'close':
        return (
          <g>
            <path d="M15.59 14l4.08-4.082a1.124 1.124 0 0 0-1.587-1.588L14 12.411 9.918 8.329A1.124 1.124 0 0 0 8.33 9.92L12.411 14l-4.082 4.082a1.124 1.124 0 0 0 1.59 1.589L14 15.589l4.082 4.082a1.124 1.124 0 0 0 1.589-1.59L15.589 14h.001z" fillRule="evenodd"/>
          </g>
        );
      case 'close-small':
        return (
          <g>
            <path d="M15.59 14l4.08-4.082a1.124 1.124 0 0 0-1.587-1.588L14 12.411 9.918 8.329A1.124 1.124 0 0 0 8.33 9.92L12.411 14l-4.082 4.082a1.124 1.124 0 0 0 1.59 1.589L14 15.589l4.082 4.082a1.124 1.124 0 0 0 1.589-1.59L15.589 14h.001z" fillRule="evenodd"/>
          </g>
        );
      case 'column':
        return (
          <g>
            <path d="M20 8H8a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V9a1 1 0 0 0-1-.999V8zm-7 2h2v8h-2v-8zm-2 8H9v-8h2v8zm6-8h2v8h-2v-8z" fillRule="evenodd"/>
          </g>
        );
      case 'contract':
        return (
          <g>
            <path d="M20 19L20 9C20 8.5 19.5 8 19 8L9 8C8.5 8 8 8.5 8 9L8 19C8 19.5 8.5 20 9 20L19 20C19.5 20 20 19.5 20 19L20 19ZM18 18L10 18 10 10 18 10 18 18 18 18Z" fillRule="evenodd"/>
            <path d="M11.5 13.5C11.8 13.5 12 13.3 12 13L12 12 13 12C13.3 12 13.5 11.8 13.5 11.5 13.5 11.2 13.3 11 13 11L11.5 11C11.2 11 11 11.2 11 11.5L11 13C11 13.3 11.2 13.5 11.5 13.5L11.5 13.5Z" fillRule="evenodd"/>
            <path d="M16.5 11L15 11C14.7 11 14.5 11.2 14.5 11.5 14.5 11.8 14.7 12 15 12L16 12 16 13C16 13.3 16.2 13.5 16.5 13.5 16.8 13.5 17 13.3 17 13L17 11.5C17 11.2 16.8 11 16.5 11L16.5 11Z" fillRule="evenodd"/>
            <path d="M13 16L12 16 12 15C12 14.7 11.8 14.5 11.5 14.5 11.2 14.5 11 14.7 11 15L11 16.5C11 16.8 11.2 17 11.5 17L13 17C13.3 17 13.5 16.8 13.5 16.5 13.5 16.2 13.3 16 13 16L13 16Z" fillRule="evenodd"/>
            <path d="M16.5 14.5C16.2 14.5 16 14.7 16 15L16 16 15 16C14.7 16 14.5 16.2 14.5 16.5 14.5 16.8 14.7 17 15 17L16.5 17C16.8 17 17 16.8 17 16.5L17 15C17 14.7 16.8 14.5 16.5 14.5L16.5 14.5Z" fillRule="evenodd"/>
          </g>
        );
      case 'copy':
        return (
          <g>
            <path d="M16.919 15.391c.05-.124.074-.257.072-.39v-6a1.02 1.02 0 0 0-.072-.389.969.969 0 0 0-.893-.612H7.969a.97.97 0 0 0-.893.611c-.05.124-.076.256-.076.39v6c0 .134.026.266.076.39.146.365.5.604.893.605h8.057a.968.968 0 0 0 .893-.605zm3.074-3.413a1 1 0 0 0-1 1v5.011h-7.008a1 1 0 1 0 0 2h8a1 1 0 0 0 1-1v-6.013a1 1 0 0 0-.992-.998zm-5.016 2.013H8.991v-3.988h5.986v3.993-.005z" fillRule="evenodd"/>
          </g>
        );
      case 'delete':
        return (
          <g>
            <path d="M19 9h-3V8a1 1 0 0 0-1-1h-2a1 1 0 0 0-1 1v1H9a1 1 0 1 0 0 2h10a1 1 0 0 0 .004-2H19zM9 20c.021.543.457.979 1 1h8c.55-.004.996-.45 1-1v-7H9v7zm2.02-4.985h2v4h-2v-4zm4 0h2v4h-2v-4z" fillRule="evenodd"/>
          </g>
        );
      case 'desktop':
        return (
          <g>
            <path d="M20 7H8C7.5 7 7 7.5 7 8v10c0 0.5 0.5 1 1 1h5v1h-1c-0.5 0-1 0.5-1 1s0.5 1 1 1h4c0.5 0 1-0.5 1-1s-0.5-1-1-1h-1v-1h5c0.5 0 1-0.5 1-1V8C21 7.5 20.5 7 20 7zM15 18h-2v-1h2V18zM19 16H9V9h10V16z" fillRule="evenodd"/>
          </g>
        );
      case 'grid':
        return (
          <g>
            <path d="M20 7H8C7.5 7 7 7.5 7 8v12c0 0.5 0.5 1 1 1h12c0.5 0 1-0.5 1-1V8C21 7.5 20.5 7 20 7zM15 9v2h-2V9H15zM15 13v2h-2v-2H15zM9 9h2v2H9V9zM9 13h2v2H9V13zM9 19v-2h2v2H9zM13 19v-2h2v2H13zM19 19h-2v-2h2V19zM19 15h-2v-2h2V15zM19 11h-2V9h2V11z" fillRule="evenodd"/>
          </g>
        );
      case 'wireframe':
        return (
          <g>
            <path d="M20 7H8C7.5 7 7 7.5 7 8v4c0 0.5 0.5 1 1 1h12c0.5 0 1-0.5 1-1V8C21 7.5 20.5 7 20 7zM19 11H9V9h10V11z" fillRule="evenodd"/>
            <path d="M12 15H8c-0.5 0-1 0.5-1 1v4c0 0.5 0.5 1 1 1h4c0.5 0 1-0.5 1-1v-4C13 15.5 12.5 15 12 15zM11 19H9v-2h2V19z" fillRule="evenodd"/>
            <path d="M20 15h-4c-0.5 0-1 0.5-1 1v4c0 0.5 0.5 1 1 1h4c0.5 0 1-0.5 1-1v-4C21 15.5 20.5 15 20 15zM19 19h-2v-2h2V19z" fillRule="evenodd"/>
          </g>
        );
      case 'exit':
        return (
          <g>
            <path d="M19.71 16.857l-2.85-2.854 2.85-2.854c.39-.395.39-1.03 0-1.426l-1.43-1.427a1 1 0 0 0-1.42 0L14 11.15l-2.85-2.854a1.013 1.013 0 0 0-1.43 0L8.3 9.723a1 1 0 0 0 0 1.426l2.85 2.854-2.85 2.853a1 1 0 0 0 0 1.427l1.42 1.427a1.011 1.011 0 0 0 1.43 0L14 16.856l2.86 2.854a1 1 0 0 0 1.42 0l1.43-1.427c.39-.395.39-1.03 0-1.426z" fillRule="evenodd"/>
          </g>
        );
      case 'expand':
        return (
          <g>
            <path d="M17 16L17 12C17 11.5 16.5 11 16 11L12 11C11.5 11 11 11.5 11 12L11 16C11 16.5 11.5 17 12 17L16 17C16.5 17 17 16.5 17 16L17 16ZM15 15L13 15 13 13 15 13 15 15 15 15Z" fillRule="evenodd"/>
            <path d="M8.5 12C8.8 12 9 11.8 9 11.5L9 9 11.5 9C11.8 9 12 8.8 12 8.5 12 8.2 11.8 8 11.5 8L8.5 8C8.2 8 8 8.2 8 8.5L8 11.5C8 11.8 8.2 12 8.5 12L8.5 12Z" fillRule="evenodd"/>
            <path d="M19.5 8L16.5 8C16.2 8 16 8.2 16 8.5 16 8.8 16.2 9 16.5 9L19 9 19 11.5C19 11.8 19.2 12 19.5 12 19.8 12 20 11.8 20 11.5L20 8.5C20 8.2 19.8 8 19.5 8L19.5 8Z" fillRule="evenodd"/>
            <path d="M11.5 19L9 19 9 16.5C9 16.2 8.8 16 8.5 16 8.2 16 8 16.2 8 16.5L8 19.5C8 19.8 8.2 20 8.5 20L11.5 20C11.8 20 12 19.8 12 19.5 12 19.2 11.8 19 11.5 19L11.5 19Z" fillRule="evenodd"/>
            <path d="M19.5 16C19.2 16 19 16.2 19 16.5L19 19 16.5 19C16.2 19 16 19.2 16 19.5 16 19.8 16.2 20 16.5 20L19.5 20C19.8 20 20 19.8 20 19.5L20 16.5C20 16.2 19.8 16 19.5 16L19.5 16Z" fillRule="evenodd"/>
          </g>
        );
      case 'heading-four':
        return (
          <g>
            <path d="M8 12.983h5V9a1 1 0 0 1 2 0v9.956a1 1 0 0 1-2 0v-3.973H8v3.973a1 1 0 0 1-2 0V9a1 1 0 1 1 2 0v3.983zm14 5.66h-.75v1.288h-1.29v-1.288h-2.67v-.914l2.74-4.013h1.22v3.907H22v1.02zm-2.04-1.02v-1.055c0-.175.01-.431.02-.764s.03-.529.03-.584h-.03a5.039 5.039 0 0 1-.38.681l-1.14 1.722h1.5z" fillRule="evenodd"/>
          </g>
        );
      case 'heading-one':
        return (
          <g>
            <path d="M13 14.983H8v3.973a1 1 0 0 1-2 0V9a1 1 0 1 1 2 0v3.983h5V9a1 1 0 0 1 2 0v9.956a1 1 0 0 1-2 0v-3.973zm8.1 4.951h-1.32v-3.6l.01-.591.02-.645c-.146.15-.3.294-.46.428l-.71.574-.64-.79 2.01-1.594h1.09v6.218z" fillRule="evenodd"/>
          </g>
        );
      case 'heading-three':
        return (
          <g>
            <path d="M13 14.983H8v3.973a1 1 0 0 1-2 0V9a1 1 0 1 1 2 0v3.983h5V9a1 1 0 0 1 2 0v9.956a1 1 0 0 1-2 0v-3.973zm8.65.125c.01.364-.12.718-.36.991-.26.29-.608.487-.99.561v.026a1.97 1.97 0 0 1 1.14.456c.265.256.407.613.39.981.03.546-.214 1.07-.65 1.4a3.04 3.04 0 0 1-1.87.5 4.6 4.6 0 0 1-1.8-.336v-1.118c.256.127.524.228.8.3.28.075.57.114.86.115a1.7 1.7 0 0 0 .97-.221.8.8 0 0 0 .31-.709.642.642 0 0 0-.36-.622 2.669 2.669 0 0 0-1.14-.183h-.48v-1.007h.49c.363.023.727-.042 1.06-.189a.687.687 0 0 0 .33-.648.714.714 0 0 0-.89-.706c-.21 0-.42.035-.62.1-.25.087-.49.206-.71.353l-.61-.906a3.419 3.419 0 0 1 2.04-.612 2.652 2.652 0 0 1 1.53.392c.36.24.572.649.56 1.082z" fillRule="evenodd"/>
          </g>
        );
      case 'heading-two':
        return (
          <g>
            <path d="M13 14.983H8v3.973a1 1 0 0 1-2 0V9a1 1 0 1 1 2 0v3.983h5V9a1 1 0 0 1 2 0v9.956a1 1 0 0 1-2 0v-3.973zm8.99 4.951h-4.36v-.914l1.57-1.577c.46-.474.76-.8.91-.985a2.1 2.1 0 0 0 .3-.508c.063-.154.097-.318.1-.484a.7.7 0 0 0-.21-.557.8.8 0 0 0-.55-.183c-.246 0-.49.057-.71.166a3.6 3.6 0 0 0-.71.471l-.72-.845a4.47 4.47 0 0 1 .77-.553c.209-.11.43-.194.66-.249.262-.06.53-.09.8-.087.355-.008.707.065 1.03.213.285.13.527.339.7.6.165.262.252.566.25.876.002.275-.049.549-.15.805-.122.277-.28.536-.47.772-.35.398-.725.774-1.12 1.127l-.81.752v.059h2.72v1.106-.005z" fillRule="evenodd"/>
          </g>
        );
      case 'help':
        return (
          <g>
            <circle cx="14" cy="19" r="1"/>
            <path d="M13 16a3.17 3.17 0 0 1 1.59-2.68c.74-.46 1.41-.8 1.41-1.82 0-.5-.45-1.5-2-1.5-1.73 0-2 .95-2 1-.12.6-.33 1-1 1-.67 0-1.12-.4-1-1a3.89 3.89 0 0 1 4-3 3.68 3.68 0 0 1 4 3.5 3.72 3.72 0 0 1-2.23 3.5 1.53 1.53 0 0 0-.77 1 .93.93 0 0 1-1 1 .93.93 0 0 1-1-1z"/>
          </g>
        );
      case 'help-circle':
        return (
          <g>
            <path d="M14 22a8 8 0 1 1 0-16 8 8 0 0 1 0 16zm0-3.6a.8.8 0 1 0 0-1.6.8.8 0 0 0 0 1.6zm-.8-3.2a.744.744 0 0 0 .8.8.744.744 0 0 0 .8-.8c.08-.343.305-.634.616-.8a2.976 2.976 0 0 0 1.784-2.8A2.944 2.944 0 0 0 14 8.8a3.112 3.112 0 0 0-3.2 2.4c-.096.48.264.8.8.8s.704-.32.8-.8c0-.04.216-.8 1.6-.8 1.24 0 1.6.8 1.6 1.2 0 .816-.536 1.088-1.128 1.456A2.536 2.536 0 0 0 13.2 15.2z"/>
          </g>
        );
      case 'history':
        return (
          <g>
            <path d="M14 6.5C9.9 6.5 6.5 9.9 6.5 14 6.5 18.1 9.9 21.5 14 21.5 18.1 21.5 21.5 18.1 21.5 14 21.5 9.9 18.1 6.5 14 6.5L14 6.5ZM14 19.5C11 19.5 8.5 17 8.5 14 8.5 11 11 8.5 14 8.5 17 8.5 19.5 11 19.5 14 19.5 17 17 19.5 14 19.5L14 19.5Z" fillRule="evenodd"/>
            <path d="M17 13L15 13 15 11C15 10.5 14.5 10 14 10 13.5 10 13 10.5 13 11L13 14C13 14.5 13.5 15 14 15L17 15C17.5 15 18 14.5 18 14 18 13.5 17.5 13 17 13L17 13Z" fillRule="evenodd"/>
          </g>
        );
      case 'indent':
        return (
          <g>
            <path d="M20 10H8a1 1 0 1 1 0-2h12a1 1 0 1 1 0 2zm0 10H8a1 1 0 0 1 0-2h12a1 1 0 1 1 0 2zm0-5h-7a1 1 0 0 1 0-2h7a1 1 0 1 1 0 2zM7.77 11.978l2.55 1.6a.5.5 0 0 1 0 .848l-2.55 1.6a.5.5 0 0 1-.77-.424v-3.2a.5.5 0 0 1 .77-.424z" fillRule="evenodd"/>
          </g>
        );
      case 'letter-spacing-small':
        return (
          <g>
            <path d="M15 19V9a1 1 0 0 1 2 0v10a1 1 0 0 1-2 0zm-4 0V9a1 1 0 0 1 2 0v10a1 1 0 0 1-2 0z" fillRule="evenodd"/>
          </g>
        );
      case 'letter-spacing':
        return (
          <g>
            <path d="M18 19V9a1 1 0 0 1 2 0v10a1 1 0 0 1-2 0zM8 19V9a1 1 0 1 1 2 0v10a1 1 0 0 1-2 0z" fillRule="evenodd"/>
          </g>
        );
      case 'line-height-small':
        return (
          <g>
            <path d="M19 13H9a1 1 0 0 1 0-2h10a1 1 0 0 1 0 2zm0 4H9a1 1 0 0 1 0-2h10a1 1 0 0 1 0 2z" fillRule="evenodd"/>
          </g>
        );
      case 'line-height':
        return (
          <g>
            <path d="M19 10H9a1 1 0 1 1 0-2h10a1 1 0 0 1 0 2zm0 10H9a1 1 0 0 1 0-2h10a1 1 0 0 1 0 2z" fillRule="evenodd"/>
          </g>
        );
      case 'list':
        return (
          <g>
            <path d="M7 10a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm0 5a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm0 5a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm11-10h-7a1 1 0 0 1 0-2h7a1 1 0 0 1 0 2zm2 5h-9a1 1 0 0 1 0-2h9a1 1 0 0 1 0 2zm-2 5h-7a1 1 0 0 1 0-2h7a1 1 0 0 1 0 2z" fillRule="evenodd"/>
          </g>
        );
      case 'loading':
        return (
          <g>
            <circle className="et-fb-icon__circle et-fb-icon__circle--1" cx="2" cy="2" r="2" transform="translate(4 12)"/>
            <circle className="et-fb-icon__circle et-fb-icon__circle--2" cx="2.3" cy="2.7" r="2" transform="rotate(72 4.397 10.865)"/>
            <circle className="et-fb-icon__circle et-fb-icon__circle--3" cx="2.3" cy="2.2" r="2" transform="rotate(144 10.216 8.724)"/>
            <circle className="et-fb-icon__circle et-fb-icon__circle--4" cx="2.6" cy="2" r="2" transform="rotate(-144 14.235 7.453)"/>
            <circle className="et-fb-icon__circle et-fb-icon__circle--5" cx="2.8" cy="2.1" r="2" transform="rotate(-72 20.635 5.838)"/>
          </g>
        );
      case 'move':
        return (
          <g>
            <path d="M12.968 17.968a.747.747 0 0 0-1.057 0 .747.747 0 0 0 0 1.057l1.835 1.835a.308.308 0 0 0 .437 0l1.836-1.835a.749.749 0 0 0 0-1.057.752.752 0 0 0-1.06 0v-2.994h3a.747.747 0 0 0 0 1.057.747.747 0 0 0 1.056 0l1.836-1.835a.31.31 0 0 0 0-.437l-1.836-1.835a.747.747 0 0 0-1.057 0 .747.747 0 0 0 0 1.057h-3V9.987a1.28 1.28 0 0 0 1.057 0 .749.749 0 0 0 0-1.057l-1.827-1.84a.308.308 0 0 0-.437 0l-1.835 1.836a.747.747 0 0 0 0 1.057.747.747 0 0 0 1.057 0v2.994h-2.99a.747.747 0 0 0 0-1.057.747.747 0 0 0-1.058 0L7.09 13.755a.31.31 0 0 0 0 .437l1.835 1.835a.747.747 0 0 0 1.057 0 .747.747 0 0 0 0-1.057h2.991l-.005 2.998z" fillRule="evenodd"/>
          </g>
        );
      case 'numbered-list':
        return (
          <g>
            <path d="M9.08 20H7.5a.5.5 0 1 1 0-1h.78l-.14-.146a.492.492 0 0 1 0-.707L8.28 18H7.5a.5.5 0 1 1 0-1h1.58a.653.653 0 0 1 .61.412.672.672 0 0 1-.14.726l-.36.362.36.362a.672.672 0 0 1 .14.726.653.653 0 0 1-.61.412zm8.91-10h-5a1 1 0 1 1 0-2h5a1 1 0 0 1 0 2zm3 5h-8a1 1 0 1 1 0-2h8a1 1 0 0 1 0 2zm-3 5h-5a1 1 0 1 1 0-2h5a1 1 0 0 1 0 2zm-8.51-5H7.5a.482.482 0 0 1-.46-.309.5.5 0 0 1 .1-.544L8.28 13H7.5a.5.5 0 1 1 0-1h1.59a.661.661 0 0 1 .47 1.126L8.69 14h.79a.5.5 0 0 1 0 1zm-.99-4a.5.5 0 0 1-.5-.5V9a.5.5 0 1 1 0-1h.5a.5.5 0 0 1 .49.5v2a.5.5 0 0 1-.49.5z" fillRule="evenodd"/>
          </g>
        );
      case 'paint':
        return (
          <g>
            <path d="M14.489 8.364a.9.9 0 0 0-.641-.26c-.281.003-.55.117-.746.318l-1.611 1.615-1.8-1.8a1 1 0 0 0-1.408 1.41l1.8 1.8-2.767 2.776a.988.988 0 0 0-.057 1.39l4.56 4.573a.9.9 0 0 0 .64.26 1.06 1.06 0 0 0 .747-.317l6.052-6.068a.624.624 0 0 0 .036-.875l-4.805-4.822zm1.07 6.583a4.34 4.34 0 0 1-6.15 0l2.082-2.087 1.017 1.019a1 1 0 1 0 1.408-1.411l-1.017-1.02.925-.928 3.075 3.084-1.34 1.343zm2.39 4.388a1.5 1.5 0 1 0 2.986 0c0-1.278-1.493-4.4-1.493-4.4s-1.493 3.067-1.493 4.4z" fillRule="evenodd"/>
          </g>
        );
      case 'phone':
        return (
          <g>
            <path d="M17 7h-6c-0.5 0-1 0.5-1 1v12c0 0.5 0.5 1 1 1h6c0.5 0 1-0.5 1-1V8C18 7.5 17.5 7 17 7zM15 20h-2v-1h2V20zM16 18h-4V9h4V18z" fillRule="evenodd"/>
          </g>
        );
      case 'preview-link':
        return (
          <g>
            <path d="M17.586 9l-4.536 4.535a1 1 0 1 0 1.414 1.415L19 10.415V12a1 1 0 0 0 2 0V8a.997.997 0 0 0-1-1h-4a1 1 0 0 0 0 2h1.586zm3.121 11.707A.997.997 0 0 1 20 21H8a.997.997 0 0 1-1-1V8a.997.997 0 0 1 1-1h4a1 1 0 0 1 0 2H9v10h10v-3a1 1 0 0 1 2 0v4a.997.997 0 0 1-.293.707z"/>
          </g>
        );
      case 'redo':
        return (
          <g>
            <path d="M20.986 7l-1.78 1.78c-1.255-.967-2.835-1.501-4.575-1.527-3.845-.057-7.195 2.624-7.59 6.45C6.577 18.2 10.092 22 14.493 22c1.94 0 3.701-.736 5.031-1.945a.674.674 0 0 0 .032-.979l-1.184-1.175a.655.655 0 0 0-.901-.026c-.791.72-1.83 1.182-2.978 1.182-2.671 0-4.798-2.258-4.46-5.008.273-2.22 2.299-3.831 4.534-3.8a4.51 4.51 0 0 1 2.44.734l-2.014 2.014c0 .552.447.999.999.999h4.994a.998.998 0 0 0 1-1V8a1 1 0 0 0-1-1z" fillRule="evenodd"/>
          </g>
        );
      case 'reset':
        return (
          <g>
            <path d="M9.596 8.95a6.811 6.811 0 0 1 9.384-.15 6.661 6.661 0 0 1 .08 9.477 6.421 6.421 0 0 1-4.62 1.931c-.21 0-.42 0-.63-.017A6.084 6.084 0 0 1 9 17.151l5.45.005a3.274 3.274 0 0 0 3.26-3.3 3.418 3.418 0 0 0-3.41-3.314c-.83 0-1.626.321-2.224.89l1.764 1.755a.556.556 0 0 1-.4.948H7.56A.557.557 0 0 1 7 13.58V7.695a.557.557 0 0 1 .95-.393L9.596 8.95z" fillRule="evenodd"/>
          </g>
        );
      case 'resize':
        return (
          <g>
            <path d="M11.715 12.858l-2.292-2.291a1.885 1.885 0 0 1-1.381 1.524A1.041 1.041 0 0 1 7 11.049V7.431C7 7.193 7.193 7 7.431 7h3.618c.575 0 1.041.467 1.042 1.042a1.884 1.884 0 0 1-1.523 1.38l2.292 2.291 5.728 5.728a1.886 1.886 0 0 1 1.37-1.532c.575 0 1.041.467 1.042 1.042v3.618a.431.431 0 0 1-.431.431h-3.618a1.043 1.043 0 0 1-1.042-1.042 1.887 1.887 0 0 1 1.533-1.371l-5.728-5.728z" fillRule="evenodd"/>
          </g>
        );
      case 'save':
        return (
          <g>
            <path d="M18.95 9.051a1 1 0 1 0-1.414 1.414 5 5 0 1 1-7.07 0A1 1 0 0 0 9.05 9.051a7 7 0 1 0 9.9.001v-.001zm-5.378 8.235a.5.5 0 0 0 .857 0l2.117-3.528a.5.5 0 0 0-.429-.758H15V8a1 1 0 0 0-2 0v5h-1.117a.5.5 0 0 0-.428.758l2.117 3.528z" fillRule="evenodd"/>
          </g>
        );
      case 'setting':
        return (
          <g>
            <path d="M20.426 13.088l-1.383-.362a.874.874 0 0 1-.589-.514l-.043-.107a.871.871 0 0 1 .053-.779l.721-1.234a.766.766 0 0 0-.116-.917 6.682 6.682 0 0 0-.252-.253.768.768 0 0 0-.917-.116l-1.234.722a.877.877 0 0 1-.779.053l-.107-.044a.87.87 0 0 1-.513-.587l-.362-1.383a.767.767 0 0 0-.73-.567h-.358a.768.768 0 0 0-.73.567l-.362 1.383a.878.878 0 0 1-.513.589l-.107.044a.875.875 0 0 1-.778-.054l-1.234-.722a.769.769 0 0 0-.918.117c-.086.082-.17.166-.253.253a.766.766 0 0 0-.115.916l.721 1.234a.87.87 0 0 1 .053.779l-.043.106a.874.874 0 0 1-.589.514l-1.382.362a.766.766 0 0 0-.567.731v.357a.766.766 0 0 0 .567.731l1.383.362c.266.07.483.26.588.513l.043.107a.87.87 0 0 1-.053.779l-.721 1.233a.767.767 0 0 0 .115.917c.083.087.167.171.253.253a.77.77 0 0 0 .918.116l1.234-.721a.87.87 0 0 1 .779-.054l.107.044a.878.878 0 0 1 .513.589l.362 1.383a.77.77 0 0 0 .731.567h.356a.766.766 0 0 0 .73-.567l.362-1.383a.878.878 0 0 1 .515-.589l.107-.044a.875.875 0 0 1 .778.054l1.234.721c.297.17.672.123.917-.117.087-.082.171-.166.253-.253a.766.766 0 0 0 .116-.917l-.721-1.234a.874.874 0 0 1-.054-.779l.044-.107a.88.88 0 0 1 .589-.513l1.383-.362a.77.77 0 0 0 .567-.731v-.357a.772.772 0 0 0-.569-.724v-.005zm-6.43 3.9a2.986 2.986 0 1 1 2.985-2.986 3 3 0 0 1-2.985 2.987v-.001z" fillRule="evenodd"/>
          </g>
        );
      case 'sidebar':
        return (
          <g>
            <path d="M19 8L9 8C8.5 8 8 8.5 8 9L8 19C8 19.5 8.5 20 9 20L19 20C19.5 20 20 19.5 20 19L20 9C20 8.5 19.5 8 19 8L19 8ZM10 10L12 10 12 12 10 12 10 10 10 10ZM10 13L12 13 12 15 10 15 10 13 10 13ZM10 18L10 16 12 16 12 18 10 18 10 18ZM18 18L14 18 14 10 18 10 18 18 18 18Z" fillRule="evenodd"/>
          </g>
        );
      case 'tablet':
        return (
          <g>
            <path d="M19 7H9C8.5 7 8 7.5 8 8v12c0 0.5 0.5 1 1 1h10c0.5 0 1-0.5 1-1V8C20 7.5 19.5 7 19 7zM15 20h-2v-1h2V20zM18 18h-8V9h8V18z" fillRule="evenodd"/>
          </g>
        );
      case 'text-bold':
        return (
          <g>
            <path d="M17.337 13.535c.43-.591.662-1.304.663-2.035A3.51 3.51 0 0 0 14.5 8h-3c-.114 0-.221.023-.333.034A.933.933 0 0 0 11 8a.969.969 0 0 0-.53.174A.982.982 0 0 0 10 9v10c.005.338.182.65.47.827.156.108.34.168.53.173a.933.933 0 0 0 .167-.034c.112.011.219.034.333.034h4a3.51 3.51 0 0 0 3.5-3.5 3.494 3.494 0 0 0-1.667-2.965h.004zM16 11.5a1.5 1.5 0 0 1-1.5 1.5H12v-3h2.5a1.5 1.5 0 0 1 1.5 1.5zm1 5a1.5 1.5 0 0 1-1.5 1.5H12v-3h3.5a1.5 1.5 0 0 1 1.5 1.5z" fillRule="evenodd"/>
          </g>
        );
      case 'text-center':
        return (
          <g>
            <path d="M18 10h-8a1 1 0 1 1 0-2h8a1 1 0 0 1 0 2zm2 5H8a1 1 0 0 1 0-2h12a1 1 0 0 1 0 2zm-2 5h-8a1 1 0 0 1 0-2h8a1 1 0 0 1 0 2z" fillRule="evenodd"/>
          </g>
        );
      case 'text-italic':
        return (
          <g>
            <path d="M17 8h-5c-.6 0-1 .4-1 1s.4 1 1 1h1.3l-2.1 8H10c-.6 0-1 .4-1 1s.4 1 1 1h5c.6 0 1-.4 1-1s-.4-1-1-1h-1.7l2.1-8H17c.6 0 1-.4 1-1s-.4-1-1-1z" fillRule="evenodd"/>
          </g>
        );
      case 'text-justify':
        return (
          <g>
            <path d="M20 20H8a1 1 0 0 1 0-2h12a1 1 0 0 1 0 2zm0-10H8a1 1 0 1 1 0-2h12a1 1 0 0 1 0 2zM8 15a1 1 0 0 1 0-2h12a1 1 0 0 1 0 2H8z" fillRule="evenodd"/>
          </g>
        );
      case 'text-large':
        return (
          <g>
            <path d="M15.38 8.96a1.006 1.006 0 0 0-.65-.9.942.942 0 0 0-.28-.046c-.03 0-.06-.013-.09-.014-.03 0-.06.011-.09.014a.942.942 0 0 0-.28.045.991.991 0 0 0-.65.9l-4.28 9.622c-.187.52.075 1.093.59 1.291a.992.992 0 0 0 1.28-.592l1.19-2.272h4.47l1.2 2.272a.994.994 0 1 0 1.86-.7l-4.27-9.62zm-2.52 6.042l1.5-3.039 1.5 3.04h-3z" fillRule="evenodd"/>
          </g>
        );
      case 'text-left':
        return (
          <g>
            <path d="M16 20H8a1 1 0 0 1 0-2h8a1 1 0 0 1 0 2zm0-10H8a1 1 0 1 1 0-2h8a1 1 0 0 1 0 2zm4 5H8a1 1 0 0 1 0-2h12a1 1 0 0 1 0 2z" fillRule="evenodd"/>
          </g>
        );
      case 'text-link':
        return (
          <g>
            <path d="M20.726 7.274a.935.935 0 0 0-1.322 0l-1.849 1.85-.67-.67a3.06 3.06 0 0 0-4.226 0l-4.225 4.225a2.998 2.998 0 0 0 0 4.227l.669.67-1.85 1.85a.935.935 0 0 0 1.322 1.321l1.85-1.85.668.67a2.99 2.99 0 0 0 4.228 0l4.224-4.225a2.998 2.998 0 0 0 0-4.227l-.67-.67 1.85-1.85a.935.935 0 0 0 .001-1.321zm-2.498 5.162a1.123 1.123 0 0 1 0 1.584l-4.223 4.225a1.146 1.146 0 0 1-1.583 0l-.669-.67 1.581-1.582a.937.937 0 1 0-1.328-1.321l-1.582 1.581-.669-.669a1.122 1.122 0 0 1 0-1.584l4.225-4.224a1.12 1.12 0 0 1 1.583 0l.67.67-1.582 1.58a.935.935 0 0 0 1.322 1.322l1.581-1.582.674.67z" fillRule="evenodd"/>
          </g>
        );
      case 'text-quote':
        return (
          <g>
            <path d="M9.437 9.049a2 2 0 1 0 1.186 3.116c.264.574.394 1.2.381 1.833 0 2.116-1.118 3.998-1.999 3.998a1 1 0 1 0 0 2c2.392 0 3.999-3.1 3.999-5.998 0-2.709-1.48-4.698-3.567-4.949zm7.997 0a2 2 0 1 0 1.186 3.116c.263.574.393 1.2.38 1.833 0 2.116-1.117 3.998-1.998 3.998a1 1 0 1 0 0 2c2.392 0 3.998-3.1 3.998-5.998 0-2.709-1.48-4.698-3.566-4.949z" fillRule="evenodd"/>
          </g>
        );
      case 'text-right':
        return (
          <g>
            <path d="M20 15H8a1 1 0 0 1 0-2h12a1 1 0 0 1 0 2zm0-5h-8a1 1 0 0 1 0-2h8a1 1 0 0 1 0 2zm0 10h-8a1 1 0 0 1 0-2h8a1 1 0 0 1 0 2z" fillRule="evenodd"/>
          </g>
        );
      case 'text-small':
        return (
          <g>
            <path d="M14.168 10.639a.672.672 0 0 0-.424-.6.6.6 0 0 0-.186-.03c-.02 0-.038-.009-.057-.009a.521.521 0 0 0-.057.009.6.6 0 0 0-.186.03.672.672 0 0 0-.424.6l-2.792 6.448a.681.681 0 0 0 .384.865.645.645 0 0 0 .836-.4L12 15.997h3l.738 1.558a.646.646 0 0 0 .837.4.68.68 0 0 0 .383-.865l-2.791-6.451zm-1.645 4.315l.978-2.3.978 2.3h-1.956z" fillRule="evenodd"/>
          </g>
        );
      case 'text-underline':
        return (
          <g>
            <path d="M8 21h12c.6 0 1 .4 1 1s-.4 1-1 1H8c-.6 0-1-.4-1-1s.4-1 1-1zM10 8c.6 0 1 .4 1 1v6c0 1.7 1.3 3 3 3s3-1.3 3-3V9c0-.6.4-1 1-1s1 .4 1 1v6c0 2.8-2.2 5-5 5s-5-2.2-5-5V9c0-.6.4-1 1-1z" fillRule="evenodd"/>
          </g>
        );
      case 'text-underline-double':
        return (
          <g>
            <path d="M8.5 23h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1 0-1zM8.5 21h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1 0-1zM10 8a1 1 0 0 1 1 1v6a3 3 0 1 0 6 0V9a1 1 0 0 1 2 0v6a5 5 0 0 1-10 0V9a1 1 0 0 1 1-1z" fillRule="evenodd"/>
          </g>
        );
      case 'text-strikethrough':
        return (
          <g>
            <path d="M14.8 13c-.1 0-.2-.1-.3-.1C11.6 11.7 11 10 12.1 9c.9-.9 3.4-.4 3.7.5.2.5.7.8 1.3.6.5-.2.8-.7.6-1.3-.8-2.4-5.1-3.3-7-1.3-1.6 1.6-1.4 3.8.3 5.5H7c-.6 0-1 .4-1 1s.4 1 1 1h7.3c2.3 1.1 2.7 2.5 1.7 3.7-1.1 1.3-3.4 1.2-4.7-.8-.3-.5-.9-.6-1.4-.3-.5.3-.6.9-.3 1.4 2 3.2 5.9 3.3 7.9 1 1.3-1.5 1.3-3.4 0-5H21c.6 0 1-.4 1-1s-.4-1-1-1h-6.2z" fillRule="evenodd"/>
          </g>
        );
      case 'text-smallcaps':
        return (
          <g>
            <path d="M11 10h2c.6 0 1-.4 1-1s-.4-1-1-1H7c-.6 0-1 .4-1 1s.4 1 1 1h2v9c0 .6.4 1 1 1s1-.4 1-1v-9zm8 4v5c0 .6-.4 1-1 1s-1-.4-1-1v-5h-2c-.6 0-1-.4-1-1s.4-1 1-1h6c.6 0 1 .4 1 1s-.4 1-1 1h-2z" fillRule="evenodd"/>
          </g>
        );
      case 'text-uppercase':
        return (
          <g>
            <path d="M10 10h2c.6 0 1-.4 1-1s-.4-1-1-1H6c-.6 0-1 .4-1 1s.4 1 1 1h2v9c0 .6.4 1 1 1s1-.4 1-1v-9zm10 0v9c0 .6-.4 1-1 1s-1-.4-1-1v-9h-2c-.6 0-1-.4-1-1s.4-1 1-1h6c.6 0 1 .4 1 1s-.4 1-1 1h-2z" fillRule="evenodd"/>
          </g>
        );
      case 'text-h1':
        return (
          <g>
            <path d="M21 19.934h-1.32v-3.6l.01-.591.02-.645c-.146.15-.3.294-.46.428l-.71.574-.64-.79 2.01-1.594H21v6.218zM13 9v4H8V9a1 1 0 0 0-2 0v10a1 1 0 0 0 2 0v-4h5v4a1 1 0 0 0 2 0V9a1 1 0 0 0-2 0z" fillRule="evenodd"/>
          </g>
        );
      case 'text-h2':
        return (
          <g>
            <path d="M21.99 19.934h-4.36v-.914l1.57-1.577c.46-.474.76-.8.91-.985.123-.154.224-.325.3-.508.063-.154.097-.318.1-.484a.702.702 0 0 0-.21-.557.797.797 0 0 0-.55-.183c-.246 0-.49.057-.71.166a3.574 3.574 0 0 0-.71.471l-.72-.845a4.47 4.47 0 0 1 .77-.553c.209-.11.43-.194.66-.249.262-.06.53-.09.8-.087.355-.008.707.065 1.03.213.285.13.527.339.7.6.165.262.252.566.25.876.002.275-.049.549-.15.805-.122.277-.28.536-.47.772-.35.398-.725.774-1.12 1.127l-.81.752v.059h2.72v1.106-.005zM13 9v4H8V9a1 1 0 0 0-2 0v10a1 1 0 0 0 2 0v-4h5v4a1 1 0 0 0 2 0V9a1 1 0 0 0-2 0z" fillRule="evenodd"/>
          </g>
        );
      case 'text-h3':
        return (
          <g>
            <path d="M21.65 15.108c.01.364-.12.718-.36.991-.26.29-.608.487-.99.561v.026a1.97 1.97 0 0 1 1.14.456c.265.256.407.613.39.981.03.546-.214 1.07-.65 1.4a3.037 3.037 0 0 1-1.87.5 4.587 4.587 0 0 1-1.8-.336v-1.118c.256.127.524.228.8.3.28.075.57.114.86.115.338.025.676-.052.97-.221a.802.802 0 0 0 .31-.709.642.642 0 0 0-.36-.622 2.674 2.674 0 0 0-1.14-.183h-.48v-1.007h.49c.363.023.727-.042 1.06-.189a.686.686 0 0 0 .33-.648.715.715 0 0 0-.89-.706c-.21 0-.42.035-.62.1-.25.087-.49.206-.71.353l-.61-.906a3.42 3.42 0 0 1 2.04-.612 2.65 2.65 0 0 1 1.53.392c.36.24.572.649.56 1.082zM13 9v4H8V9a1 1 0 0 0-2 0v10a1 1 0 0 0 2 0v-4h5v4a1 1 0 0 0 2 0V9a1 1 0 0 0-2 0z" fillRule="evenodd"/>
          </g>
        );
      case 'text-h4':
        return (
          <g>
            <path d="M21.25 17.623v-3.907h-1.22l-2.74 4.013v.914h2.67v1.288h1.29v-1.288H22v-1.02h-.75zm-1.27-1.819c-.01.333-.02.589-.02.764v1.055h-1.5l1.14-1.722c.144-.217.271-.445.38-.681h.03c0 .055-.02.251-.03.584zM13 9v4H8V9a1 1 0 0 0-2 0v10a1 1 0 0 0 2 0v-4h5v4a1 1 0 0 0 2 0V9a1 1 0 0 0-2 0z" fillRule="evenodd"/>
          </g>
        );
      case 'text-h5':
        return (
          <g>
            <path d="M20.259 15.73c.621 0 1.115.174 1.483.523.368.349.552.826.552 1.433 0 .718-.221 1.27-.664 1.657-.442.387-1.075.58-1.898.58-.715 0-1.292-.116-1.731-.347v-1.173c.231.123.501.223.809.301.308.078.599.117.875.117.829 0 1.244-.34 1.244-1.02 0-.647-.429-.971-1.288-.971-.155 0-.327.015-.514.046-.188.031-.34.064-.457.099l-.541-.29.242-3.274h3.485v1.151H19.56l-.119 1.261.154-.031c.179-.041.4-.062.664-.062z" fillRule="evenodd"/>
            <path d="M13 9v4H8V9a1 1 0 0 0-2 0v10a1 1 0 0 0 2 0v-4h5v4a1 1 0 0 0 2 0V9a1 1 0 0 0-2 0z" fillRule="evenodd"/>
          </g>
        );
      case 'text-h6':
        return (
          <g>
            <path d="M22.047 16.275c-.325-.36-.775-.541-1.349-.541-.639 0-1.103.249-1.393.747h-.057c.026-.507.113-.898.259-1.173s.367-.483.661-.624.675-.211 1.14-.211c.255 0 .513.029.773.088v-1.085a4.374 4.374 0 0 0-.861-.066c-1.072 0-1.877.311-2.415.932S18 15.909 18 17.18c0 .595.096 1.103.288 1.525s.464.743.817.962.767.33 1.241.33c.686 0 1.222-.2 1.608-.6s.58-.943.58-1.628c.001-.635-.161-1.133-.487-1.494zm-1.059 2.345c-.155.195-.378.292-.668.292-.281 0-.513-.12-.697-.36s-.275-.535-.275-.883c0-.237.097-.445.292-.624s.43-.268.705-.268c.293 0 .512.09.657.27s.218.427.218.74c.001.36-.076.638-.232.833z" fillRule="evenodd"/>
            <path d="M13 9v4H8V9a1 1 0 0 0-2 0v10a1 1 0 0 0 2 0v-4h5v4a1 1 0 0 0 2 0V9a1 1 0 0 0-2 0z" fillRule="evenodd"/>
          </g>
        );
      case 'text':
        return (
          <g>
            <path d="M9.4 8h-.3c-.4.2-.5.5-.6 1l-4.4 9.7c-.2.5.1 1.1.6 1.3.5.2 1.1-.1 1.3-.6L7 17h5l1 2.3c.2.5.8.8 1.3.6.5-.2.8-.8.6-1.3L10.5 9c-.1-.5-.2-.8-.6-.9-.1-.1-.2-.1-.3-.1h-.2zM8 15l1.5-3 1.5 3H8zm15.5 0v-1c0-1.7-1.3-3-3-3h-3c-.5 0-1.2.4-1.2 1s.6 1 1.2 1h3c.6 0 1 .4 1 1h-3c-1.6 0-3 1.3-3 3 0 1.6 1.3 3 3 3h2c.8 0 1.4-.3 2-.9.1.5.5.9 1 .9s1-.5 1-1-.4-1-1-1v-3zm-2 2c0 .6-.4 1-1 1h-2c-.6 0-1-.5-1-1s.5-1 1-1h3v1z" fillRule="evenodd"/>
          </g>
        );
      case 'undent':
        return (
          <g>
            <path d="M10.24 16.022l-2.56-1.6a.5.5 0 0 1 0-.848l2.56-1.6a.5.5 0 0 1 .76.424v3.2a.5.5 0 0 1-.76.424zM20 10H8a1 1 0 1 1 0-2h12a1 1 0 0 1 0 2zm0 5h-6a1 1 0 0 1 0-2h6a1 1 0 0 1 0 2zm0 5H8a1 1 0 0 1 0-2h12a1 1 0 0 1 0 2z" fillRule="evenodd"/>
          </g>
        );
      case 'undo':
        return (
          <g>
            <path d="M14.355 7.253c-1.74.026-3.321.559-4.576 1.528L7.999 7A1 1 0 0 0 7 8v4.998c0 .552.447.999.999.999h4.995a1 1 0 0 0 .999-.999l-2.014-2.016a4.51 4.51 0 0 1 2.44-.733c2.235-.032 4.261 1.58 4.534 3.799.338 2.751-1.789 5.009-4.46 5.009-1.149 0-2.186-.462-2.978-1.182a.654.654 0 0 0-.902.026l-1.184 1.175a.674.674 0 0 0 .032.979A7.443 7.443 0 0 0 14.493 22c4.401 0 7.915-3.8 7.452-8.297-.395-3.826-3.745-6.507-7.59-6.45z" fillRule="evenodd"/>
          </g>
        );
      case 'zoom-in':
        return (
          <g>
            <path d="M15.508 7a5.511 5.511 0 0 0-5.505 5.5 5.426 5.426 0 0 0 .847 2.92l-3.737 2.67c-.389.39.32 1.74.708 2.13.39.39 1.764 1.06 2.153.67l2.646-3.71A5.5 5.5 0 1 0 15.508 7zm0 9.01a3.505 3.505 0 1 1 3.5-3.51 3.514 3.514 0 0 1-3.5 3.51zm.5-5.01h-1v1h-1v1h1v1h1v-1h1v-1h-1v-1z" fillRule="evenodd"/>
          </g>
        );
      case 'zoom-out':
        return (
          <g>
            <path d="M15.508 7a5.5 5.5 0 0 0-4.658 8.43L7.113 18.1c-.389.39.32 1.73.708 2.12.39.39 1.764 1.07 2.153.68l2.646-3.71A5.5 5.5 0 1 0 15.508 7zm0 9.01a3.505 3.505 0 1 1-.01-7.01 3.505 3.505 0 0 1 .01 7.01zm-1.5-3h3v-1h-3v1z" fillRule="evenodd"/>
          </g>
        );
      case 'lock':
        return (
          <g>
            <path d="M20 12C19.9 11.7 19.3 11 19 11L18 11C18 8.1 16.2 6 14 6 11.8 6 10 8.1 10 11L9 11C8.6 11 8.1 11.6 8 12L8 13 8 19 8 20C8.1 20.3 8.7 20.9 9 21L19 21C19.4 21 19.9 20.4 20 20L20 19 20 14 20 12 20 12ZM14 8C15.1 8 16 9.4 16 11.1L12 11.1C12 9.4 12.9 8 14 8L14 8ZM18 19L10 19 10 13 18 13 18 19 18 19Z" fillRule="evenodd"/>
            <path d="M14 18C14.6 18 15 17.6 15 17L15 15C15 14.4 14.6 14 14 14 13.4 14 13 14.4 13 15L13 15 13 17C13 17.6 13.4 18 14 18L14 18Z" fillRule="evenodd"/>
          </g>
        );
      case 'previous':
        return (
          <g>
            <path d="M15.2 14L18.7 10C19.1 9.6 19.1 9 18.7 8.6 18.3 8.2 17.7 8.2 17.3 8.6L13.3 13.1C13.1 13.3 13 13.7 13 14 12.9 14.3 13 14.6 13.3 14.9L17.3 19.4C17.7 19.8 18.3 19.8 18.7 19.4 19.1 19 19.1 18.4 18.7 18L15.2 14 15.2 14Z" fillRule="evenodd"/>
          </g>
        );
      case 'next':
        return (
          <g>
            <path d="M15.8 14L12.3 18C11.9 18.4 11.9 19 12.3 19.4 12.7 19.8 13.3 19.8 13.7 19.4L17.7 14.9C17.9 14.7 18 14.3 18 14 18.1 13.7 18 13.4 17.7 13.1L13.7 8.6C13.3 8.2 12.7 8.2 12.3 8.6 11.9 9 11.9 9.6 12.3 10L15.8 14 15.8 14Z" fillRule="evenodd"/>
          </g>
        );
      case 'sync':
        return (
          <g>
            <path d="M19.1 11.7L19.1 11.7c-0.3 0.3-0.4 0.6-0.3 0.9 0.1 0.4 0.2 0.9 0.2 1.3 0 2.8-2.2 5-5 5v2c3.9 0 7-3.1 7-7 0-0.6-0.1-1.3-0.2-1.8C20.6 11.4 19.6 11.2 19.1 11.7z" fillRule="evenodd"/>
            <path d="M14 9V7c-3.9 0-7 3.1-7 7 0 0.6 0.1 1.2 0.2 1.8 0.2 0.7 1.1 1 1.7 0.4l0 0c0.2-0.2 0.4-0.6 0.3-0.9C9.1 14.9 9 14.5 9 14 9 11.2 11.2 9 14 9z" fillRule="evenodd"/>
            <path d="M18.2 8.6c0.4-0.3 0.4-0.9 0-1.2l-3.4-2.8C14.4 4.3 14 4.4 14 5v6c0 0.6 0.4 0.7 0.8 0.4L18.2 8.6z" fillRule="evenodd"/>
            <path d="M9.8 19.4c-0.4 0.3-0.4 0.9 0 1.2l3.4 2.8c0.4 0.3 0.8 0.2 0.8-0.4v-6c0-0.5-0.4-0.7-0.8-0.4L9.8 19.4z" fillRule="evenodd"/>
          </g>
        );
      case 'portability':
        return (
          <g>
            <path d="M9.6 20.8c0.2 0.3 0.7 0.3 0.9 0l2.1-3.5c0.2-0.3 0-0.8-0.4-0.8H11V8c0-0.6-0.4-1-1-1C9.4 7 9 7.4 9 8v8.5H7.9c-0.4 0-0.6 0.4-0.4 0.8L9.6 20.8z" fillRule="evenodd"/>
            <path d="M18.4 7.2c-0.2-0.3-0.7-0.3-0.9 0l-2.1 3.5c-0.2 0.3 0 0.8 0.4 0.8H17V20c0 0.6 0.4 1 1 1 0.6 0 1-0.4 1-1v-8.5h1.1c0.4 0 0.6-0.4 0.4-0.8L18.4 7.2z" fillRule="evenodd"/>
          </g>
        );
      case 'background-color':
        return (
          <g>
            <path d="M19.4 14.6c0 0-1.5 3.1-1.5 4.4 0 0.9 0.7 1.6 1.5 1.6 0.8 0 1.5-0.7 1.5-1.6C20.9 17.6 19.4 14.6 19.4 14.6zM19.3 12.8l-4.8-4.8c-0.2-0.2-0.4-0.3-0.6-0.3 -0.3 0-0.5 0.1-0.7 0.3l-1.6 1.6L9.8 7.8c-0.4-0.4-1-0.4-1.4 0C8 8.1 8 8.8 8.4 9.1l1.8 1.8 -2.8 2.8c-0.4 0.4-0.4 1-0.1 1.4l4.6 4.6c0.2 0.2 0.4 0.3 0.6 0.3 0.3 0 0.5-0.1 0.7-0.3l6.1-6.1C19.5 13.4 19.5 13.1 19.3 12.8zM15.6 14.6c-1.7 1.7-4.5 1.7-6.2 0l2.1-2.1 1 1c0.4 0.4 1 0.4 1.4 0 0.4-0.4 0.4-1 0-1.4l-1-1 0.9-0.9 3.1 3.1L15.6 14.6z" fillRule="evenodd"/>
          </g>
        );
      case 'background-image':
        return (
          <g>
            <path d="M22.9 7.5c-0.1-0.3-0.5-0.6-0.8-0.6H5.9c-0.4 0-0.7 0.2-0.8 0.6C5.1 7.6 5 7.7 5 7.9v12.2c0 0.1 0 0.2 0.1 0.4 0.1 0.3 0.5 0.5 0.8 0.6h16.2c0.4 0 0.7-0.2 0.8-0.6 0-0.1 0.1-0.2 0.1-0.4V7.9C23 7.7 23 7.6 22.9 7.5zM21 18.9H7v-10h14V18.9z" fillRule="evenodd"/>
            <circle cx="10.5" cy="12.4" r="1.5"/>
            <polygon points="15 16.9 13 13.9 11 16.9 "/>
            <polygon points="17 10.9 15 16.9 19 16.9 "/>
          </g>
        );
      case 'background-video':
        return (
          <g>
            <path d="M22.9 7.5c-0.1-0.3-0.5-0.6-0.8-0.6H5.9c-0.4 0-0.7 0.2-0.8 0.6C5.1 7.6 5 7.7 5 7.9v12.2c0 0.1 0 0.2 0.1 0.4 0.1 0.3 0.5 0.5 0.8 0.6h16.2c0.4 0 0.7-0.2 0.8-0.6 0-0.1 0.1-0.2 0.1-0.4V7.9C23 7.7 23 7.6 22.9 7.5zM21 18.9H7v-10h14V18.9z" fillRule="evenodd"/>
            <polygon points="13 10.9 13 16.9 17 13.9 "/>
          </g>
        );
      case 'background-gradient':
        return (
          <g>
            <path d="M22.9 7.5c-0.1-0.3-0.5-0.6-0.8-0.6H5.9c-0.4 0-0.7 0.2-0.8 0.6C5.1 7.6 5 7.7 5 7.9v12.2c0 0.1 0 0.2 0.1 0.4 0.1 0.3 0.5 0.5 0.8 0.6h16.2c0.4 0 0.7-0.2 0.8-0.6 0-0.1 0.1-0.2 0.1-0.4V7.9C23 7.7 23 7.6 22.9 7.5zM21 18.9L7 8.9h14V18.9z" fillRule="evenodd"/>
          </g>
        );
      case 'swap':
        return (
          <g>
            <path d="M19 12h-3V9c0-0.5-0.5-1-1-1H8C7.5 8 7 8.5 7 9v7c0 0.5 0.5 1 1 1h3v3c0 0.5 0.5 1 1 1h7c0.5 0 1-0.5 1-1v-7C20 12.5 19.5 12 19 12zM18 19h-5v-2h2c0.5 0 1-0.5 1-1v-2h2V19z" fillRule="evenodd"/>
          </g>
        );
      case 'none':
        return (
          <g>
            <path d="M14 24c5.5 0 10-4.5 10-10S19.5 4 14 4 4 8.5 4 14s4.5 10 10 10zm0-17.5c4.1 0 7.5 3.4 7.5 7.5 0 1.5-.5 2.9-1.2 4.1L9.9 7.7c1.2-.7 2.6-1.2 4.1-1.2zM7.7 9.9l10.4 10.4c-1.2.8-2.6 1.2-4.1 1.2-4.1 0-7.5-3.4-7.5-7.5 0-1.5.5-2.9 1.2-4.1z"/>
          </g>
        )
      case 'animation-bounce':
        return (
          <g fillRule="evenodd">
            <circle cx="21.5" cy="8.5" r="3.5"/>
            <circle cx="16" cy="12" r="1.7"/>
            <circle cx="13" cy="15" r="1.2"/>
            <circle cx="11" cy="18" r="1"/>
            <circle cx="9" cy="22" r="1"/>
            <circle cx="7" cy="19" r="1"/>
            <circle cx="4" cy="17" r="1"/>
          </g>
        );
      case 'animation-fade':
        return (
          <g fillRule="evenodd">
            <circle cx="8.5" cy="19.5" r="1.5"/>
            <circle cx="8.5" cy="14.5" r="1.5"/>
            <circle cx="5" cy="12" r="1"/>
            <circle cx="5" cy="17" r="1"/>
            <circle cx="8.5" cy="9.5" r="1.5"/>
            <path d="M15.7 4c-.4 0-.8.1-1.2.3-.6.3-.5.7-1.5.7-1.1 0-2 .9-2 2s.9 2 2 2c.3 0 .5.2.5.5s-.2.5-.5.5c-1.1 0-2 .9-2 2s.9 2 2 2c.3 0 .5.2.5.5s-.2.5-.5.5c-1.1 0-2 .9-2 2s.9 2 2 2c.3 0 .5.2.5.5s-.2.5-.5.5c-1.1 0-2 .9-2 2s.9 2 2 2c1 0 .9.4 1.4.7.4.2.8.3 1.2.3 4.3-.4 8.3-5.3 8.3-10.5s-4-10-8.2-10.5z"/>
          </g>
        );
      case 'animation-flip':
        return (
          <g fillRule="evenodd">
            <path d="M22 2.4l-7 2.9V7h-2v-.8L7.6 8.7c-.4.2-.6.5-.6.9v8.7c0 .4.2.7.6.9l5.4 2.5V21h2v1.7l7 2.9c.5.2 1-.2 1-.7V3.1c0-.5-.5-.9-1-.7zM15 19h-2v-2h2v2zm0-4h-2v-2h2v2zm0-4h-2V9h2v2zM13 2h2v2.5h-2zM13 23.5h2V26h-2z"/>
          </g>
        );
      case 'animation-fold':
        return (
          <g fillRule="evenodd">
            <path d="M24 7h-4V3.4c0-.8-.6-1.4-1.3-1.4-.2 0-.5.1-.7.2l-6.5 3.9c-.9.6-1.5 1.6-1.5 2.6V23c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V9c0-1.1-.9-2-2-2zm-6 10.5c0 .2-.1.4-.3.5L12 21.5V8.7c0-.4.2-.7.5-.9L18 4.5v13zM6 7h2v2H6zM6 23h2v2H6zM2.6 7.1c-.1 0-.1.1-.2.1v.1l-.1.1-.1.1c-.1.1-.2.3-.2.5v1h2V7H3c-.1 0-.2 0-.4.1zM2 23v1c0 .4.3.8.7.9.1.1.2.1.3.1h1v-2H2zM2 11h2v2H2zM2 19h2v2H2zM2 15h2v2H2z"/>
          </g>
        );
      case 'animation-none':
        return (
          <g fillRule="evenodd">
            <path d="M14 24c5.5 0 10-4.5 10-10S19.5 4 14 4 4 8.5 4 14s4.5 10 10 10zm0-17.5c4.1 0 7.5 3.4 7.5 7.5 0 1.5-.5 2.9-1.2 4.1L9.9 7.7c1.2-.7 2.6-1.2 4.1-1.2zM7.7 9.9l10.4 10.4c-1.2.8-2.6 1.2-4.1 1.2-4.1 0-7.5-3.4-7.5-7.5 0-1.5.5-2.9 1.2-4.1z"/>
          </g>
        );
      case 'animation-roll':
        return (
          <g fillRule="evenodd">
            <path d="M18.8 5c-5.3-2.7-11.8.2-14 5.6-1.1 2.8-1 6 .2 8.8.4 1 3.9 6.5 5 3.6.5-1.2-1.3-2.2-1.9-3-.8-1.2-1.4-2.5-1.6-3.9-.4-2.7.5-5.5 2.4-7.4 4-4 11.6-2.5 12.6 3.4.4 2.7-.9 5.5-3.4 6.6-2.6 1.1-6 0-6.8-2.8-.7-2.4 1.2-5.7 4-4.8 1.1.3 2 1.5 1.5 2.7-.3.7-1.7 1.2-1.6.1 0-.3.2-.4.2-.8-.1-.4-.5-.6-.9-.6-1.1.1-1.6 1.6-1.3 2.5.3 1.2 1.5 1.9 2.7 1.9 2.9 0 4.2-3.4 3.1-5.7-1.2-2.6-4.6-3.4-7-2.2-2.6 1.3-3.8 4.4-3.1 7.2 1.6 5.9 9.3 6.8 13.1 2.5 3.8-4.2 1.9-11.1-3.2-13.7z"/>
          </g>
        );
      case 'animation-zoom':
        return (
          <g fillRule="evenodd">
            <path d="M23.7 4.3c-.1-.1-.2-.2-.3-.2-.1-.1-.3-.1-.4-.1h-5c-.6 0-1 .4-1 1s.4 1 1 1h2.6l-3.1 3.1c-.2-.1-.3-.1-.5-.1h-6c-.2 0-.3 0-.5.1L7.4 6H10c.6 0 1-.4 1-1s-.4-1-1-1H5c-.1 0-.3 0-.4.1-.2.1-.4.3-.5.5-.1.1-.1.3-.1.4v5c0 .6.4 1 1 1s1-.4 1-1V7.4l3.1 3.1c-.1.2-.1.3-.1.5v6c0 .2 0 .3.1.5L6 20.6V18c0-.6-.4-1-1-1s-1 .4-1 1v5c0 .1 0 .3.1.4.1.2.3.4.5.5.1.1.3.1.4.1h5c.6 0 1-.4 1-1s-.4-1-1-1H7.4l3.1-3.1c.2 0 .3.1.5.1h6c.2 0 .3 0 .5-.1l3.1 3.1H18c-.6 0-1 .4-1 1s.4 1 1 1h5c.1 0 .3 0 .4-.1.2-.1.4-.3.5-.5.1-.1.1-.3.1-.4v-5c0-.6-.4-1-1-1s-1 .4-1 1v2.6l-3.1-3.1c0-.2.1-.3.1-.5v-6c0-.2 0-.3-.1-.5L22 7.4V10c0 .6.4 1 1 1s1-.4 1-1V5c0-.1 0-.3-.1-.4 0-.1-.1-.2-.2-.3z"/>
          </g>
        );
      case 'animation-slide':
        return (
          <g fillRule="evenodd">
            <path d="M22 4h-5c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h5c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zM10 14c0 .6.4 1 1 1h.6L10 16.6c-.4.4-.4 1 0 1.4.4.4 1 .4 1.4 0l3.3-3.3c.2-.2.3-.5.3-.7s-.1-.5-.3-.7L11.4 10c-.4-.4-1-.4-1.4 0-.4.4-.4 1 0 1.4l1.6 1.6H11c-.6 0-1 .4-1 1z"/>
            <circle cx="7" cy="14" r="1.5"/>
            <circle cx="3" cy="14" r="1"/>
          </g>
        );
      case 'align-left':
        return (
          <g>
            <path d="M5 13h2v2H5zM5 21h2v2H5zM5 17h2v2H5zM5 9h2v2H5zM5 5h2v2H5z"/>
            <path d="M7.339 13.25a1 1 0 0 0 0 1.501l4.642 4.09a.6.6 0 0 0 1.007-.442V16h9a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1h-9V9.602a.601.601 0 0 0-1.002-.446L7.339 13.25z"/>
          </g>
        );
      case 'align-center':
        return (
          <g>
            <path d="M5 13h2v2H5zM5 9h2v2H5zM5 17h2v2H5zM5 5h2v2H5zM5 21h2v2H5zM21 9h2v2h-2zM21 5h2v2h-2zM21 13h2v2h-2zM15 8h-2a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1zM21 17h2v2h-2zM21 21h2v2h-2z"/>
          </g>
        );
      case 'align-right':
        return (
          <g>
            <path d="M21 21h2v2h-2zM21 17h2v2h-2zM21 9h2v2h-2zM21 5h2v2h-2zM21 13h2v2h-2z"/>
            <path d="M20.649 13.249l-4.642-4.09A.6.6 0 0 0 15 9.602V12H6a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h9v2.398a.601.601 0 0 0 1.002.446l4.647-4.094a1 1 0 0 0 0-1.501z"/>
          </g>
        );
      case 'click':
        return (
          <g fillRule="evenodd">
            <path d="M15 10V8c0-.6-.4-1-1-1s-1 .4-1 1v2c0 .3.2.6.4.8.2 0 .5.1.7.2.5-.1.9-.5.9-1zM20 15c.6 0 1-.4 1-1s-.4-1-1-1h-2c-.4 0-.7.2-.9.6l1.6 1.4H20zM10 13H8c-.6 0-1 .4-1 1s.4 1 1 1h2c.6 0 1-.4 1-1s-.4-1-1-1zM9.8 11.2c.2.2.5.3.7.3s.5-.1.7-.3c.4-.4.4-1 0-1.4l-1-1c-.4-.4-1-.4-1.4 0s-.4 1 0 1.4l1 1zM9.8 16.8l-1.1 1.1c-.4.4-.4 1 0 1.4.2.2.5.3.7.3s.5-.1.7-.3l.9-.9v-1.8c-.4-.2-.9-.1-1.2.2zM17.5 11.5c.3 0 .5-.1.7-.3l1-1c.4-.4.4-1 0-1.4s-1-.4-1.4 0l-1 1c-.4.4-.4 1 0 1.4.2.2.4.3.7.3zM13.4 12.9s-.1-.1-.2-.1-.3.1-.3.3v7.4c0 .3.3.6.6.6h.2l1.4-.6.8 2c.2.4.5.6.9.6.1 0 .3 0 .4-.1.5-.2.7-.8.5-1.3l-.8-2 1.9-.8c.3-.1.3-.5.1-.7l-5.5-5.3z" fillRule="evenodd"/>
          </g>
        );
      case 'hover':
        return (
          <g fillRule="evenodd">
            <path d="M17.1 18.1l-5.7-5.2c-.2-.1-.4 0-.4.2v7.4c0 .4.4.7.8.6l1.4-.6.8 2c.2.5.8.7 1.3.5.5-.2.7-.8.5-1.3l-.8-2 1.9-.8c.3-.3.4-.6.2-.8zM20 10c-.6 0-1-.4-1-1-.6 0-1-.4-1-1s.4-1 1-1c1.1 0 2 .9 2 2 0 .6-.4 1-1 1zM8 10c-.6 0-1-.4-1-1 0-1.1.9-2 2-2 .6 0 1 .4 1 1s-.4 1-1 1c0 .6-.4 1-1 1zM9 20c-1.1 0-2-.9-2-2 0-.6.4-1 1-1s1 .4 1 1c.6 0 1 .4 1 1s-.4 1-1 1zM19 20c-.6 0-1-.4-1-1s.4-1 1-1c0-.6.4-1 1-1s1 .4 1 1c0 1.1-.9 2-2 2zM14.8 9h-1.5c-.6 0-1-.4-1-1s.4-1 1-1h1.5c.6 0 1 .4 1 1s-.5 1-1 1zM20 15c-.6 0-1-.4-1-1v-1c0-.6.4-1 1-1s1 .4 1 1v1c0 .6-.4 1-1 1zM8 15c-.6 0-1-.4-1-1v-1c0-.6.4-1 1-1s1 .4 1 1v1c0 .6-.4 1-1 1z" fillRule="evenodd"/>
          </g>
        );
      case 'menu-expand':
        return (
          <g fillRule="evenodd">
            <path d="M14 20l-3-5h6zM14 8l3 5h-6z" fillRule="evenodd"/>
          </g>
        );
      case 'border-all':
        return (
          <g>
            <path d="M22 5H6a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1zm-2 15H8V8h12z"/>
          </g>
        );
      case 'border-top':
        return (
          <g>
            <path d="M17 21h2v2h-2zM5 9h2v2H5zM21 17h2v2h-2zM21 9h2v2h-2zM21 13h2v2h-2zM21 23h1a1 1 0 0 0 1-1v-1h-2zM5 17h2v2H5zM5 13h2v2H5zM13 21h2v2h-2zM9 21h2v2H9zM5 21v1a1 1 0 0 0 1 1h1v-2zM22 5H6a1 1 0 0 0-1 1v2h18V6a1 1 0 0 0-1-1z"/>
          </g>
        );
      case 'border-right':
        return (
          <g>
            <path d="M13 5h2v2h-2zM5 9h2v2H5zM9 5h2v2H9zM7 5H6a1 1 0 0 0-1 1v1h2zM5 13h2v2H5zM13 21h2v2h-2zM5 17h2v2H5zM9 21h2v2H9zM17 5h2v2h-2zM5 21v1a1 1 0 0 0 1 1h1v-2zM22 5h-2v18h2a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1zM17 21h2v2h-2z"/>
          </g>
        );
      case 'border-bottom':
        return (
          <g>
            <path d="M9 5h2v2H9zM7 20H5v2a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1v-2H7zM17 5h2v2h-2zM5 13h2v2H5zM5 9h2v2H5zM13 5h2v2h-2zM5 17h2v2H5zM21 9h2v2h-2zM21 17h2v2h-2zM22 5h-1v2h2V6a1 1 0 0 0-1-1zM21 13h2v2h-2zM7 5H6a1 1 0 0 0-1 1v1h2z"/>
          </g>
        );
      case 'border-left':
        return (
          <g>
            <path d="M22 5h-1v2h2V6a1 1 0 0 0-1-1zM9 21h2v2H9zM21 17h2v2h-2zM13 21h2v2h-2zM21 13h2v2h-2zM9 5h2v2H9zM17 21h2v2h-2zM17 5h2v2h-2zM21 9h2v2h-2zM8 7V5H6a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h2V7zM21 23h1a1 1 0 0 0 1-1v-1h-2zM13 5h2v2h-2z"/>
          </g>
        );
      case 'border-link':
        return (
          <g>
            <path d="M14.71 17.71a3 3 0 0 1-2.12-.88l-.71-.71a1 1 0 0 1 1.41-1.41l.71.71a1 1 0 0 0 1.41 0l5-4.95a1 1 0 0 0 0-1.41l-1.46-1.42a1 1 0 0 0-1.41 0L16.1 9.07a1 1 0 0 1-1.41-1.41l1.43-1.43a3.07 3.07 0 0 1 4.24 0l1.41 1.41a3 3 0 0 1 0 4.24l-5 4.95a3 3 0 0 1-2.06.88z"/>
            <path d="M9.76 22.66a3 3 0 0 1-2.12-.88l-1.42-1.42a3 3 0 0 1 0-4.24l5-4.95a3.07 3.07 0 0 1 4.24 0l.71.71a1 1 0 0 1-1.41 1.41l-.76-.7a1 1 0 0 0-1.41 0l-5 4.95a1 1 0 0 0 0 1.41L9 20.36a1 1 0 0 0 1.41 0L11.82 19a1 1 0 0 1 1.41 1.41l-1.36 1.36a3 3 0 0 1-2.11.89z"/>
          </g>
        );
      case 'window-undock':
        return (
          <g>
            <path d="M9 10H8a1 1 0 0 0-1 1v1a1 1 0 0 0 2 0 1 1 0 0 0 0-2zM13 19h-1a1 1 0 0 0 0 2h1a1 1 0 0 0 0-2zM9 19a1 1 0 0 0-2 0v1a1 1 0 0 0 1 1h1a1 1 0 0 0 0-2zM20 7h-8a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1zm-1 2v6h-6V9zM17 18a1 1 0 0 0-1 1 1 1 0 0 0 0 2h1a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1zM8 17a1 1 0 0 0 1-1v-1a1 1 0 0 0-2 0v1a1 1 0 0 0 1 1z"/>
          </g>
        );
      case 'chevron-right':
        return (
          <g>
            <path d="M13.38 19.48l4.6-4.6a1.25 1.25 0 0 0 0-1.77l-4.6-4.6a1.25 1.25 0 1 0-1.77 1.77L15.32 14l-3.71 3.71a1.25 1.25 0 1 0 1.77 1.77z" fillRule="evenodd"/>
          </g>
        );
      case 'chevron-left':
        return (
          <g>
            <path d="M14.62 8.52L10 13.12a1.25 1.25 0 0 0 0 1.77l4.6 4.6a1.25 1.25 0 0 0 1.77-1.77L12.68 14l3.71-3.71a1.25 1.25 0 1 0-1.77-1.77z" fillRule="evenodd"/>
          </g>
        );
      case 'chevron-up':
        return (
          <g>
            <path d="M20 14.62L15.38 10a1.25 1.25 0 0 0-1.77 0L9 14.62a1.25 1.25 0 0 0 1.77 1.77l3.71-3.71 3.71 3.71A1.25 1.25 0 1 0 20 14.62z" fillRule="evenodd"/>
          </g>
        );
      case 'chevron-down':
        return (
          <g>
            <path d="M19.98 11.616a1.25 1.25 0 0 0-1.768 0L14.5 15.328l-3.712-3.712a1.25 1.25 0 0 0-1.768 1.768l4.596 4.596a1.25 1.25 0 0 0 1.768 0l4.596-4.596a1.25 1.25 0 0 0 0-1.768z" fillRule="evenodd"/>
          </g>
        );
      case 'flip-horizontally':
        return (
          <g>
            <path d="M22 8.229a.995.995 0 0 0-.665.253L15 14.122l6.348 5.458A1 1 0 0 0 23 18.822V9.229a1 1 0 0 0-1-1zM7 11.458l2.963 2.638L7 16.643v-5.185M6 8.229a.996.996 0 0 0-1 1v9.592a1 1 0 0 0 1.652.758L13 14.122l-6.335-5.64A1 1 0 0 0 6 8.229zM13 5h2v2h-2zM13 9h2v2h-2zM13 13h2v2h-2zM13 17h2v2h-2zM13 21h2v2h-2z" fillRule="evenodd"/>
          </g>
        );
      case 'flip-vertically':
        return (
          <g>
            <path d="M13.878 15L8.42 21.348A1 1 0 0 0 9.178 23h9.592a1 1 0 0 0 .747-1.665L13.878 15zM16.542 7l-2.638 2.963L11.357 7h5.185m2.229-2H9.178a1 1 0 0 0-.758 1.652L13.878 13l5.64-6.335A1 1 0 0 0 18.771 5zM5 13h2v2H5zM9 13h2v2H9zM13 13h2v2h-2zM17 13h2v2h-2zM21 13h2v2h-2z" fillRule="evenodd"/>
          </g>
        );
      case 'eye':
        return (
          <g>
            <path d="M14 7.9A8.242 8.242 0 0 0 6 14a8.296 8.296 0 0 0 16 0 8.242 8.242 0 0 0-8-6.1zm0 10.2A6.249 6.249 0 0 1 8.091 14a6.308 6.308 0 0 1 11.818 0A6.249 6.249 0 0 1 14 18.1z" fillRule="evenodd"/>
            <circle cx="14" cy="14" r="2" fillRule="evenodd"/>
          </g>
        );
      case 'linked':
        return (
          <g>
            <path d="M8 14a1 1 0 0 1 0 2h-.5A2.5 2.5 0 0 1 5 13.5v-2A2.5 2.5 0 0 1 7.5 9h8a2.5 2.5 0 0 1 2.5 2.5v2a2.5 2.5 0 0 1-2.5 2.5H15a1 1 0 0 1 0-2h.5a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-.5-.5h-8a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 .5.5z" fillRule="evenodd"/>
            <path d="M20 14a1 1 0 0 1 0-2h.5a2.5 2.5 0 0 1 2.5 2.5v2a2.5 2.5 0 0 1-2.5 2.5h-8a2.5 2.5 0 0 1-2.5-2.5v-2a2.5 2.5 0 0 1 2.5-2.5h.5a1 1 0 0 1 0 2h-.5a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 .5.5h8a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-.5-.5z" fillRule="evenodd"/>
          </g>
        );
      case 'unlinked':
        return (
          <g>
            <path d="M16.75 9.14a1 1 0 0 1 .37 1.39l-4.5 8a1 1 0 0 1-1.37.37 1 1 0 0 1-.37-1.39l4.5-8a1 1 0 0 1 1.37-.37zM19.71 10H20a3 3 0 0 1 3 3v2a3 3 0 0 1-3 3h-4.81l1.13-2H20a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1h-1.42zM12.81 10l-1.13 2H8a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h1.42l-1.13 2H8a3 3 0 0 1-3-3v-2a3 3 0 0 1 3-3z" fillRule="evenodd"/>
          </g>
        );
      case 'expand-palette':
        return (
          <g>
            <circle cx="14" cy="20" r="2"/>
            <circle cx="14" cy="13" r="2"/>
            <circle cx="14" cy="6" r="2"/>
          </g>
        );
      case 'paint-brush':
        return (
          <g>
            <path d="M12.635 16.21c-.907-.787.159-3.439 2.38-5.92 2.22-2.482 4.756-3.855 5.663-3.068s-.16 3.44-2.38 5.922c-2.223 2.482-4.757 3.854-5.663 3.066zm.254 2.022a2.133 2.133 0 0 1-.7 1.718c-1.458 1.446-3.712 1.274-4.9.242a.84.84 0 0 1-.287-.576.844.844 0 0 1 .796-.89h.01c.077.001.553-.008.716-.513.009-.123.026-.242.054-.36a2.182 2.182 0 0 1 1.988-1.639c1.208-.073 2.247.83 2.323 2.018z" fillRule="evenodd"/>
          </g>
        );
      default :
        return false;
    }
  }

  render() {
    const {
      block,
      children,
      className,
      color,
      icon,
      iconSvg,
      size,
    } = this.props;

    // bail is no icon is defined.
    if (! icon && ! iconSvg) {
      return false;
    }

    let styles = {
      fill:     color,
      width:    size * 2,
      minWidth: size * 2,
      height:   size * 2,
      margin:   - (size - 8),
    };

    const iconName = icon ? `et-fb-icon--${icon}` : 'et-fb-icon--svg';

    let classes = classNames({
      'et-fb-icon':        true,
      'et-fb-icon--block': block,
    }, iconName, className);

    // Return early for displaying svg from defined path
    if (iconSvg) {
      return (
        <div className={classes} style={assign(styles, this.props.style)} dangerouslySetInnerHTML={{ __html: iconSvg }}/>
      );
    }

    const iconCode = this._renderGraphics();

    if (! iconCode) {
      styles = {};
    }

    // Display pre-defined svg icon
    return (
      <div className={classes} style={assign(styles, this.props.style)}>
        {iconCode
          ? <svg viewBox="0 0 28 28" preserveAspectRatio="xMidYMid meet" shapeRendering="geometricPrecision">{iconCode}</svg>
          : children}
      </div>
    );
  }
}


export default ETBuilderIcon;
