<?php
$g5plus_options = &G5Plus_Global::get_options();
$prefix = 'g5plus_';
$header_class = array('header-nav-wrapper', 'header-2');

// HEADER NAV CUSTOM STYLE
$header_custom_style = '';

// GET HEADER NAVIGATION SCHEME
$header_nav_scheme = rwmb_meta($prefix . 'header_nav_scheme');
if(is_404() && $g5plus_options['header_default_404']=='0'){
    $header_nav_scheme = 'header-light';
}

if ($header_nav_scheme == 'header-overlay') {
	$header_nav_scheme_color = rwmb_meta($prefix . 'header_nav_scheme_color');
	$header_nav_scheme_opacity = rwmb_meta($prefix . 'header_nav_scheme_opacity');
	if (($header_nav_scheme_color !== '') && ($header_nav_scheme_opacity != '')) {
		$header_custom_style = sprintf(' style="background-color:%s"', g5plus_hex2rgba($header_nav_scheme_color, $header_nav_scheme_opacity * 1.0 / 100));
	}
}
if (($header_nav_scheme === '') || ($header_nav_scheme == '-1')) {
	$header_nav_scheme = $g5plus_options['header_nav_scheme'];
	if ($header_nav_scheme == 'header-overlay') {
		$header_nav_scheme_color = $g5plus_options['header_nav_scheme_color'];
		$header_nav_scheme_opacity = $g5plus_options['header_nav_scheme_opacity'];
		if (($header_nav_scheme_color !== '') && ($header_nav_scheme_opacity != '')) {
			$header_custom_style = sprintf(' style="background-color:%s"', g5plus_hex2rgba($header_nav_scheme_color, $header_nav_scheme_opacity * 1.0 / 100));
		}
	}
}
$header_class[] = $header_nav_scheme;

// GET HEADER NAVIGATION BORDER TOP
$header_nav_border_top = rwmb_meta($prefix . 'header_nav_border_top');
if (($header_nav_border_top === '') || ($header_nav_border_top == '-1')) {
	$header_nav_border_top = $g5plus_options['header_nav_border_top'];
}
if(is_404()){
    $header_nav_border_top = $g5plus_options['header_404_nav_border_top'];
}
if ($header_nav_border_top != 'none') {
	$header_class[] = $header_nav_border_top;
}

// GET HEADER NAVIGATION BORDER BOTTOM
$header_nav_border_bottom = rwmb_meta($prefix . 'header_nav_border_bottom');
if (($header_nav_border_bottom === '') || ($header_nav_border_bottom == '-1')) {
	$header_nav_border_bottom = $g5plus_options['header_nav_border_bottom'];
}
if(is_404()){
    $header_nav_border_bottom = $g5plus_options['header_404_nav_border_bottom'];
}
if ($header_nav_border_bottom != 'none') {
	$header_class[] = $header_nav_border_bottom;
}

// GET HEADER STICKY
$header_sticky = rwmb_meta($prefix . 'header_sticky');
if (($header_sticky === '') || ($header_sticky == '-1')) {
	$header_sticky = $g5plus_options['header_sticky'];
}
if ($header_sticky == '1') {
	$header_class[] = 'header-sticky';

	$header_sticky_scheme = rwmb_meta($prefix . 'header_sticky_scheme');
	if (($header_sticky_scheme == '') || ($header_sticky_scheme == '-1')) {
		$header_sticky_scheme = isset($g5plus_options['header_sticky_scheme']) ? $g5plus_options['header_sticky_scheme'] : 'sticky-inherit';
	}
	$header_class[] = $header_sticky_scheme;
}

// GET HEADER CONTAINER LAYOUT
$header_container_layout = rwmb_meta($prefix . 'header_container_layout');
if (($header_container_layout == '') || ($header_container_layout == '-1')) {
	$header_container_layout = $g5plus_options['header_container_layout'];
}

// GET PAGE MENU
$page_menu_left = rwmb_meta($prefix . 'page_menu_left');
$page_menu_right = rwmb_meta($prefix . 'page_menu_right');
?>
<div class="<?php echo join(' ', $header_class) ?>"<?php echo sprintf('%s', $header_custom_style) ?>>
	<div class="<?php echo esc_attr($header_container_layout) ?>">
		<div class="header-container clearfix">
			<?php g5plus_get_template('header/header-logo' ); ?>
			<div class="header-nav-left">
				<?php if (has_nav_menu('left_menu')) : ?>
					<?php
					$arg_menu = array(
						'container' => '',
						'theme_location' => 'left_menu',
						'menu_class' => 'left-menu',
						'walker' => new XMenuWalker()
					);
					if (!empty($page_menu_left)) {
						$arg_menu['menu'] = $page_menu_left;
					}
					wp_nav_menu( $arg_menu );
					?>
				<?php endif; ?>
				<?php g5plus_get_template('header/header-customize-left' ); ?>
			</div>
			<div class="header-nav-right">
				<?php if (has_nav_menu('right_menu')) : ?>
					<?php
					$arg_menu = array(
						'container' => '',
						'theme_location' => 'right_menu',
						'menu_class' => 'right-menu',
						'walker' => new XMenuWalker()
					);
					if (!empty($page_menu_right)) {
						$arg_menu['menu'] = $page_menu_right;
					}
					wp_nav_menu( $arg_menu );
					?>
				<?php endif; ?>
				<?php g5plus_get_template('header/header-customize-right' ); ?>
			</div>
		</div>
	</div>
</div>