<?php
/**
 * Product quantity inputs
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version 	3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>
<label><?php esc_html_e("Qty","megastore")?>:</label>
<div class="quantity info-qty box-qty">
	<a class="qty-down quantity-minus" href="#"><i class="fa fa-minus"></i></a>
	<input type="text" data-step="<?php echo esc_attr( $step ); ?>" <?php if ( is_numeric( $min_value ) ) : ?>data-min="<?php echo esc_attr( $min_value ); ?>"<?php endif; ?> <?php if ( is_numeric( $max_value ) ) : ?>data-max="<?php echo esc_attr( $max_value ); ?>"<?php endif; ?> name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $input_value ); ?>" title="<?php echo esc_attr_x( 'Qty', 'Product quantity input tooltip', 'megastore' ) ?>" class="input-text text qty-val quantity" size="4" />
	<a class="qty-up quantity-plus" href="#"><i class="fa fa-plus"></i></a>
</div>