<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * Override this template by copying it to yourtheme/woocommerce/content-single-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version 	3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<?php
	/**
	 * woocommerce_before_single_product hook
	 *
	 * @hooked wc_print_notices - 10
	 */
	 do_action( 'woocommerce_before_single_product' );

	 if ( post_password_required() ) {
	 	echo get_the_password_form();
	 	return;
	 }
?>

<div id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php sv_product_main_detai()?>

	<meta itemprop="url" content="<?php the_permalink(); ?>" />
	<?php 
		$tabs = apply_filters( 'woocommerce_product_tabs', array() );
		// do_action( 'woocommerce_after_single_product_summary' );
	?>
	<!-- TAB PRODUCT -->
	<?php
	$tab_style = sv_get_value_by_id('product_tab_style');
	$thumb_style = sv_get_value_by_id('product_thumb_style');
	?>
	<div class="block block-tabs tab-left">
		<div class="block-head">
			<ul class="nav-tab">
				<?php 
					$num=0;
					foreach ( $tabs as $key => $tab ) : 
					$num++;
				?>
					<li class="<?php if($num==1){echo 'active';}?>" role="presentation">
						<a href="<?php echo esc_url( '#sv-'.$key ); ?>" aria-controls="sv-<?php echo esc_attr( $key ); ?>" role="tab" data-toggle="tab"><?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', esc_html( $tab['title'] ), $key ); ?></a>
					</li>
						
				<?php endforeach; ?>			
				<li role="presentation"><a href="<?php echo esc_url('#tags')?>" aria-controls="tags" role="tab" data-toggle="tab"><?php esc_html_e("Tags","megastore")?></a></li>
				<?php 
					$custom_tab = get_post_meta(get_the_ID(),'product_tab_data',true);
					if(!empty($custom_tab) && is_array($custom_tab)){
						foreach ($custom_tab as $c_tab) {
							$tab_slug = str_replace(' ', '-', $c_tab['title']);
							$tab_slug = strtolower($tab_slug);
							echo '<li role="presentation"><a href="'.esc_url('#sv-'.$tab_slug).'" aria-controls="sv-'.$tab_slug.'" role="tab" data-toggle="tab">'.$c_tab['title'].'</a></li>';
						}
					}
				?>
			</ul>
		</div>
		<!-- Tab panes -->
		<div class="block-inner">
			<div class="tab-container">
				<?php 
					$num=0;
					foreach ( $tabs as $key => $tab ) : 
					$num++;
				?>
					<div role="tabpanel" class="tab-panel <?php if($num==1){echo 'active';}?>" id="sv-<?php echo esc_attr( $key ); ?>">
						<div class="inner-tab-detail">
							<?php call_user_func( $tab['callback'], $key, $tab ); ?>
						</div>
					</div>
				<?php endforeach; ?>				
				<div role="tabpanel" class="tab-panel" id="tags">
					<div class="inner-tab-detail block-category-list clearfix">
						<?php 
							global $product,$post;
							$tag_count = sizeof( get_the_terms( get_the_ID(), 'product_tag' ) );
							echo wc_get_product_tag_list( $product->get_id(), ', ', _n( '', '', count( $product->get_tag_ids() ), 'megastore' ) . ' ', '' );
						?>
					</div>
				</div>
				<?php 
					if(!empty($custom_tab) && is_array($custom_tab)){
						foreach ($custom_tab as $c_tab) {
							$tab_slug = str_replace(' ', '-', $c_tab['title']);
							$tab_slug = strtolower($tab_slug);
							echo '<div role="tabpanel" class="tab-panel" id="sv-'.$tab_slug.'">
									<div class="inner-tab-detail">
										'.apply_filters('the_content',$c_tab['tab_content']).'
									</div>
								</div>';
						}
					}
				?>
			</div>
		</div>
	</div>
	<?php
	sv_single_relate_product();
	sv_single_lastest_product();
	sv_single_upsell_product();
	?>
</div>
<?php do_action( 'woocommerce_after_single_product' ); ?>
