<?php
/**
 * The template for displaying product content within loops.
 *
 * Override this template by copying it to yourtheme/woocommerce/content-product.php
 *
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product;
// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) ) {
	$woocommerce_loop['loop'] = 0;
}

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) ) {
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
}

// Ensure visibility
if ( ! $product || ! $product->is_visible() ) {
	return;
}

// Increase loop count
$woocommerce_loop['loop']++;
?>
<?php
	$type = 'grid';
    if(isset($_GET['type'])){
        $type = $_GET['type'];
    }
?>
<?php if($type == 'list'){?>
	<li class="item-product col-xs-12 col-sm-12 col-md-6">
		<?php 
		echo 	'<div class="product-container">
					<div class="inner row">
						<div class="product-left col-sm-6 col-xs-6">
							'.sv_product_thumb_hover(array(330,330)).'
						</div>
						<div class="product-right col-sm-6 col-xs-6">
							<div class="product-name">
								<a href="'.esc_url(get_the_permalink()).'" title="'.get_the_title().'">'.get_the_title().'</a>
							</div>
							<div class="price-box">
								'.$product->get_price_html().'
							</div>
							'.sv_get_rating_html().'
                            <div class="desc">'.get_the_excerpt().'</div>                            
                    		'.sv_product_link().'
						</div>
					</div>
				</div>';
		?>		
	</li>
<?php }
	else{
		$b_col = 12;$col = 3;$size = array(330,330);
		$col_sm = 6;
		$col_option = $woocommerce_loop['columns'];
		if(!empty($col_option)) $col = $b_col/(int)$col_option;		
		if($col_option == 1){
			$size = 'full';
			$col_sm = 12;
		}
	?>
	<li class="item-product col-xs-6 col-sm-<?php echo esc_attr($col_sm)?> col-md-<?php echo esc_attr($col)?>">
	<?php 
		echo 	'<div class="product-container">
			<div class="inner">
				<div class="product-left">
					'.sv_product_thumb_hover($size).'
				</div>
				<div class="product-right">
					<div class="product-name">
						<a href="'.esc_url(get_the_permalink()).'" title="'.get_the_title().'">'.get_the_title().'</a>
					</div>
					<div class="price-box">
						'.$product->get_price_html().'
					</div>
					'.sv_get_rating_html().'
                    '.sv_product_link().'
				</div>
			</div>
		</div>';
	?>
	</li>
<?php }?>