<?php
$data = '';
if (get_post_meta(get_the_ID(), 'format_media', true)) {
    $media_url = get_post_meta(get_the_ID(), 'format_media', true);
    $data .= '<div class="audio">' . sv_remove_w3c(wp_oembed_get($media_url, array('height' => '176'))) . '</div>';
}
?>
<h2 class="page-title">
    <?php the_title()?>
    <?php echo (is_sticky()) ? '<i class="fa fa-thumb-tack"></i>':''?>
</h2>
<div class="page-content clearfix">
    <article class="entry-detail">
        <?php sv_display_metabox();?>
        <?php if(!empty($data)) echo balanceTags($data);?>
        <div class="entry-content clearfix">
            <?php the_content();?>
        </div>
        <div class="entry-tags">
            <span><i class="fa fa-tags" aria-hidden="true"></i> <?php esc_html_e("Tags:",'megastore');?></span>
            <?php $tags = get_the_tag_list(' ',', ',' ');?>
            <?php if($tags) echo balanceTags($tags); else esc_html_e("No Tag",'megastore');?>
        </div>
    </article>
</div>