<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */
if(!class_exists('SV_Recent_Comment_Widget'))
{
    class SV_Recent_Comment_Widget extends WP_Widget {


        protected $default=array();

        static function _init()
        {
            add_action( 'widgets_init', array(__CLASS__,'_add_widget') );
        }

        static function _add_widget()
        {
            register_widget( 'SV_Recent_Comment_Widget' );
        }

        function __construct() {
            // Instantiate the parent object
            parent::__construct( false, esc_html__('SV Recent Comments','megastore'),
                array( 'description' => esc_html__( 'Get Recent Comments', 'megastore' ), ));

            $this->default=array(
                'title'             => esc_html__('Recent Comments','megastore'),
                'number'    => 3,
            );
        }



        function widget( $args, $instance ) {
            // Widget output
            echo balancetags($args['before_widget']);
            if ( ! empty( $instance['title'] ) ) {
               echo balancetags($args['before_title']) . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
            }
            $instance = wp_parse_args($instance,$this->default);
            extract($instance);
            $comments = get_comments( apply_filters( 'widget_comments_args', array(
                'number'      => $number,
                'status'      => 'approve',
                'post_status' => 'publish'
            ) ) );
            echo    '<ul class="recent-comment-list">';
            if ( is_array( $comments ) && $comments ) {
                $post_ids = array_unique( wp_list_pluck( $comments, 'comment_post_ID' ) );
                _prime_post_caches( $post_ids, strpos( get_option( 'permalink_structure' ), '%category%' ), false );
     
                foreach ( $comments as $comment ) {
                    echo    '<li>
                                <h5><a href="' . esc_url( get_comment_link( $comment ) ) . '">' . get_the_title( $comment->comment_post_ID ) . '</a></h5>
                                <div class="comment">
                                    "'.sv_substr(get_comment_text( $comment->comment_ID ),0,70).'..."
                                </div>
                                <div class="author">'.esc_html__("Posted by","megastore").' ' . get_comment_author_link( $comment ) . '</div>
                            </li>';
                }
            }
            echo        '</ul>';
            wp_reset_postdata();
            echo balancetags($args['after_widget']);
        }

        function update( $new_instance, $old_instance ) {

            // Save widget options
            $instance=array();
            $instance=wp_parse_args($instance,$this->default);
            $new_instance=wp_parse_args($new_instance,$instance);

            return $new_instance;
        }

        function form( $instance ) {
            // Output admin widget options form

            $instance=wp_parse_args($instance,$this->default);

            extract($instance);

            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:' ,'megastore'); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"><?php esc_html_e( 'Number:' ,'megastore'); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number' )); ?>" type="text" value="<?php echo esc_attr( $number ); ?>">
            </p>
        <?php
        }
    }

    SV_Recent_Comment_Widget::_init();

}
