<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */
if(!class_exists('SV_ListPostsWidget'))
{
    class SV_ListPostsWidget extends WP_Widget {


        protected $default=array();

        static function _init()
        {
            add_action( 'widgets_init', array(__CLASS__,'_add_widget') );
        }

        static function _add_widget()
        {
            register_widget( 'SV_ListPostsWidget' );
        }

        function __construct() {
            // Instantiate the parent object
            parent::__construct( false, esc_html__('SV List Posts','megastore'),
                array( 'description' => esc_html__( 'Lists Posts', 'megastore' ), ));

            $this->default=array(
                'title'             => esc_html__('List Posts','megastore'),
                'posts_per_page'    => 6,
                'type_post'         => '',
                'category'          => array(),
                'order'             => 'desc',
                'order_by'          => 'ID',
            );
        }



        function widget( $args, $instance ) {
            // Widget output
            echo balancetags($args['before_widget']);
            if ( ! empty( $instance['title'] ) ) {
               echo balancetags($args['before_title']) . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
            }
            $instance = wp_parse_args($instance,$this->default);
            extract($instance);
            $args_post = array(
                'post_type'         => 'post',
                'posts_per_page'    => $posts_per_page,
                'orderby'           => $order_by,
                'order'             => $order,
            );
            if($order_by == 'post_views'){
                $args_post['orderby'] = 'meta_value_num';
                $args_post['meta_key'] = 'post_views';
            }
            if($order_by == 'time_update'){
                $args_post['orderby'] = 'meta_value';
                $args_post['meta_key'] = 'time_update';
            }
            if($order_by == '_post_like_count'){
                $args_post['orderby'] = 'meta_value_num';
                $args_post['meta_key'] = '_post_like_count';
            }
            if(!empty($category)) {
                $args_post['tax_query']['relation'] = 'AND';
                $args_post['tax_query'][]=array(
                    'taxonomy'  => 'category',
                    'field'     => 'slug',
                    'terms'     => $category
                );
            }
            if(!empty($type_post)) {
                if($type_post == 'trending'){
                    $args_post['meta_query']['relation'] = 'OR';
                    $args_post['meta_query'][] = array(
                            'key'     => 'trending_post',
                            'value'   => 'on',
                            'compare' => '=',
                        );
                }
                if($type_post == 'featured'){
                    $args_post['meta_query']['relation'] = 'OR';
                    $args_post['meta_query'][] = array(
                            'key'     => 'featured_post',
                            'value'   => 'on',
                            'compare' => '=',
                        );
                }
            }

            $query = new WP_Query($args_post);
            $count = 1;
            $count_query = $query->post_count;
            echo    '<ul class="list-posts-widget">';
            if($query->have_posts()) {
                while($query->have_posts()) {
                    $query->the_post();
                    echo    '<li>
                                <div class="post-thumb">
                                    <a href="'.esc_url(get_the_permalink()).'">'.get_the_post_thumbnail(get_the_ID(),array(230,110)).'</a>
                                </div>
                                <div class="post-info">
                                    <h5 class="entry_title"><a href="'.esc_url(get_the_permalink()).'">'.get_the_title().'</a></h5>
                                    <div class="post-meta">
                                        <span class="date"><i class="fa fa-calendar"></i> '.get_the_date('Y-m-d').'</span>
                                        <span class="comment-count">
                                            <i class="fa fa-comment-o"></i> '.get_comments_number().'
                                        </span>
                                    </div>
                                </div>
                            </li>';
                }
            }
            echo        '</ul>';
            wp_reset_postdata();
            echo balancetags($args['after_widget']);
        }

        function update( $new_instance, $old_instance ) {

            // Save widget options
            $instance=array();
            $instance=wp_parse_args($instance,$this->default);
            $new_instance=wp_parse_args($new_instance,$instance);

            return $new_instance;
        }

        function form( $instance ) {
            // Output admin widget options form

            $instance=wp_parse_args($instance,$this->default);

            extract($instance);

            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:' ,'megastore'); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'posts_per_page' )); ?>"><?php esc_html_e( 'Post Number:' ,'megastore'); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'posts_per_page' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'posts_per_page' )); ?>" type="text" value="<?php echo esc_attr( $posts_per_page ); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'type_post' )); ?>"><?php esc_html_e( 'Type post:' ,'megastore'); ?></label>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'type_post' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'type_post' )); ?>">
                    <option <?php selected('',$type_post) ?> value=""><?php esc_html_e("Default","megastore")?></option>
                    <option <?php selected('trending',$type_post) ?> value="trending"><?php esc_html_e("Trending","megastore")?></option>
                    <option <?php selected('featured',$type_post) ?> value="featured"><?php esc_html_e("Featured","megastore")?></option>
                </select>
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'order_by' )); ?>"><?php esc_html_e( 'Order By:' ,'megastore'); ?></label>

                <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'order_by' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'order_by' )); ?>">
                    <?php echo sv_get_order_list($order_by,array('post_view'=>esc_html__('Post View','megastore')),'option');?>
                </select>
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'order' )); ?>"><?php esc_html_e( 'Order:' ,'megastore'); ?></label>

                <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'order' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'order' )); ?>">
                    <option <?php selected('asc',$order) ?> value="asc"><?php esc_html_e("ASC","megastore")?></option>
                    <option <?php selected('desc',$order) ?> value="desc"><?php esc_html_e("DESC","megastore")?></option>
                </select>
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'category' )); ?>"><?php esc_html_e( 'Category:' ,'megastore'); ?></label></br>

                <?php
                $cats = sv_list_taxonomy('category',false);
                if(!empty($cats)){
                    foreach($cats as $name => $slug){
                        if(in_array($slug, $category)) $checked = 'checked="checked"';
                        else $checked = '';
                        echo '<input '.$checked.' id="'.esc_attr($this->get_field_id( 'category' )).'" type="checkbox" name="'.esc_attr($this->get_field_name( 'category' )).'[]" value="'.$slug.'"><span>'.$name.'</span>';
                    }
                }
                else echo esc_html__("No any attribute.","megastore");
                ?>
            </p>


        <?php
        }
    }

    SV_ListPostsWidget::_init();

}
