<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_search_form'))
{
    function sv_vc_search_form($attr)
    {
        $html = $label_sm = '';
        extract(shortcode_atts(array(
            'style' => 'home1',
            'cats' => '',
            'placeholder' => '',
        ),$attr));
        ob_start();
        $search_val = get_search_query();
        switch ($style) {
            case 'option6':
                if(empty($search_val)) $search_val = $placeholder;
                ?>
                <form class="search-form6" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
                    <input name="s" type="text" onblur="if (this.value=='') this.value = this.defaultValue" onfocus="if (this.value==this.defaultValue) this.value = ''" value="<?php echo esc_attr($search_val);?>">
                    <input type="submit" value="">
                    <input type="hidden" name="post_type" value="product" />
                </form>
                <?php
                break;
            
            default:
                ?>
                <div class="<?php echo esc_attr($style)?>">
                    <div class="advanced-search box-radius">
                        <form class="form-inline" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
                            <div class="form-group search-category">
                                <select id="category-select" class="search-category-select" name="product_cat">
                                    <option value=""><?php esc_html_e("All Categories","megastore")?></option>
                                    <?php 
                                        if($cats == 'parent') $product_cat_list = get_terms(array( 'taxonomy' => 'product_cat', 'parent' => 0 ));
                                        else $product_cat_list = get_terms('product_cat');
                                        if(is_array($product_cat_list) && !empty($product_cat_list)){
                                            foreach ($product_cat_list as $cat) {
                                                echo '<option value="'.$cat->slug.'">'.$cat->name.'</option>';
                                            }
                                        }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group search-input">
                                <input name="s" type="text" value="<?php echo esc_attr($search_val);?>" placeholder="<?php echo esc_attr($placeholder)?>">
                            </div>
                            <input type="hidden" name="post_type" value="product" />
                            <input class="cat-value" type="hidden" name="product_cat" value="" />
                            <button type="submit" class="btn-search"><i class="fa fa-search"></i></button>
                        </form>
                    </div>
                </div>
                <?php
                break;
        }        
        $html .=    ob_get_clean();
        return $html;
    }
}

stp_reg_shortcode('sv_search_form','sv_vc_search_form');

vc_map( array(
    "name"      => esc_html__("SV Search Form", 'megastore'),
    "base"      => "sv_search_form",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Style",'megastore'),
            "param_name" => "style",
            "value"     => array(
                esc_html__("Home 1",'megastore')   => 'home1',
                esc_html__("Home 3",'megastore')   => 'option3',
                esc_html__("Home 6",'megastore')   => 'option6',
                )
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Categories",'megastore'),
            "param_name" => "cats",
            "value"     => array(
                esc_html__("All Categories",'megastore')   => '',
                esc_html__("Only Parent Categories",'megastore')   => 'parent',
                )
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "heading" => esc_html__("Place holder input",'megastore'),
            "param_name" => "placeholder",
        ),
    )
));