<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 05/09/15
 * Time: 10:00 AM
 */
if(class_exists("woocommerce")){
    if(!function_exists('sv_vc_product_tab'))
    {
        function sv_vc_product_tab($attr, $content = false)
        {
            $html = $el_class = $html_wl = $html_cp = '';
            extract(shortcode_atts(array(
                'tabs'              => '',
                'number'            => '',
                'cats'          => '',
                'order_by'      => 'date',
                'order'         => 'DESC',
                'item'          => '1',
                'item_res'      => '',
                'autoplay'      => 'false',
                'loop'          => 'true',
                'size'          => '',
            ),$attr)); 
            $args=array(
                'post_type'         => 'product',
                'posts_per_page'    => $number,
                'orderby'           => $order_by,
                'order'             => $order
            );
            if(!empty($cats)) {
                $custom_list = explode(",",$cats);
                $args['tax_query'][]=array(
                    'taxonomy'=>'product_cat',
                    'field'=>'slug',
                    'terms'=> $custom_list
                );
            }
            $data_res = '';$data_margin = 0;
            if($item > 1) $data_margin = 30;
            if(!empty($item_res)){
                $item_data = explode(',', $item_res);
                if(is_array($item_data)){
                    $count_data = 1;
                    foreach ($item_data as $data_device) {
                        $data_device = explode(':', $data_device);
                        if(is_array($data_device)){
                            $data_res .= '"'.$data_device[0].'":{"items":'.$data_device[1].'}';
                            if($count_data < count($item_data)) $data_res .= ',';                        
                            $count_data++;
                        }
                    }
                }
                $data_res = "'".'{'.$data_res.'}'."'";
            }
            else{
                $data_res = "'".'{"0":{"items":1},"600":{"items":1},"1000":{"items":'.$item.'}}'."'";
                if($item >= 2) $data_res = "'".'{"0":{"items":1},"568":{"items":2},"1000":{"items":'.$item.'}}'."'";
                if($item >= 4) $data_res = "'".'{"0":{"items":1},"568":{"items":2},"1000":{"items":3},"1170":{"items":'.$item.'}}'."'";
                if($item >= 5) $data_res = "'".'{"0":{"items":1},"568":{"items":2},"600":{"items":3},"1024":{"items":4},"1100":{"items":'.$item.'}}'."'";
            }
            if(!empty($size)) $size = explode('x', $size);
            else $size = array(330,330);
            $pre = rand(1,100);
            if(!empty($tabs)){
                $tabs = explode(',', $tabs);
                $tab_html = $content_html = '';
                foreach ($tabs as $key => $tab) {
                    switch ($tab) {
                        case 'bestsell':
                            $tab_title =    esc_html__("Popular","megastore");
                            $args['meta_key'] = 'total_sales';
                            $args['orderby'] = 'meta_value_num';
                            break;

                        case 'toprate':
                            $tab_title =    esc_html__("Most review","megastore");
                            unset($args['meta_key']);
                            $args['meta_key'] = '_wc_average_rating';
                            $args['orderby'] = 'meta_value_num';
                            $args['meta_query'] = WC()->query->get_meta_query();
                            $args['tax_query'][] = WC()->query->get_tax_query();
                            break;
                        
                        case 'mostview':
                            $tab_title =    esc_html__("Most View","megastore");
                            unset($args['no_found_rows']);
                            unset($args['meta_query']);
                            unset($args['tax_query']);
                            if(!empty($cats)) {
                                $custom_list = explode(",",$cats);
                                $args['tax_query'][]=array(
                                    'taxonomy'=>'product_cat',
                                    'field'=>'slug',
                                    'terms'=> $custom_list
                                );
                            }
                            $args['meta_key'] = 'post_views';
                            $args['orderby'] = 'meta_value_num';
                            break;

                        case 'featured':
                            $tab_title =    esc_html__("Featured","megastore");
                            $args['orderby'] = $order_by;
                            $args['tax_query'][] =  array(
                                        'taxonomy' => 'product_visibility',
                                        'field'    => 'name',
                                        'terms'    => 'featured',
                                        'operator' => 'IN',
                                    );
                            break;

                        case 'trendding':
                            unset($args['meta_key']);
                            unset($args['meta_value']);
                            $tab_title =    esc_html__("Tredding","megastore");
                            $args['meta_query'][] = array(
                                'key'     => 'trending_product',
                                'value'   => 'on',
                                'compare' => '=',
                            );
                            break;
                        
                        case 'onsale':
                            $tab_title =    esc_html__("On sale","megastore");
                            unset($args['meta_query']);
                            unset($args['meta_key']);
                            unset($args['meta_value']);
                            $args['meta_query']['relation']= 'OR';
                            $args['meta_query'][]=array(
                                'key'   => '_sale_price',
                                'value' => 0,
                                'compare' => '>',                
                                'type'          => 'numeric'
                            );
                            $args['meta_query'][]=array(
                                'key'   => '_min_variation_sale_price',
                                'value' => 0,
                                'compare' => '>',                
                                'type'          => 'numeric'
                            );
                            break;
                        
                        default:
                            $tab_title =    esc_html__("New arrivals","megastore");
                            $args['orderby'] = 'date';
                            break;
                    }
                    if($key == 0) $f_class = 'active';
                    else $f_class = '';
                    $tab_html .=    '<li class="'.$f_class.'"><a href="'.esc_url('#'.$pre.$tab).'" data-toggle="tab">'.$tab_title.'</a></li>';
                    $product_query = new WP_Query($args);
                    $content_html .=    '<div id="'.$pre.$tab.'" class="tab-panel '.$f_class.'">
                                            <div class="product-tab-content kt-owl-carousel kt-owl-option6" data-items="'.$item.'" data-autoplay="'.$autoplay.'" data-margin="'.$data_margin.'" data-loop="'.$loop.'"  data-nav="true" data-responsive='.$data_res.'>';
                    if($product_query->have_posts()) {
                        while($product_query->have_posts()) {
                            $product_query->the_post();
                            global $product;
                            $content_html .=    '<div class="item-product6">
                                                    '.sv_product_thumb_hover2($size).'
                                                    <div class="product-info">
                                                        <div class="product-price price-box">
                                                            '.$product->get_price_html().'
                                                        </div>
                                                        <h3 class="product-title"><a href="'.esc_url(get_the_permalink()).'" title="'.get_the_title().'">'.get_the_title().'</a></h3>
                                                        <p class="product-desc">'.sv_substr(get_the_excerpt(),0,70).'</p>
                                                        '.sv_product_link('style2').'
                                                    </div>
                                                </div>';
                        }
                    }
                    $content_html .=        '</div>
                                        </div>';
                }
                $html .=    '<div class="product-tab6">
                                <div class="product-tab-header">
                                    <ul class="list-inline">
                                        '.$tab_html.'
                                    </ul>
                                </div>
                                <div class="tab-container">
                                    '.$content_html.'
                                </div>
                            </div>';
            }
            wp_reset_postdata();
            return $html;
        }
    }

    stp_reg_shortcode('sv_product_tab','sv_vc_product_tab');
    add_action( 'vc_build_admin_page','sv_add_product_tab',10,100 );
    if ( ! function_exists( 'sv_add_product_tab' ) ) {
        function sv_add_product_tab(){
            vc_map( array(
                "name"      => esc_html__("SV Product Tab", 'megastore'),
                "base"      => "sv_product_tab",
                "icon"      => "icon-st",
                "category"  => '7Up-theme',
                "params"    => array(                    
                    array(
                        "type" => "textfield",
                        "heading" => esc_html__("Number",'megastore'),
                        "param_name" => "number",
                    ),
                    array(
                        'holder'     => 'div',
                        'heading'     => esc_html__( 'Product Categories', 'megastore' ),
                        'type'        => 'checkbox',
                        'param_name'  => 'cats',
                        'value'       => sv_list_taxonomy('product_cat',false)
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => esc_html__( 'Order By', 'megastore' ),
                        'value' => sv_get_order_list(),
                        'param_name' => 'orderby',
                        'description' => esc_html__( 'Select Orderby Type ', 'megastore' ),
                        'edit_field_class'=>'vc_col-sm-6 vc_column',
                    ),
                    array(
                        'heading'     => esc_html__( 'Order', 'megastore' ),
                        'type'        => 'dropdown',
                        'param_name'  => 'order',
                        'value' => array(                   
                            esc_html__('Desc','megastore')  => 'DESC',
                            esc_html__('Asc','megastore')  => 'ASC',
                        ),
                        'description' => esc_html__( 'Select Order Type ', 'megastore' ),
                        'edit_field_class'=>'vc_col-sm-6 vc_column',
                    ),
                    array(
                        "type" => "checkbox",
                        "heading" => esc_html__("Tabs",'megastore'),
                        "param_name" => "tabs",
                        "value" => array(
                            esc_html__("New Arrivals",'megastore')    => 'newarrival',
                            esc_html__("Best Seller",'megastore')     => 'bestsell',
                            esc_html__("Most Review",'megastore')     => 'toprate',
                            esc_html__("Most View",'megastore')       => 'mostview',
                            esc_html__("Featured",'megastore')        => 'featured',
                            esc_html__("Trendding",'megastore')       => 'trendding',
                            esc_html__("On Sale",'megastore')         => 'onsale',
                            ),
                    ),                    
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__("Size Thumbnail",'megastore'),
                        "param_name"    => "size",
                        "group"         => esc_html__("Advanced",'megastore'),
                        'description' => esc_html__( 'Enter site thumbnail to crop. [width]x[height]. Example is 300x300', 'megastore' ),
                    ),
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__("Item",'megastore'),
                        "param_name"    => "item",
                        "group"         => esc_html__("Advanced",'megastore'),
                    ),
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__("Item Responsive",'megastore'),
                        "param_name"    => "item_res",
                        "group"         => esc_html__("Advanced",'megastore'),
                        'description' => esc_html__( 'Enter item for screen width(px) format is width:value and separate values by ",". Example is 0:2,600:3,1000:4. Default is auto.', 'megastore' ),
                    ),
                    array(
                        "type"          => "dropdown",
                        "heading"       => esc_html__("Autoplay",'megastore'),
                        "param_name"    => "autoplay",
                        "group"         => esc_html__("Advanced",'megastore'),
                        "value"         => array(
                            esc_html__("False",'megastore') => 'false',
                            esc_html__("True",'megastore') => 'true',
                            )
                    ),
                    array(
                        "type"          => "dropdown",
                        "heading"       => esc_html__("Loop",'megastore'),
                        "param_name"    => "loop",
                        "group"         => esc_html__("Advanced",'megastore'),
                        "value"         => array(
                            esc_html__("True",'megastore') => 'true',
                            esc_html__("False",'megastore') => 'false',
                            )
                    ),
                )
            ));
        }
    }
}