<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */
// Start at 16/6/2016
if(!function_exists('sv_vc_product_cat_list'))
{
    function sv_vc_product_cat_list($attr, $content = false)
    {
        $html = '';
        extract(shortcode_atts(array(
            'style'      => 'home-1',
            'title'      => '',
            'image'      => '',
            'list'       => '',
            'title2'     => '',
            'link'       => '',
        ),$attr));
        if(!empty($list)){
            $data = explode(',', $list);
            $pre = rand(1,100);
            switch ($style) {
                case 'box-list':
                    $html .=    '<div class="block-content-vertical-menu border-left">
                                    <h3 class="head">'.esc_html($title).'</h3>
                                    <div class="inner">';
                    if(!empty($image)) $html .= '<div class="inner-img">
                                                    <a href="'.esc_url($link).'">'.wp_get_attachment_image($image,'full').'</a>
                                                </div>';
                    $html .=            '<ul class="vertical-menu-link">';
                    if(is_array($data)){
                        foreach ($data as $value) {
                            $term = get_term_by( 'slug',$value, 'product_cat' );
                            if(!empty($term) && is_object($term)){
                                $term_link = get_term_link( $term->term_id, 'product_cat' );
                                $html .=            '<li>
                                                        <a href="'.esc_url($term_link).'" title="'.$term->name.'">
                                                            <span class="text">'.$term->name.'</span>
                                                            <span class="count">('.$term->count.')</span>
                                                        </a>
                                                    </li>';
                            }
                        }
                    }
                    $html .=            '</ul>
                                    </div>
                                </div>';
                    break;
                
                default:
                    $html .=    '<div class="block block-category">
                                    <div class="block-head">
                                        <ul class="nav-tab">
                                            <li class="active"><a data-toggle="tab" href="'.esc_url("#".$pre."-tab-categories").'">'.esc_html($title).'</a></li>
                                            <li><a data-toggle="tab" href="'.esc_url("#".$pre."-tab-guarantee").'">'.esc_html($title2).'</a></li>
                                        </ul>
                                    </div>
                                    <div class="block-inner">
                                        <div class="tab-container">
                                            <div id="'.$pre.'-tab-categories" class="tab-panel active">
                                                <ul class="categories">';
                    if(is_array($data)){
                        foreach ($data as $value) {
                            $term = get_term_by( 'slug',$value, 'product_cat' );
                            if(!empty($term) && is_object($term)){
                                $term_link = get_term_link( $term->term_id, 'product_cat' );
                                $html .=            '<li>
                                                        <a href="'.esc_url($term_link).'" title="'.$term->name.'">
                                                            <span class="text">'.$term->name.'</span>
                                                            <span class="count">('.$term->count.')</span>
                                                        </a>
                                                    </li>';
                            }
                        }
                    }
                    $html .=                    '</ul>
                                            </div>
                                            <div id="'.$pre.'-tab-guarantee" class="tab-panel">
                                                <div class="block-guarantee">
                                                    '. wpb_js_remove_wpautop($content, true).'
                                                    <a href="'.esc_url($link).'" class="button-radius">'.esc_html__("Learn more","megastore").'<span class="icon"></span></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>';
                    break;
            }
        }        
        return $html;
    }
}

stp_reg_shortcode('sv_product_cat_list','sv_vc_product_cat_list');
add_action( 'vc_before_init_base','sv_admin_product_cat_list',10,100 );
if ( ! function_exists( 'sv_admin_product_cat_list' ) ) {
    function sv_admin_product_cat_list(){
        vc_map( array(
            "name"      => esc_html__("SV Product category list", 'megastore'),
            "base"      => "sv_product_cat_list",
            "icon"      => "icon-st",
            "category"  => '7Up-theme',
            "params"    => array(
                array(
                    'type'        => 'dropdown',
                    'heading'     => esc_html__( 'Style', 'megastore' ),
                    'param_name'  => 'style',
                    'value'       => array(
                        esc_html__( 'Tab Information', 'megastore' )    => 'home-1',
                        esc_html__( 'Box list', 'megastore' )           => 'box-list',
                        )
                ),
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__( 'Title', 'megastore' ),
                    'param_name'  => 'title',
                ),
                array(
                    'type'        => 'attach_image',
                    'heading'     => esc_html__( 'Image', 'megastore' ),
                    'param_name'  => 'image',
                    'dependency'  => array(
                        'element'   =>  'style',
                        'value'     =>  'box-list',
                        )
                ),
                array(
                    'holder'      => 'div',
                    'heading'     => esc_html__( 'Product Categories', 'megastore' ),
                    'type'        => 'checkbox',
                    'param_name'  => 'list',
                    'value'       => sv_list_taxonomy('product_cat',false)
                ),
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__( 'Title More Information', 'megastore' ),
                    'param_name'  => 'title2',
                    'dependency'  => array(
                        'element'   =>  'style',
                        'value'     =>  'home-1',
                        )
                ),
                array(
                    'type'        => 'textarea_html',
                    'holder'      => 'div',
                    'heading'     => esc_html__( 'Content Information', 'megastore' ),
                    'param_name'  => 'content',
                    'dependency'  => array(
                        'element'   =>  'style',
                        'value'     =>  'home-1',
                        )
                ),
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__( 'Link', 'megastore' ),
                    'param_name'  => 'link',
                    'dependency'  => array(
                        'element'   =>  'style',
                        'value'     =>  'home-1',
                        )
                ),
            )
        ));
    }
}