<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 26/12/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_mailchimp'))
{
    function sv_vc_mailchimp($attr)
    {
        $html = $bg_class = '';
        extract(shortcode_atts(array(
            'title'         => '',
            'placeholder'   => '',
            'submit'        => '',
            'form_id'       => '',
            'bg_image'      => ''
        ),$attr));
        if(!empty($bg_image)){
            $img = wp_get_attachment_image_src( $bg_image ,"full");
            $bg_class = SV_Assets::build_css('background-image: url("'.esc_url($img[0]).'");');
        }
        $form_html = apply_filters('sv_remove_autofill',do_shortcode('[mc4wp_form id="'.$form_id.'"]'));
        $html .=    '<div class="sv-mailchimp-form form-newsletter '.esc_attr($bg_class).'" data-placeholder="'.$placeholder.'" data-submit="'.$submit.'">
                        <h2>'.$title.'</h2>
                        '.$form_html.'
                    </div>';
        return $html;
    }
}

stp_reg_shortcode('sv_mailchimp','sv_vc_mailchimp');

vc_map( array(
    "name"      => esc_html__("SV MailChimp", 'megastore'),
    "base"      => "sv_mailchimp",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            "type" => "textfield",
            'holder'      => 'div',
            "heading" => esc_html__("Title",'megastore'),
            "param_name" => "title",
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Placeholder Input",'megastore'),
            "param_name" => "placeholder",
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Submit Label",'megastore'),
            "param_name" => "submit",
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Form ID",'megastore'),
            "param_name" => "form_id",
        ),
        array(
            "type" => "attach_image",
            "heading" => esc_html__("Image background",'megastore'),
            "param_name" => "bg_image",
        )
    )
));