<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 31/08/15
 * Time: 10:00 AM
 */
/************************************Main Carousel*************************************/
if(!function_exists('sv_vc_category_content'))
{
    function sv_vc_category_content($attr, $content = false)
    {
        $html = $css_class = '';
        extract(shortcode_atts(array(
            'style'      => '',
            'title'      => '',
        ),$attr));
        switch ($style) {
            case 'button-toggle':
                $html .=    '<div class="option3 option4 shop-menu">
                                <div class="main-header">
                                <div class="shop-menu">
                                    <div class="icon">
                                        <span>'.esc_html__("Shop","megastore").'</span>
                                    </div>
                                    <div class="block block-vertical-menu">
                                        <div class="vertical-head">
                                            <h5 class="vertical-title">'.esc_html($title).'</h5>
                                        </div>
                                        <div class="vertical-menu-content">
                                            <ul class="vertical-menu-list">';
                $html .=                        wpb_js_remove_wpautop($content, false);
                $html .=                    '</ul>';
                $html .=                '</div>
                                    </div>
                                </div>
                                </div>
                            </div>';
                break;
            
            default:
                $html .=    '<div class="'.$style.'">
                                <div class="block block-vertical-menu">
                                    <div class="vertical-head">
                                        <h5 class="vertical-title">'.esc_html($title).'</h5>
                                    </div>
                                    <div class="vertical-menu-content">
                                        <ul class="vertical-menu-list">';
                $html .=                    wpb_js_remove_wpautop($content, false);
                $html .=                '</ul>';
                $html .=            '</div>
                                </div>
                            </div>';
                break;
        }        
        return $html;
    }
}
stp_reg_shortcode('sv_category_content','sv_vc_category_content');
vc_map(
    array(
        'name'     => esc_html__( 'SV Categories List Content', 'megastore' ),
        'base'     => 'sv_category_content',
        'category' => esc_html__( '7Up-theme', 'megastore' ),
        'icon'     => 'icon-st',
        'as_parent' => array( 'only' => 'sv_category_content_item' ),
        'content_element' => true,
        'js_view' => 'VcColumnView',
        'params'   => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Style",'megastore'),
                "param_name" => "style",
                "value"     => array(
                    esc_html__("Home 2",'megastore')   => '',
                    esc_html__("Home 3",'megastore')   => 'option3',
                    esc_html__("Home 9",'megastore')   => 'option9',
                    esc_html__("button toggle",'megastore')   => 'button-toggle',
                    )
            ),
            array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Title', 'megastore' ),
                'param_name'  => 'title',
            ),
        )
    )
);

/*******************************************END MAIN*****************************************/

/**************************************BEGIN ITEM************************************/
//Banner item Frontend
if(!function_exists('sv_vc_category_content_item'))
{
    function sv_vc_category_content_item($attr, $content = false)
    {
        $html = $content_hover = '';
        extract(shortcode_atts(array(
            'cat'       => '',
            'color'     => '',
            'image'     => '',
            'style'     => '',
            'mega_content'  => '',
            'title_content'  => '',
            'des_content'  => '',
            'page_id'       => '',
        ),$attr));
        $term = get_term_by( 'slug',$cat, 'product_cat' );
        if(!empty($term) && is_object($term)){
            switch ($mega_content) {
                case 'page':
                    $content_hover .=   '<div class="vertical-dropdown-menu">
                                            <div class="vertical-groups">';
                    $content_hover .=           SV_Template::get_vc_pagecontent($page_id);
                    $content_hover .=       '</div>
                                        </div>';
                    break;
                
                case 'editor':
                    $content_hover .=   '<div class="vertical-dropdown-menu">
                                            <div class="vertical-groups">';
                    $content_hover .=           wpb_js_remove_wpautop($content, true);
                    $content_hover .=       '</div>
                                        </div>';
                    break;

                case 'featured':
                    $col_content = 9;
                    $content_hover .=       '<div class="vertical-dropdown-menu">
                                                <div class="vertical-groups col-sm-12">
                                                    <div class="row">';
                    if(!empty($title_content) || !empty($des_content)){
                    $content_hover .=                   '<div class="col-sm-3">
                                                            <div class="block-content-vertical-menu">';
                    if(!empty($title_content)) $content_hover .='<h3 class="head">'.esc_html($title_content).'</h3>';
                    if(!empty($des_content)) $content_hover .=  '<div class="inner">
                                                                    <p>'.$des_content.'</p>
                                                                </div>';
                    $content_hover .=                       '</div>
                                                        </div>';
                    }
                    else $col_content = 12;
                    $content_hover .=                   '<div class="col-sm-'.$col_content.'">
                                                            <div class="row mega-products">';
                    $args = array(
                        'post_type'         => 'product',
                        'posts_per_page'    => 3,                        
                        );
                    $args['tax_query'][] =  array(
                                                'taxonomy' => 'product_visibility',
                                                'field'    => 'name',
                                                'terms'    => 'featured',
                                                'operator' => 'IN',
                                            );
                    $args['tax_query'][]=array(
                        'taxonomy'  => 'product_cat',
                        'field'     => 'slug',
                        'terms'     => $cat
                    );
                    $query = new WP_Query($args);
                    if($query->have_posts()) {
                        while($query->have_posts()) {
                            $query->the_post();
                            global $product;
                            $content_hover .=                   '<div class="col-sm-4 mega-product">
                                                                    <div class="product-avatar">
                                                                        <a href="'.esc_url(get_the_permalink()).'">'.get_the_post_thumbnail(get_the_ID(),array(212,212)).'</a>
                                                                    </div>
                                                                    <div class="product-name">
                                                                        <a href="'.esc_url(get_the_permalink()).'">'.get_the_title().'</a>
                                                                    </div>
                                                                    <div class="price-box">
                                                                        '.$product->get_price_html().'
                                                                    </div>
                                                                    '.sv_get_rating_html().'
                                                                </div>';
                        }
                    }
                    $content_hover .=                       '</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>';
                    wp_reset_postdata();
                    break;

                default:
                    # code...
                    break;
            }
            $el_class = 'no-content';
            $term_link = get_term_link( $term->term_id, 'product_cat' );
            if(!empty($content_hover)) $el_class = 'parent';
            $html .=    '<li class="cat-item '.$color.'">
                            <a class="'.$el_class.'" href="'.esc_url($term_link).'">'.wp_get_attachment_image($image,'full').$term->name.'</a>
                            '.$content_hover.'
                        </li>';
        }
        return $html;
    }
}
stp_reg_shortcode('sv_category_content_item','sv_vc_category_content_item');

// Banner item
add_action( 'vc_before_init_base','sv_admin_category_content_item',10,100 );
if ( ! function_exists( 'sv_admin_category_content_item' ) ) {
    function sv_admin_category_content_item(){
        vc_map(
            array(
                'name'     => esc_html__( 'Product Category Item', 'megastore' ),
                'base'     => 'sv_category_content_item',
                'icon'     => 'icon-st',
                'content_element' => true,
                'as_child' => array('only' => 'sv_category_content'),
                'params'   => array(
                    array(
                        'type'        => 'dropdown',
                        'holder'      => 'div',
                        'heading'     => esc_html__( 'Product Category', 'megastore' ),
                        'param_name'  => 'cat',
                        'value'       => sv_list_taxonomy('product_cat',true),
                    ),                    
                    array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__( 'Color', 'megastore' ),
                        'param_name'  => 'color',
                        'value'       => array(
                            esc_html__( 'Default', 'megastore' )       => '',
                            esc_html__( 'Pink', 'megastore' )       => 'cat-pink',
                            esc_html__( 'Violet', 'megastore' )     => 'cat-violet',
                            esc_html__( 'Red - Pink', 'megastore' ) => 'cat-red',
                            esc_html__( 'Green', 'megastore' )      => 'cat-green',
                            esc_html__( 'Young green', 'megastore' )=> 'young-green',
                            esc_html__( 'Yellow', 'megastore' )     => 'cat-yellow',
                            esc_html__( 'Orange', 'megastore' )     => 'cat-orange',
                            )
                    ),
                    array(
                        "type" => "attach_image",
                        "heading" => esc_html__("Category image",'megastore'),
                        "param_name" => "image",
                    ),
                    array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__( 'Content hover', 'megastore' ),
                        'param_name'  => 'mega_content',
                        'value'       => array(
                            esc_html__( 'None', 'megastore' )             => '',
                            esc_html__( 'Content page', 'megastore' )     => 'page',
                            esc_html__( 'Content Editor', 'megastore' )   => 'editor',
                            esc_html__( 'Featured Product', 'megastore' ) => 'featured',
                            ),
                    ),
                    array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__( 'Choose page content', 'megastore' ),
                        'param_name'  => 'page_id',
                        'value'       => sv_list_all_page(),
                        'dependency'  => array(
                            'element'   => 'mega_content',
                            'value'   => 'page',
                            )
                    ),
                    array(
                        'type'        => 'textfield',
                        'heading'     => esc_html__( 'Title', 'megastore' ),
                        'param_name'  => 'title_content',
                        'dependency'  => array(
                            'element'   => 'mega_content',
                            'value'   => 'featured',
                            )
                    ),
                    array(
                        'type'        => 'textfield',
                        'heading'     => esc_html__( 'Description', 'megastore' ),
                        'param_name'  => 'des_content',
                        'dependency'  => array(
                            'element'   => 'mega_content',
                            'value'   => 'featured',
                            )
                    ),
                    array(
                        'type'        => 'textarea_html',
                        'heading'     => esc_html__( 'Content', 'megastore' ),
                        'param_name'  => 'content',
                        'dependency'  => array(
                            'element'   => 'mega_content',
                            'value'   => 'editor',
                            )
                    ),
                )
            )
        );
    }
}

/**************************************END ITEM************************************/


//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Sv_Category_Content extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Sv_Category_Content_Item extends WPBakeryShortCode {}
}